/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.progress;

import java.util.HashMap;
import java.util.Map;
import rearth.oracle.Oracle;

public class OracleProgressAPI {
    private static final Map<String, ProgressValidator> REGISTERED_VALIDATORS = new HashMap<String, ProgressValidator>();

    public static boolean IsUnlocked(String bookId, String entryId, String validatorType, String validatorTarget) {
        if (REGISTERED_VALIDATORS.containsKey(validatorType)) {
            ProgressValidator validator = REGISTERED_VALIDATORS.get(validatorType);
            return validator.validate(bookId, entryId, validatorTarget);
        }
        Oracle.LOGGER.warn("tried to validate page requirement for unregistered validator: {}", (Object)validatorType);
        return false;
    }

    public static void RegisterValidator(ProgressValidator validator, String validatorId) {
        REGISTERED_VALIDATORS.put(validatorId, validator);
    }

    @FunctionalInterface
    public static interface ProgressValidator {
        public boolean validate(String var1, String var2, String var3);
    }
}

