/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.content.data_components.ItemCoreDataComponent;
import com.finderfeed.fdbosses.content.entities.geburah.sins.HandleButtonPressSinPacket;
import com.finderfeed.fdbosses.content.entities.geburah.sins.attachment.PlayerSins;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_boss_spawner.MalkuthBossSpawner;
import com.finderfeed.fdbosses.content.items.CoreItem;
import com.finderfeed.fdbosses.content.util.GainLoseValue;
import com.finderfeed.fdbosses.init.BossDataComponents;
import com.finderfeed.fdbosses.init.BossEffects;
import com.finderfeed.fdbosses.init.BossModels;
import com.finderfeed.fdbosses.init.GeburahSins;
import com.finderfeed.fdlib.systems.bedrock.models.FDModel;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.finderfeed.fdlib.util.rendering.renderers.QuadRenderer;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4f;

@EventBusSubscriber(modid="fdbosses", value={Dist.CLIENT})
public class BossClientEvents {
    public static Double cachedGamma = null;
    public static int chesedGazeEffectTick = 0;
    public static int chesedGazeEffectTickO = 0;
    public static int chesedGazeEffectTickMax = 20;
    public static int chesedDarkenEffectTick = 0;
    public static int chesedDarkenEffectTickO = 0;
    public static int chesedDarkenEffectTickMax = 10;
    private static GainLoseValue hellscapeSkyValue = new GainLoseValue(0, 100);
    private static final List<Integer> ALLOWED_TO_USE_BUTTONS = List.of(Integer.valueOf(256));
    public static boolean hasPlayerJumpedUnderSinEffect = false;
    private static FDModel SWORD_MODEL;
    public static final ResourceLocation MALKUTH_FIRE_SWORD;
    private static final ResourceLocation MALKUTH_COWARD_EXECUTION_SQUARE;
    public static final ResourceLocation HELL_FROST_LIGHT;
    public static final ResourceLocation HELL_FIRE_LIGHT;

    @SubscribeEvent
    public static void handleButtonPressSin(InputEvent.Key event) {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        if (player != null && level != null && event.getAction() == 1 && !ALLOWED_TO_USE_BUTTONS.contains(event.getKey()) && !player.isDeadOrDying()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new HandleButtonPressSinPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void handleButtonPressSinMouse(InputEvent.MouseButton.Post event) {
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        if (player != null && level != null && event.getAction() == 1 && !player.isDeadOrDying()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new HandleButtonPressSinPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void postClientTick(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !BossUtil.isPlayerInSurvival((Player)player)) {
            hasPlayerJumpedUnderSinEffect = false;
            return;
        }
        PlayerSins playerSins = PlayerSins.getPlayerSins((Player)player);
        if (playerSins.hasSinActive(GeburahSins.PRESSED_TOO_MANY_BUTTONS_SIN.get())) {
            KeyMapping key = Minecraft.getInstance().options.keyJump;
            if (key.isDown()) {
                if (player.input.jumping) {
                    hasPlayerJumpedUnderSinEffect = true;
                    player.setJumping(false);
                }
            } else {
                hasPlayerJumpedUnderSinEffect = false;
            }
        } else {
            hasPlayerJumpedUnderSinEffect = false;
        }
    }

    @SubscribeEvent
    public static void renderGuiEventTest(RenderGuiEvent.Post event) {
        if (Minecraft.getInstance().player != null) {
            GuiGraphics graphics = event.getGuiGraphics();
            PlayerSins playerSins = PlayerSins.getPlayerSins((Player)Minecraft.getInstance().player);
            int n = playerSins.getSinnedTimes();
        }
    }

    @SubscribeEvent
    public static void collectTooltips(ItemTooltipEvent event) {
        List componentList = event.getToolTip();
        ItemStack itemStack = event.getItemStack();
        if (itemStack.has(BossDataComponents.ITEM_CORE.get())) {
            ItemCoreDataComponent itemCoreDataComponent = (ItemCoreDataComponent)itemStack.get(BossDataComponents.ITEM_CORE);
            ItemCoreDataComponent.CoreType coreType = itemCoreDataComponent.getCoreType();
            CoreItem item = coreType.getItem();
            componentList.add(item.getDefaultInstance().getHoverName().copy().withStyle(Style.EMPTY.withColor(coreType.getTextColor())));
        }
    }

    @SubscribeEvent
    public static void tickEvent(ClientTickEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            BossClientEvents.tickChesedGaze((Player)player);
            BossClientEvents.tickChesedDarken((Player)player);
            BossClientEvents.lowerGammaWhenAnyDarkenEffect((Player)player);
        }
        BossClientEvents.tickHellscapeSky();
    }

    private static void lowerGammaWhenAnyDarkenEffect(Player player) {
        Options options = Minecraft.getInstance().options;
        if (player.hasEffect(MobEffects.NIGHT_VISION) && player.hasEffect(BossEffects.CHESED_DARKEN)) {
            if (cachedGamma == null) {
                cachedGamma = (Double)options.gamma().get();
            }
            options.gamma().set((Object)0.0);
        } else if (cachedGamma != null) {
            options.gamma().set((Object)cachedGamma);
            cachedGamma = null;
        }
    }

    private static void tickChesedGaze(Player player) {
        if (player != null) {
            chesedGazeEffectTickO = chesedGazeEffectTick;
            chesedGazeEffectTick = player.hasEffect(BossEffects.CHESED_GAZE) ? Mth.clamp((int)(chesedGazeEffectTick + 1), (int)0, (int)chesedGazeEffectTickMax) : Mth.clamp((int)(chesedGazeEffectTick - 1), (int)0, (int)chesedGazeEffectTickMax);
        } else {
            chesedGazeEffectTick = 0;
        }
    }

    private static void tickChesedDarken(Player player) {
        if (player != null) {
            chesedDarkenEffectTickO = chesedDarkenEffectTick;
            chesedDarkenEffectTick = player.hasEffect(BossEffects.CHESED_DARKEN) ? Mth.clamp((int)(chesedDarkenEffectTick + 1), (int)0, (int)chesedDarkenEffectTickMax) : Mth.clamp((int)(chesedDarkenEffectTick - chesedDarkenEffectTickMax / 4), (int)0, (int)chesedDarkenEffectTickMax);
        } else {
            chesedDarkenEffectTick = 0;
        }
    }

    @SubscribeEvent
    public static void onFogColor(ViewportEvent.ComputeFogColor event) {
        if (chesedGazeEffectTick != 0) {
            chesedGazeEffectTickMax = 20;
            float p = BossClientEvents.getChesedGazePercent(event.getPartialTick());
            float r = event.getRed();
            float g = event.getGreen();
            float b = event.getBlue();
            event.setRed(r * (1.0f - p));
            event.setGreen(g * (1.0f - p));
            event.setBlue(b * (1.0f - p));
        }
    }

    @SubscribeEvent
    public static void onRenderFog(ViewportEvent.RenderFog event) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        if (chesedGazeEffectTick != 0) {
            event.setCanceled(true);
            float levelTime = (float)(((double)level.getGameTime() + event.getPartialTick()) % 120.0);
            float p = BossClientEvents.getChesedGazePercent(event.getPartialTick());
            float farPlane = event.getFarPlaneDistance();
            float nearPlane = event.getNearPlaneDistance();
            event.setFogShape(FogShape.SPHERE);
            float farPlaneDistance = farPlane * (1.0f - p) + p * (2.0f * ((float)Math.sin((levelTime /= 120.0f) * (float)Math.PI * 2.0f) + 1.0f) / 2.0f + 3.0f);
            float nearPlaneDistance = nearPlane * (1.0f - p);
            event.setFarPlaneDistance(farPlaneDistance);
            event.setNearPlaneDistance(nearPlaneDistance);
        }
    }

    public static float getChesedGazePercent(double pticks) {
        float time = (float)Mth.lerp((double)pticks, (double)chesedGazeEffectTickO, (double)chesedGazeEffectTick);
        float p = FDEasings.easeOut((float)(time / (float)chesedGazeEffectTickMax));
        return p;
    }

    public static float getChesedDarkenPercent(double pticks) {
        float time = (float)Mth.lerp((double)pticks, (double)chesedDarkenEffectTickO, (double)chesedDarkenEffectTick);
        float p = FDEasings.easeOut((float)(time / (float)chesedDarkenEffectTickMax));
        return p;
    }

    @SubscribeEvent
    public static void renderLevelStageEvent(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            BossClientEvents.renderHellscapeSkybox(event);
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            BossClientEvents.renderMalkuthCowardExecution(event);
        }
    }

    private static void renderMalkuthCowardExecution(RenderLevelStageEvent event) {
        float pticks = event.getPartialTick().getGameTimeDeltaPartialTick(false);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isCreative() || player.isSpectator()) {
            return;
        }
        Vec3 forward = player.getForward().multiply(1.0, 0.0, 1.0).normalize();
        Vec3 camPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Vec3 offsetPos = player.getPosition(pticks);
        PoseStack matrices = event.getPoseStack();
        Vec3 offset = offsetPos.subtract(camPos);
        if (!player.hasEffect(BossEffects.MARK_OF_A_COWARD)) {
            return;
        }
        MobEffectInstance instance = player.getEffect(BossEffects.MARK_OF_A_COWARD);
        int duration = instance.getDuration();
        int maxtime = 60;
        int maxtime2 = 7;
        float time = Mth.clamp((float)((float)duration - pticks), (float)0.0f, (float)maxtime);
        float time2 = Mth.clamp((float)((float)duration - pticks), (float)0.0f, (float)maxtime2);
        float p = time / (float)maxtime;
        float p2 = time2 / (float)maxtime2;
        if (p == 0.0f) {
            return;
        }
        float easeOut = FDEasings.easeIn((float)(1.0f - p));
        float easeInP2 = FDEasings.easeOutBack((float)p2);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        FDRenderUtil.bindTexture((ResourceLocation)MALKUTH_COWARD_EXECUTION_SQUARE);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        matrices.pushPose();
        matrices.translate(offset.x, offset.y + 0.001, offset.z);
        matrices.mulPose(Axis.YP.rotationDegrees(easeOut * 360.0f * 6.0f));
        QuadRenderer.start((VertexConsumer)builder).pose(matrices).size((1.0f - p) * 2.0f).color(1.0f, 1.0f, 1.0f, 1.0f - p).direction(new Vec3(0.0, 1.0, 0.0)).renderBack().render();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        BufferUploader.drawWithShader((MeshData)builder.build());
        matrices.popPose();
        RenderSystem.disableDepthTest();
        if (SWORD_MODEL == null) {
            SWORD_MODEL = new FDModel(BossModels.MALKUTH_SWORD.get());
        }
        builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        FDRenderUtil.bindTexture((ResourceLocation)MALKUTH_FIRE_SWORD);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        matrices.pushPose();
        float offsetP = -3.0f * (1.0f - easeInP2);
        matrices.translate(offset.x + forward.x * 0.1, offset.y + 5.0 + (double)offsetP, offset.z + forward.z * 0.1);
        matrices.mulPose(Axis.ZP.rotationDegrees(180.0f));
        matrices.mulPose(Axis.YP.rotationDegrees(easeOut * 360.0f * 6.0f));
        SWORD_MODEL.render(matrices, (VertexConsumer)builder, 0xF000F0, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f - p);
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        BufferUploader.drawWithShader((MeshData)builder.build());
        matrices.popPose();
        RenderSystem.disableDepthTest();
    }

    private static void tickHellscapeSky() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            hellscapeSkyValue.reset();
            return;
        }
        float rad = 30.0f;
        AABB box = new AABB((double)(-rad), (double)(-rad), (double)(-rad), (double)rad, (double)rad, (double)rad).move(player.position());
        Level level = player.level();
        long time = level.getDayTime() % 24000L;
        if (time < 13000L || time > 23000L) {
            hellscapeSkyValue.backward();
            return;
        }
        List spawners = level.getEntitiesOfClass(MalkuthBossSpawner.class, box, arg_0 -> BossClientEvents.lambda$tickHellscapeSky$0((Player)player, rad, arg_0));
        if (spawners.isEmpty()) {
            hellscapeSkyValue.backward();
        } else {
            hellscapeSkyValue.forward();
        }
    }

    private static void renderHellscapeSkybox(RenderLevelStageEvent event) {
        float alpha = hellscapeSkyValue.getPercent(event.getPartialTick().getGameTimeDeltaPartialTick(false));
        if (alpha == 0.0f) {
            return;
        }
        PoseStack matrices = event.getPoseStack();
        ClientLevel level = Minecraft.getInstance().level;
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        float time = (float)level.getGameTime() + event.getPartialTick().getGameTimeDeltaPartialTick(false);
        float flash = (float)(Math.sin(time * 0.025f) + 1.0) / 2.0f;
        flash = flash * 0.8f + 0.2f;
        float flashCounter = (float)(Math.sin(time * 0.025f + (float)Math.PI) + 1.0) / 2.0f;
        flashCounter = flashCounter * 0.8f + 0.2f;
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.blendFunc((int)770, (int)1);
        FDRenderUtil.bindTexture((ResourceLocation)HELL_FIRE_LIGHT);
        matrices.pushPose();
        Matrix4f mat = event.getModelViewMatrix();
        matrices.mulPose(mat);
        matrices.pushPose();
        matrices.mulPose(Axis.ZP.rotationDegrees(-90.0f));
        matrices.mulPose(Axis.XP.rotationDegrees(time * 0.015f));
        matrices.mulPose(Axis.YP.rotationDegrees(20.0f));
        BossClientEvents.renderSkybox(matrices, (VertexConsumer)builder, 300.0f, 1.0f, 1.0f, 1.0f, 0.5f * alpha);
        BossClientEvents.renderSkybox(matrices, (VertexConsumer)builder, 300.0f, 1.0f, 1.0f, 1.0f, flash * alpha);
        BufferUploader.drawWithShader((MeshData)builder.build());
        matrices.popPose();
        matrices.pushPose();
        builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        FDRenderUtil.bindTexture((ResourceLocation)HELL_FROST_LIGHT);
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrices.mulPose(Axis.YP.rotationDegrees(time * 0.015f + 90.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(20.0f));
        BossClientEvents.renderSkybox(matrices, (VertexConsumer)builder, 299.0f, 1.0f, 1.0f, 1.0f, 0.5f * alpha);
        BossClientEvents.renderSkybox(matrices, (VertexConsumer)builder, 299.0f, 1.0f, 1.0f, 1.0f, flashCounter * 0.8f * alpha);
        BufferUploader.drawWithShader((MeshData)builder.build());
        matrices.popPose();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrices.popPose();
    }

    private static void renderSkybox(PoseStack matrices, VertexConsumer vertexConsumer, float boxRadius, float r, float g, float b, float a) {
        Matrix4f m = matrices.last().pose();
        vertexConsumer.addVertex(m, -boxRadius, -boxRadius, -boxRadius).setColor(r, g, b, a).setUv(0.0f, 0.0f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, boxRadius, -boxRadius, -boxRadius).setColor(r, g, b, a).setUv(0.5f, 0.0f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, boxRadius, boxRadius, -boxRadius).setColor(r, g, b, a).setUv(0.5f, 0.25f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, -boxRadius, boxRadius, -boxRadius).setColor(r, g, b, a).setUv(0.0f, 0.25f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, -boxRadius, boxRadius, boxRadius).setColor(r, g, b, a).setUv(0.5f, 0.5f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, boxRadius, boxRadius, boxRadius).setColor(r, g, b, a).setUv(0.0f, 0.5f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, boxRadius, -boxRadius, boxRadius).setColor(r, g, b, a).setUv(0.0f, 0.25f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, -boxRadius, -boxRadius, boxRadius).setColor(r, g, b, a).setUv(0.5f, 0.25f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, boxRadius, -boxRadius, -boxRadius).setColor(r, g, b, a).setUv(0.5f, 0.25f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, boxRadius, -boxRadius, boxRadius).setColor(r, g, b, a).setUv(1.0f, 0.25f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, boxRadius, boxRadius, boxRadius).setColor(r, g, b, a).setUv(1.0f, 0.5f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, boxRadius, boxRadius, -boxRadius).setColor(r, g, b, a).setUv(0.5f, 0.5f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, -boxRadius, boxRadius, -boxRadius).setColor(r, g, b, a).setUv(0.5f, 0.75f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, -boxRadius, boxRadius, boxRadius).setColor(r, g, b, a).setUv(0.0f, 0.75f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, -boxRadius, -boxRadius, boxRadius).setColor(r, g, b, a).setUv(0.0f, 0.5f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, -boxRadius, -boxRadius, -boxRadius).setColor(r, g, b, a).setUv(0.5f, 0.5f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, boxRadius, boxRadius, -boxRadius).setColor(r, g, b, a).setUv(0.0f, 1.0f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, boxRadius, boxRadius, boxRadius).setColor(r, g, b, a).setUv(0.0f, 0.75f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, -boxRadius, boxRadius, boxRadius).setColor(r, g, b, a).setUv(0.5f, 0.75f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, -boxRadius, boxRadius, -boxRadius).setColor(r, g, b, a).setUv(0.5f, 1.0f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, -boxRadius, -boxRadius, -boxRadius).setColor(r, g, b, a).setUv(1.0f, 0.5f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, -boxRadius, -boxRadius, boxRadius).setColor(r, g, b, a).setUv(1.0f, 0.75f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, boxRadius, -boxRadius, boxRadius).setColor(r, g, b, a).setUv(0.5f, 0.75f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
        vertexConsumer.addVertex(m, boxRadius, -boxRadius, -boxRadius).setColor(r, g, b, a).setUv(0.5f, 0.5f).setLight(0xF000F0).setOverlay(OverlayTexture.NO_OVERLAY);
    }

    private static /* synthetic */ boolean lambda$tickHellscapeSky$0(Player player, float rad, MalkuthBossSpawner e) {
        return e.position().distanceTo(player.position()) <= (double)rad;
    }

    static {
        MALKUTH_FIRE_SWORD = FDBosses.location("textures/item/malkuth_sword_fire.png");
        MALKUTH_COWARD_EXECUTION_SQUARE = FDBosses.location("textures/util/malkuth_cowardice_prepare.png");
        HELL_FROST_LIGHT = FDBosses.location("textures/skyboxes/hellscape/hell_frost_light.png");
        HELL_FIRE_LIGHT = FDBosses.location("textures/skyboxes/hellscape/hell_light.png");
    }
}

