/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.content.data_components.ItemCoreDataComponent;
import com.finderfeed.fdbosses.content.entities.IEffectImmune;
import com.finderfeed.fdbosses.content.entities.base.BossSpawnerEntity;
import com.finderfeed.fdbosses.content.entities.chesed_boss.chesed_mini_ray.ChesedMiniRay;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthWeaknessHandler;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.packets.SetClientMalkuthWeaknessAmountPacket;
import com.finderfeed.fdbosses.content.projectiles.MalkuthPlayerFireIceBall;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossDataComponents;
import com.finderfeed.fdbosses.init.BossEffects;
import com.finderfeed.fdbosses.init.BossItems;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="fdbosses")
public class BossEvents {
    public static final TagKey<MobEffect> NOT_CURABLE_EFFECTS = TagKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)FDBosses.location("not_curable"));
    private static final EquipmentSlot[] EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.FEET, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.HEAD};

    @SubscribeEvent
    public static void effectApplicable(MobEffectEvent.Applicable event) {
        if (event.getEntity() instanceof IEffectImmune) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    @SubscribeEvent
    public static void preventRemovingEffects(MobEffectEvent.Remove event) {
        Holder effect = event.getEffect();
        if (effect.is(NOT_CURABLE_EFFECTS) && event.getCure() != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerEnterWorld(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SetClientMalkuthWeaknessAmountPacket(MalkuthWeaknessHandler.getCurrentWeaknessLevel((Player)serverPlayer)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void respawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SetClientMalkuthWeaknessAmountPacket(MalkuthWeaknessHandler.getCurrentWeaknessLevel((Player)serverPlayer)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void preventArenaDestruction(BlockEvent.BreakEvent event) {
        LevelAccessor level = event.getLevel();
        if (!level.isClientSide()) {
            BlockState state;
            boolean v;
            BlockPos pos = event.getPos();
            List spawners = level.getEntitiesOfClass(BossSpawnerEntity.class, new AABB(-100.0, -100.0, -100.0, 100.0, 100.0, 100.0).move(pos.getCenter()));
            if (!spawners.isEmpty() && (v = BossEvents.checkBlockStateAllowedToBreakInArena(state = level.getBlockState(pos)))) {
                return;
            }
            Component message = null;
            for (BossSpawnerEntity bossSpawnerEntity : spawners) {
                if (bossSpawnerEntity.canInteractWithBlockPos(pos)) continue;
                message = bossSpawnerEntity.onArenaDestructionMessage();
                event.setCanceled(true);
                break;
            }
            if (event.isCanceled() && event.getPlayer() != null && message != null) {
                event.getPlayer().sendSystemMessage(message);
            }
        }
    }

    public static boolean checkBlockStateAllowedToBreakInArena(BlockState blockState) {
        List<Pattern> patterns = BossConfigs.BOSS_CONFIG.get().blocksAllowedToBreakInArenaPatterns;
        for (Pattern pattern : patterns) {
            ResourceLocation location = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock());
            String string = location.toString();
            boolean test = pattern.asPredicate().test(string);
            if (!test) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void preventArenaDestruction(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor level = event.getLevel();
        if (!level.isClientSide()) {
            Entity entity;
            BlockPos pos = event.getPos();
            List spawners = level.getEntitiesOfClass(BossSpawnerEntity.class, new AABB(-100.0, -100.0, -100.0, 100.0, 100.0, 100.0).move(pos.getCenter()));
            Component message = null;
            for (BossSpawnerEntity bossSpawnerEntity : spawners) {
                if (bossSpawnerEntity.canInteractWithBlockPos(pos)) continue;
                message = bossSpawnerEntity.onArenaDestructionMessage();
                event.setCanceled(true);
                break;
            }
            if (event.isCanceled() && (entity = event.getEntity()) instanceof Player) {
                Player player = (Player)entity;
                if (message != null) {
                    player.sendSystemMessage(message);
                }
            }
        }
    }

    @SubscribeEvent
    public static void preventArenaDestruction(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        if (!level.isClientSide()) {
            Object object;
            List list = event.getAffectedBlocks();
            ListIterator blockPosIterator = list.listIterator();
            List spawners = level.getEntitiesOfClass(BossSpawnerEntity.class, new AABB(-100.0, -100.0, -100.0, 100.0, 100.0, 100.0).move(event.getExplosion().center()));
            Component message = null;
            block0: while (blockPosIterator.hasNext()) {
                BlockPos pos = (BlockPos)blockPosIterator.next();
                object = spawners.iterator();
                while (object.hasNext()) {
                    BossSpawnerEntity bossSpawnerEntity = (BossSpawnerEntity)((Object)object.next());
                    if (bossSpawnerEntity.canInteractWithBlockPos(pos)) continue;
                    message = bossSpawnerEntity.onArenaDestructionMessage();
                    blockPosIterator.remove();
                    continue block0;
                }
            }
            if (message != null && (object = event.getExplosion().getIndirectSourceEntity()) instanceof Player) {
                Player player = (Player)object;
                player.sendSystemMessage(message);
            }
        }
    }

    @SubscribeEvent
    public static void livingDeathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            DamageSource source;
            Player player = (Player)livingEntity;
            if (!player.level().isClientSide && event.getSource() != null && (source = event.getSource()).is(BossDamageSources.CHESED_LOR_EASTER_EGG_ATTACK)) {
                ItemStack itemStack = Items.BOOK.getDefaultInstance();
                itemStack.set(DataComponents.ITEM_NAME, (Object)player.getName());
                ItemEntity item = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), itemStack);
                player.level().addFreshEntity((Entity)item);
            }
        }
    }

    @SubscribeEvent
    public static void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        ItemCoreDataComponent.CoreType itemCore;
        ItemStack itemStack = event.getItemStack();
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide && itemStack.has(BossDataComponents.ITEM_CORE) && (itemCore = ((ItemCoreDataComponent)itemStack.get(BossDataComponents.ITEM_CORE)).getCoreType()) == ItemCoreDataComponent.CoreType.FIRE_AND_ICE) {
            Vec3 look = player.getLookAngle();
            float speed = 4.0f;
            Vec3 speedVec = look.multiply((double)speed, (double)speed, (double)speed);
            MalkuthAttackType attackType = player.isCrouching() ? MalkuthAttackType.ICE : MalkuthAttackType.FIRE;
            MalkuthPlayerFireIceBall.summon((LivingEntity)player, player.getEyePosition().add(0.0, -0.25, 0.0).add(look), speedVec, attackType, itemStack);
            if (!player.isCreative()) {
                int cooldown = BossConfigs.BOSS_CONFIG.get().itemConfig.playerMalkuthFireballAbilityCooldown;
                player.getCooldowns().addCooldown(itemStack.getItem(), cooldown);
            }
            player.swing(event.getHand(), true);
        }
    }

    @SubscribeEvent
    public static void onEntityAttack(AttackEntityEvent event) {
        Entity entity;
        Player player = event.getEntity();
        ItemStack itemStack = player.getMainHandItem();
        if (!player.level().isClientSide && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (itemStack.has(BossDataComponents.ITEM_CORE)) {
                Item item = itemStack.getItem();
                float power = player.getAttackStrengthScale(0.5f);
                ItemCoreDataComponent core = (ItemCoreDataComponent)itemStack.get(BossDataComponents.ITEM_CORE);
                if (power > 0.5f && core.getCoreType() == ItemCoreDataComponent.CoreType.LIGHTNING && BossUtil.itemContainsModifierForAttribute(itemStack, (Holder<Attribute>)Attributes.ATTACK_DAMAGE)) {
                    float p = Mth.clamp((float)(BossConfigs.BOSS_CONFIG.get().itemConfig.chanceToSummonLightningStrike / 100.0f), (float)0.0f, (float)1.0f);
                    RandomSource randomSource = livingEntity.getRandom();
                    float n = randomSource.nextFloat();
                    if (n < p) {
                        ChesedMiniRay.summon(player.level(), livingEntity, player.getMainHandItem(), (LivingEntity)player);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void deathEvent(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Level level = serverPlayer.level();
            Vec3 pos = serverPlayer.position();
            float radius = 50.0f;
            List spawners = level.getEntitiesOfClass(BossSpawnerEntity.class, new AABB((double)(-radius), (double)(-radius), (double)(-radius), (double)radius, (double)radius, (double)radius).move(pos), bossSpawner -> !bossSpawner.isActive());
            for (BossSpawnerEntity spawner : spawners) {
                Vec3 itemsPos = spawner.getPlayerItemsDropPosition(serverPlayer, pos);
                if (itemsPos == null) continue;
                for (ItemEntity itemEntity : event.getDrops()) {
                    itemEntity.setPos(itemsPos);
                    itemEntity.setDeltaMovement(Vec3.ZERO);
                }
            }
        }
    }

    @SubscribeEvent
    public static void checkInvulnerability(EntityInvulnerabilityCheckEvent event) {
        DamageSource source;
        ServerPlayer serverPlayer;
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)entity).getUseItem().is(BossItems.PHASE_SPHERE.get()) && (source = event.getSource()).is(DamageTypes.IN_WALL)) {
            event.setInvulnerable(true);
        }
    }

    @SubscribeEvent
    public static void justiceCore(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!livingEntity.level().isClientSide) {
            DamageSource source = event.getSource();
            if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                return;
            }
            for (EquipmentSlot slot : EQUIPMENT_SLOTS) {
                ItemCoreDataComponent core;
                ItemStack itemStack = livingEntity.getItemBySlot(slot);
                if (itemStack == null || !itemStack.has(BossDataComponents.ITEM_CORE) || (core = (ItemCoreDataComponent)itemStack.get(BossDataComponents.ITEM_CORE)) == null || core.getCoreType() != ItemCoreDataComponent.CoreType.JUSTICE_CORE) continue;
                float amount = event.getNewDamage();
                CompoundTag data = livingEntity.getPersistentData();
                if (data.contains("fdbosses_last_damage_received")) {
                    float damage = data.getFloat("fdbosses_last_damage_received");
                    data.putFloat("fdbosses_last_damage_received", amount);
                    amount = Math.clamp(amount, 0.0f, damage);
                } else {
                    data.putFloat("fdbosses_last_damage_received", amount);
                }
                int reduction = BossConfigs.BOSS_CONFIG.get().itemConfig.justiceCoreDamageReduction;
                float p = 1.0f - (float)reduction / 100.0f;
                event.setNewDamage(amount *= p);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void livingDamageEvent(LivingIncomingDamageEvent event) {
        LivingEntity damager;
        DamageSource damageSource;
        Entity entity;
        LivingEntity livingEntity = event.getEntity();
        if (!livingEntity.level().isClientSide && (entity = (damageSource = event.getSource()).getEntity()) instanceof LivingEntity && (damager = (LivingEntity)entity).hasEffect(BossEffects.SHOCKED)) {
            float amount = event.getAmount();
            float p = Mth.clamp((float)(1.0f - BossConfigs.BOSS_CONFIG.get().effectConfig.shockDamageReductionPercent / 100.0f), (float)0.0f, (float)1.0f);
            event.setAmount(amount * p);
        }
    }
}

