/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.overlay;

import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.content.entities.geburah.sins.attachment.PlayerSins;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossEffects;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="fdbosses", value={Dist.CLIENT})
public class GeburahSinsOverlay
implements LayeredDraw.Layer {
    public static final ResourceLocation SINS = FDBosses.location("textures/gui/geburah_sin.png");
    private static int ticker = 0;
    private static int oldSinCount = 0;

    public void render(GuiGraphics graphics, DeltaTracker deltaTracker) {
        if (Minecraft.getInstance().player == null || Minecraft.getInstance().options.hideGui || !Minecraft.getInstance().player.hasEffect(BossEffects.SINNER)) {
            return;
        }
        float pticks = deltaTracker.getGameTimeDeltaPartialTick(false);
        Window window = Minecraft.getInstance().getWindow();
        float width = window.getGuiScaledWidth();
        float height = window.getGuiScaledHeight();
        PlayerSins playerSins = PlayerSins.getPlayerSins((Player)Minecraft.getInstance().player);
        int maxSins = BossConfigs.BOSS_CONFIG.get().geburahConfig.maxPlayerSins;
        int sinnedTimes = playerSins.getSinnedTimes();
        float h = height / 2.0f;
        float sinHeight = 25.0f;
        float xOffset = 2.5f;
        if (ticker < 20) {
            float p = Mth.clamp((float)((float)ticker - pticks), (float)0.0f, (float)2.1474836E9f) / 20.0f;
            xOffset -= FDEasings.easeInOut((float)(1.0f - p)) * 32.0f;
        }
        float startOffset = maxSins % 2 == 0 ? sinHeight * (float)(maxSins / 2) : sinHeight / 2.0f + sinHeight * (float)(maxSins / 2);
        for (int i = 0; i < maxSins; ++i) {
            float texOffset = i < sinnedTimes ? 0.5f : 0.0f;
            FDRenderUtil.bindTexture((ResourceLocation)SINS);
            FDRenderUtil.blitWithBlend((PoseStack)graphics.pose(), (float)xOffset, (float)(h - startOffset + (float)i * sinHeight), (float)28.0f, (float)33.0f, (float)0.0f, (float)texOffset, (float)1.0f, (float)0.5f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        }
    }

    @SubscribeEvent
    public static void tickEvent(ClientTickEvent.Pre event) {
        if (Minecraft.getInstance().player == null) {
            ticker = 0;
            oldSinCount = 0;
            return;
        }
        PlayerSins playerSins = PlayerSins.getPlayerSins((Player)Minecraft.getInstance().player);
        int sinnedTimes = playerSins.getSinnedTimes();
        if (sinnedTimes != oldSinCount) {
            oldSinCount = sinnedTimes;
            ticker = 100;
        }
        ticker = Mth.clamp((int)(ticker - 1), (int)0, (int)Integer.MAX_VALUE);
    }
}

