/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.particles.rush_particle;

import com.finderfeed.fdbosses.client.particles.rush_particle.RushParticleOptions;
import com.finderfeed.fdlib.systems.particle.FDParticleRenderType;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class RushParticle
extends Particle {
    private RushParticleOptions rushParticleOptions;
    public static final FDParticleRenderType RENDER_TYPE = new FDParticleRenderType(){

        public void end() {
        }

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.blendFunc((int)770, (int)1);
            BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            return builder;
        }
    };

    public RushParticle(RushParticleOptions rushParticleOptions, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.rushParticleOptions = rushParticleOptions;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.x = x;
        this.y = y;
        this.z = z;
        this.lifetime = rushParticleOptions.getLifetime();
    }

    public void render(VertexConsumer vertex, Camera camera, float pticks) {
        Vec3 pos = new Vec3(Mth.lerp((double)pticks, (double)this.xo, (double)this.x), Mth.lerp((double)pticks, (double)this.yo, (double)this.y), Mth.lerp((double)pticks, (double)this.zo, (double)this.z)).subtract(camera.getPosition());
        float p = ((float)this.age + pticks) / (float)this.lifetime;
        Matrix4f mat = new Matrix4f();
        mat.translate((float)pos.x, (float)pos.y, (float)pos.z);
        FDRenderUtil.applyMovementMatrixRotations((Matrix4f)mat, (Vec3)this.rushParticleOptions.getRushDirection());
        Vec3 n = FDMathUtil.getNormalVectorFromLineToPoint((Vec3)pos, (Vec3)this.rushParticleOptions.getRushDirection().add(pos), (Vec3)Vec3.ZERO);
        Matrix4f mt2 = new Matrix4f();
        FDRenderUtil.applyMovementMatrixRotations((Matrix4f)mt2, (Vec3)this.rushParticleOptions.getRushDirection());
        Vector4f up = new Vector4f(0.0f, 0.0f, 1.0f, 1.0f);
        mt2.transform(up);
        Vector4f left = new Vector4f(1.0f, 0.0f, 0.0f, 1.0f);
        mt2.transform(left);
        Vec3 vup = new Vec3((double)(up.x / up.w), (double)(up.y / up.w), (double)(up.z / up.w));
        Vec3 vleft = new Vec3((double)left.x, (double)left.y, (double)left.z);
        float angle = (float)FDMathUtil.angleBetweenVectors((Vec3)n, (Vec3)vup);
        if (vleft.dot(n) > 0.0) {
            mat.rotateY(angle);
        } else {
            mat.rotateY(-angle);
        }
        float w = this.rushParticleOptions.getWidth() / 2.0f;
        float l = this.rushParticleOptions.getLength();
        FDColor color = this.rushParticleOptions.getColor();
        float addl = FDEasings.easeIn((float)p) * l;
        if (addl >= l) {
            return;
        }
        vertex.addVertex(mat, -w / 2.0f, addl, 0.0f).setColor(color.r, color.g, color.b, color.a);
        vertex.addVertex(mat, w / 2.0f, addl, 0.0f).setColor(color.r, color.g, color.b, color.a);
        vertex.addVertex(mat, w / 2.0f, l, 0.0f).setColor(color.r, color.g, color.b, color.a);
        vertex.addVertex(mat, -w / 2.0f, l, 0.0f).setColor(color.r, color.g, color.b, color.a);
    }

    public ParticleRenderType getRenderType() {
        return RENDER_TYPE;
    }

    protected int getLightColor(float p_107249_) {
        return 0xF000F0;
    }

    public static class Factory
    implements ParticleProvider<RushParticleOptions> {
        @Nullable
        public Particle createParticle(RushParticleOptions rushParticleOptions, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new RushParticle(rushParticleOptions, level, x, y, z, xd, yd, zd);
        }
    }
}

