/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.client.particles.smoke_particle;

import com.finderfeed.fdbosses.client.particles.smoke_particle.BigSmokeParticleOptions;
import com.finderfeed.fdlib.util.math.ComplexEasingFunction;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import org.jetbrains.annotations.Nullable;

public class BigSmokeParticle
extends TextureSheetParticle {
    private BigSmokeParticleOptions options;
    private ComplexEasingFunction easingFunction;
    private float maxQuadSize;
    private float oQuadSize;
    private float cQuadSize;

    public BigSmokeParticle(BigSmokeParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.options = options;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.rCol = options.color.r;
        this.gCol = options.color.g;
        this.bCol = options.color.b;
        this.alpha = options.color.a;
        this.easingFunction = ComplexEasingFunction.builder().addArea((float)options.intOut.inTime, FDEasings::linear).addArea((float)options.intOut.stayTime, FDEasings::one).addArea((float)options.intOut.outTime, FDEasings::reversedLinear).build();
        this.cQuadSize = this.quadSize = this.easingFunction.apply(0.0f) * options.size;
        this.oQuadSize = this.quadSize;
        this.lifetime = options.intOut.fullTime();
        this.maxQuadSize = options.size;
        this.oQuadSize = this.quadSize;
        this.friction = options.friction;
        this.hasPhysics = false;
    }

    public void render(VertexConsumer consumer, Camera camera, float pticks) {
        this.quadSize = FDMathUtil.lerp((float)this.oQuadSize, (float)this.cQuadSize, (float)pticks);
        super.render(consumer, camera, pticks);
    }

    public void tick() {
        double l = Math.sqrt(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd);
        if (l < (double)this.options.minSpeed) {
            this.xd = this.xd / l * (double)this.options.minSpeed;
            this.yd = this.yd / l * (double)this.options.minSpeed;
            this.zd = this.zd / l * (double)this.options.minSpeed;
        }
        this.oQuadSize = this.cQuadSize;
        this.cQuadSize = this.maxQuadSize * this.easingFunction.apply((float)this.age);
        super.tick();
    }

    public ParticleRenderType getRenderType() {
        return FDRenderUtil.ParticleRenderTypes.NORMAL_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<BigSmokeParticleOptions> {
        private SpriteSet set;

        public Factory(SpriteSet set) {
            this.set = set;
        }

        @Nullable
        public Particle createParticle(BigSmokeParticleOptions options, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            BigSmokeParticle particle = new BigSmokeParticle(options, level, x, y, z, xd, yd, zd);
            particle.pickSprite(this.set);
            return particle;
        }
    }
}

