/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.casts;

import com.finderfeed.fdlib.init.FDEDataSerializers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class GeburahCastingCircle
extends Entity {
    public static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.defineId(GeburahCastingCircle.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(GeburahCastingCircle.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Vec3> DIRECTION = SynchedEntityData.defineId(GeburahCastingCircle.class, (EntityDataSerializer)((EntityDataSerializer)FDEDataSerializers.VEC3.get()));
    public static final int FADE_IN = 10;
    public static final int FADE_OUT = 10;
    public boolean wasCast = false;

    public GeburahCastingCircle(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            int castTick = this.getDuration() / 2;
            if (this.tickCount == castTick) {
                if (!this.wasCast) {
                    this.cast();
                    this.wasCast = true;
                }
            } else if (this.tickCount > this.getDuration()) {
                this.discard();
            }
        }
    }

    public abstract void cast();

    public Vec3 getCastDirection() {
        return (Vec3)this.getEntityData().get(DIRECTION);
    }

    public void setDirection(Vec3 direction) {
        this.getEntityData().set(DIRECTION, (Object)direction.normalize());
    }

    public int getDuration() {
        return (Integer)this.getEntityData().get(DURATION);
    }

    public void setCastDuration(int duration) {
        this.getEntityData().set(DURATION, (Object)(20 + duration));
    }

    public void setColor(int color) {
        this.getEntityData().set(COLOR, (Object)color);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DURATION, (Object)20);
        builder.define(COLOR, (Object)-1);
        builder.define(DIRECTION, (Object)new Vec3(0.0, 1.0, 0.0));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("color")) {
            this.getEntityData().set(COLOR, (Object)tag.getInt("color"));
        }
        if (tag.contains("duration")) {
            this.getEntityData().set(DURATION, (Object)tag.getInt("duration"));
        }
        if (tag.contains("dir_x")) {
            this.getEntityData().set(DIRECTION, (Object)new Vec3(tag.getDouble("dir_x"), tag.getDouble("dir_y"), tag.getDouble("dir_z")));
        }
        this.wasCast = tag.getBoolean("was_cast");
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("color", ((Integer)this.getEntityData().get(COLOR)).intValue());
        tag.putInt("duration", ((Integer)this.getEntityData().get(DURATION)).intValue());
        Vec3 dir = (Vec3)this.getEntityData().get(DIRECTION);
        tag.putDouble("dir_x", dir.x);
        tag.putDouble("dir_y", dir.y);
        tag.putDouble("dir_z", dir.z);
        tag.putBoolean("was_cast", this.wasCast);
    }

    public boolean shouldRenderAtSqrDistance(double p_19883_) {
        return true;
    }
}

