/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.chain_trap;

import com.finderfeed.fdbosses.FDBosses;
import com.finderfeed.fdbosses.content.entities.geburah.chain_trap.GeburahChainTrapEntity;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.finderfeed.fdlib.util.rendering.renderers.QuadRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class GeburahChainTrapRenderer
extends EntityRenderer<GeburahChainTrapEntity> {
    public static ResourceLocation CHAIN = FDBosses.location("textures/entities/geburah/geburah_chain.png");
    public static ResourceLocation CHAIN_TRAP = FDBosses.location("textures/entities/geburah/geburah_chain_trap.png");

    public GeburahChainTrapRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(GeburahChainTrapEntity trap, float yaw, float pticks, PoseStack matrices, MultiBufferSource src, int light) {
        matrices.pushPose();
        QuadRenderer.start((VertexConsumer)src.getBuffer(RenderType.text((ResourceLocation)CHAIN_TRAP))).renderBack().size(0.5f).translate(0.0f, 0.01f, 0.0f).rotationDegrees(((float)trap.tickCount + pticks) / 2.0f).pose(matrices).render();
        this.renderChainCircle(trap, yaw, pticks, matrices, src, light);
        this.renderCatching(trap, yaw, pticks, matrices, src, light);
        matrices.popPose();
    }

    public void renderCatching(GeburahChainTrapEntity trap, float yaw, float pticks, PoseStack matrices, MultiBufferSource src, int light) {
        float catchingChainsPercent = -1.0f;
        float restrictingChainsPercent = -1.0f;
        Vec3 center = null;
        float squareRadius = -1.0f;
        if (!trap.getPassengers().isEmpty()) {
            entity = (Entity)trap.getPassengers().getFirst();
            squareRadius = entity.getBbWidth();
            center = entity.getPosition(pticks).add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
            catchingChainsPercent = 1.0f;
            restrictingChainsPercent = 1.0f - Mth.clamp((float)(((float)trap.pullingTime - pticks) / (float)GeburahChainTrapEntity.PULL_TIME), (float)0.0f, (float)1.0f);
        } else {
            entity = trap.getEntityAboutToTrap();
            if (entity != null) {
                squareRadius = entity.getBbWidth();
                center = entity.getPosition(pticks).add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
                catchingChainsPercent = 1.0f - Mth.clamp((float)(((float)trap.catchingTime - pticks) / (float)GeburahChainTrapEntity.PULL_TIME), (float)0.0f, (float)1.0f);
            }
        }
        if (center == null) {
            return;
        }
        if (catchingChainsPercent != -1.0f) {
            float catchingChainOffset = 0.425f;
            catchingChainsPercent = FDEasings.easeOut((float)catchingChainsPercent);
            this.renderChainFromPosToPos(trap, matrices, src, trap.position().add((double)(-catchingChainOffset), 0.0, (double)(-catchingChainOffset)), center.add((double)(-squareRadius / 2.0f), 0.0, (double)(-squareRadius / 2.0f)), catchingChainsPercent);
            this.renderChainFromPosToPos(trap, matrices, src, trap.position().add((double)catchingChainOffset, 0.0, (double)catchingChainOffset), center.add((double)(squareRadius / 2.0f), 0.0, (double)(squareRadius / 2.0f)), catchingChainsPercent);
            this.renderChainFromPosToPos(trap, matrices, src, trap.position().add((double)catchingChainOffset, 0.0, (double)(-catchingChainOffset)), center.add((double)(squareRadius / 2.0f), 0.0, (double)(-squareRadius / 2.0f)), catchingChainsPercent);
            this.renderChainFromPosToPos(trap, matrices, src, trap.position().add((double)(-catchingChainOffset), 0.0, (double)catchingChainOffset), center.add((double)(-squareRadius / 2.0f), 0.0, (double)(squareRadius / 2.0f)), catchingChainsPercent);
        }
        if (restrictingChainsPercent != -1.0f) {
            this.renderChainFromPosToPos(trap, matrices, src, center.add((double)(-squareRadius / 2.0f), 0.0, (double)(squareRadius / 2.0f)), center.add((double)(-squareRadius / 2.0f), 0.0, (double)(-squareRadius / 2.0f)), restrictingChainsPercent);
            this.renderChainFromPosToPos(trap, matrices, src, center.add((double)(squareRadius / 2.0f), 0.0, (double)(-squareRadius / 2.0f)), center.add((double)(squareRadius / 2.0f), 0.0, (double)(squareRadius / 2.0f)), restrictingChainsPercent);
            this.renderChainFromPosToPos(trap, matrices, src, center.add((double)(-squareRadius / 2.0f), 0.0, (double)(-squareRadius / 2.0f)), center.add((double)(squareRadius / 2.0f), 0.0, (double)(-squareRadius / 2.0f)), restrictingChainsPercent);
            this.renderChainFromPosToPos(trap, matrices, src, center.add((double)(squareRadius / 2.0f), 0.0, (double)(squareRadius / 2.0f)), center.add((double)(-squareRadius / 2.0f), 0.0, (double)(squareRadius / 2.0f)), restrictingChainsPercent);
        }
    }

    public void renderChainFromPosToPos(GeburahChainTrapEntity trap, PoseStack matrices, MultiBufferSource src, Vec3 pos1, Vec3 pos2, float p) {
        Vec3 offset1 = pos1.subtract(trap.position());
        Vec3 between = pos2.subtract(pos1);
        VertexConsumer vertex = src.getBuffer(RenderType.text((ResourceLocation)CHAIN));
        matrices.pushPose();
        float length = (float)between.length() * p;
        float size = 0.2f;
        float xSize = size * 0.6f / 2.0f;
        matrices.translate(offset1.x, offset1.y, offset1.z);
        FDRenderUtil.applyMovementMatrixRotations((PoseStack)matrices, (Vec3)between);
        float v = length / size;
        Matrix4f m = matrices.last().pose();
        matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
        m = matrices.last().pose();
        vertex.addVertex(m, xSize, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        vertex.addVertex(m, xSize, length, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        vertex.addVertex(m, -xSize, length, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        vertex.addVertex(m, -xSize, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        vertex.addVertex(m, -xSize, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        vertex.addVertex(m, -xSize, length, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(0.0f, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        vertex.addVertex(m, xSize, length, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        vertex.addVertex(m, xSize, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrices.last(), 0.0f, 0.0f, 1.0f);
        matrices.popPose();
    }

    public void renderChainCircle(GeburahChainTrapEntity trap, float yaw, float pticks, PoseStack matrices, MultiBufferSource src, int light) {
        matrices.pushPose();
        VertexConsumer vertex = src.getBuffer(RenderType.text((ResourceLocation)CHAIN));
        float time = (float)trap.tickCount + pticks;
        time = -time * 5.0f;
        float offset = 0.6f;
        float size = 0.12f;
        int count = 16;
        float angle = 360.0f / (float)count;
        for (int i = 0; i < count; ++i) {
            matrices.pushPose();
            matrices.translate(0.0f, 0.1f, 0.0f);
            matrices.mulPose(Axis.YP.rotationDegrees(angle * (float)i + time));
            matrices.translate(offset, 0.0f, 0.0f);
            matrices.mulPose(Axis.ZP.rotationDegrees(-45.0f));
            QuadRenderer.start((VertexConsumer)vertex).pose(matrices).renderBack().size(size).sizeX(size * 0.6f).render();
            matrices.popPose();
        }
        matrices.popPose();
    }

    public boolean shouldRender(GeburahChainTrapEntity p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        return true;
    }

    public ResourceLocation getTextureLocation(GeburahChainTrapEntity p_114482_) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

