/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.geburah_bell;

import com.finderfeed.fdbosses.content.entities.geburah.GeburahEntity;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDLivingEntity;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GeburahBell
extends FDLivingEntity {
    public static final EntityDataAccessor<Boolean> IS_RED = SynchedEntityData.defineId(GeburahBell.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private UUID geburah;
    private boolean alreadyRang = false;

    public static GeburahBell summon(GeburahEntity geburah, Vec3 pos, Vec3 lookAt, boolean isRed) {
        GeburahBell bell = new GeburahBell(BossEntities.GEBURAH_BELL.get(), geburah.level());
        bell.setPos(pos);
        bell.lookAt(EntityAnchorArgument.Anchor.FEET, lookAt);
        bell.getEntityData().set(IS_RED, (Object)isRed);
        bell.geburah = geburah.getUUID();
        geburah.level().addFreshEntity((Entity)bell);
        return bell;
    }

    public GeburahBell(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
        this.noPhysics = true;
        this.setNoGravity(true);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.geburah == null) {
                this.setRemoved(Entity.RemovalReason.DISCARDED);
            }
        } else if (this.tickCount > 10 && !this.isDeadOrDying()) {
            for (int i = 0; i < 2; ++i) {
                Vec3 offset = new Vec3(1.0, 0.0, 0.0).yRot((float)i * (float)Math.PI + (float)this.tickCount * (float)Math.PI / 32.0f);
                BallParticleOptions options = this.isRed() ? BallParticleOptions.builder().brightness(4).color(1.0f, 0.3f, 0.1f, 1.0f).scalingOptions(0, 0, 20).size(0.1f + this.random.nextFloat() * 0.2f).build() : BallParticleOptions.builder().brightness(4).color(0.1f, 0.8f, 1.0f, 1.0f).scalingOptions(0, 0, 20).size(0.1f + this.random.nextFloat() * 0.2f).build();
                this.level().addParticle((ParticleOptions)options, this.getX() + offset.x, this.getY() + 0.5, this.getZ() + offset.z, (double)this.random.nextFloat() * 0.01 - 0.005, (double)this.random.nextFloat() * 0.01 - 0.005, (double)this.random.nextFloat() * 0.01 - 0.005);
            }
        }
    }

    protected void tickDeath() {
        if (!this.level().isClientSide && this.deathTime == 0) {
            this.getAnimationSystem().startAnimation("MAIN", AnimationTicker.builder(BossAnims.GEBURAH_BELL_RING).build());
        }
        ++this.deathTime;
        if (this.deathTime >= ((Animation)BossAnims.GEBURAH_BELL_RING.get()).getAnimTime() && !this.level().isClientSide() && !this.isRemoved()) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_21239_) {
        return null;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return null;
    }

    public boolean hurt(DamageSource source, float damage) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            GeburahEntity geburah;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!this.alreadyRang && (geburah = this.getGeburah()) != null) {
                geburah.bellRang(this);
                this.alreadyRang = true;
            }
            return super.hurt(source, 10.0f);
        }
        if (source.is(DamageTypes.GENERIC_KILL) || source.is(DamageTypes.FELL_OUT_OF_WORLD)) {
            return super.hurt(source, damage);
        }
        return false;
    }

    public boolean isRed() {
        return (Boolean)this.getEntityData().get(IS_RED);
    }

    public void setState(boolean isRed) {
        this.getEntityData().set(IS_RED, (Object)isRed);
    }

    public GeburahEntity getGeburah() {
        ServerLevel serverLevel;
        Level level = this.level();
        if (level instanceof ServerLevel && (level = (serverLevel = (ServerLevel)level).getEntity(this.geburah)) instanceof GeburahEntity) {
            GeburahEntity redMist = (GeburahEntity)level;
            return redMist;
        }
        return null;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.getEntityData().set(IS_RED, (Object)tag.getBoolean("is_red"));
        if (tag.contains("geburah")) {
            this.geburah = tag.getUUID("geburah");
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("is_red", ((Boolean)this.getEntityData().get(IS_RED)).booleanValue());
        tag.putUUID("geburah", this.geburah);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_RED, (Object)true);
    }

    public void push(Entity p_21294_) {
    }

    public void push(double p_20286_, double p_20287_, double p_20288_) {
    }

    public void push(Vec3 p_347665_) {
    }

    protected void pushEntities() {
    }

    public void setDeltaMovement(double p_20335_, double p_20336_, double p_20337_) {
        super.setDeltaMovement(0.0, 0.0, 0.0);
    }

    public void setDeltaMovement(Vec3 p_20257_) {
        super.setDeltaMovement(Vec3.ZERO);
    }
}

