/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.geburah_earthquake;

import com.finderfeed.fdbosses.content.entities.chesed_boss.earthshatter_entity.EarthShatterSettings;
import com.finderfeed.fdbosses.content.entities.geburah.GeburahEntity;
import com.finderfeed.fdbosses.content.entities.geburah.geburah_earthquake.SpawnRadialEarthquakeOnRadiusPacket;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;

public class GeburahEarthquake
extends Entity
implements AutoSerializable {
    public static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.defineId(GeburahEarthquake.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected HashMap<BlockPos, EarthShatterInstance> clientEarthShatters = new HashMap();
    @SerializableField
    public float damage;
    @SerializableField
    public int endRadius = 10;
    @SerializableField
    public float speed;
    @SerializableField
    public float current = 0.0f;
    @SerializableField
    private int previousRadius = -1;
    @SerializableField
    private int removalTick = 20;
    @SerializableField
    private float angle;
    @SerializableField
    private Vec3 direction;

    public GeburahEarthquake(EntityType<?> type, Level level) {
        super(type, level);
    }

    public static GeburahEarthquake summon(Level level, BlockPos pos, int startRadius, int endRadius, float speed, float damage, Vec3 direction, float angle) {
        GeburahEarthquake radialEarthquakeEntity = new GeburahEarthquake(BossEntities.GEBURAH_EARTHQUAKE.get(), level);
        radialEarthquakeEntity.speed = speed;
        radialEarthquakeEntity.current = startRadius;
        radialEarthquakeEntity.endRadius = endRadius;
        radialEarthquakeEntity.damage = damage;
        radialEarthquakeEntity.entityData.set(RADIUS, (Object)endRadius);
        radialEarthquakeEntity.setPos(pos.getCenter());
        radialEarthquakeEntity.direction = direction.multiply(1.0, 0.0, 1.0).normalize();
        radialEarthquakeEntity.angle = angle;
        level.addFreshEntity((Entity)radialEarthquakeEntity);
        return radialEarthquakeEntity;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.current > (float)this.endRadius) {
                if (this.removalTick-- < 0) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            } else {
                int currentRad = (int)this.current;
                if (currentRad != this.previousRadius) {
                    for (int i = this.previousRadius + 1; i <= currentRad; ++i) {
                        this.spawnAndDamageWithRadius(i);
                    }
                }
                this.previousRadius = currentRad;
                this.current += this.speed;
            }
        } else {
            this.tickEarthShatters();
        }
    }

    private void tickEarthShatters() {
        Iterator<Map.Entry<BlockPos, EarthShatterInstance>> iterator = this.clientEarthShatters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, EarthShatterInstance> pair = iterator.next();
            EarthShatterInstance instance = pair.getValue();
            if (instance.shouldBeRemoved()) {
                iterator.remove();
                continue;
            }
            instance.tick();
        }
    }

    public void spawnAndDamageWithRadius(int rad) {
        AABB box = new AABB((double)(-rad), -0.1, (double)(-rad), (double)rad, 1.0, (double)rad).move(this.position());
        Predicate<LivingEntity> predicate = entity -> {
            Vec3 entityPos = entity.position().multiply(1.0, 0.0, 1.0);
            Vec3 thispos = this.position().multiply(1.0, 0.0, 1.0);
            Vec3 between = entityPos.subtract(thispos);
            double dist = entityPos.distanceTo(thispos);
            return !(entity instanceof GeburahEntity) && Math.abs(dist - (double)rad) <= 1.5 && FDMathUtil.angleBetweenVectors((Vec3)this.direction, (Vec3)between) <= (double)this.angle;
        };
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, box, predicate);
        for (LivingEntity entity2 : entities) {
            entity2.hurt(BossDamageSources.GEBURAH_EARTHQUAKE_SOURCE, this.damage);
        }
        PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)this.level()), null, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (double)Math.max(this.endRadius * 2, 120), (CustomPacketPayload)new SpawnRadialEarthquakeOnRadiusPacket(this, rad, this.direction, this.angle), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void spawnEarthShattersOnRadius(int rad, Vec3 direction, float angleFromDirection) {
        Vec3 b = new Vec3((double)rad, 0.0, 0.0);
        float angle = rad != 0 ? 0.5f / (float)rad : (float)Math.PI * 2;
        BlockPos prevPos = null;
        Vec3 tpos = this.position();
        for (float i = 0.0f; i < (float)Math.PI * 2; i += angle) {
            Vec3 v = b.yRot(i);
            double angleBetween = FDMathUtil.angleBetweenVectors((Vec3)v, (Vec3)direction);
            if (angleBetween > (double)angleFromDirection) continue;
            Vec3 pos = tpos.add(v);
            BlockPos ppos = FDMathUtil.vec3ToBlockPos((Vec3)pos);
            if (!ppos.equals(prevPos) && !this.clientEarthShatters.containsKey(ppos)) {
                Vec3 c = ppos.getCenter();
                Vec3 dir = tpos.subtract(c).multiply(1.0, 0.0, 1.0).normalize().add(0.0, 1.0, 0.0);
                BlockState state = this.level().getBlockState(ppos);
                if (state.isAir()) continue;
                EarthShatterSettings settings = EarthShatterSettings.builder().direction(dir).stayTime(this.random.nextInt(4)).upTime(4 - this.random.nextInt(4)).downTime(4 - this.random.nextInt(4)).build();
                EarthShatterInstance earthShatterInstance = new EarthShatterInstance(settings, state);
                this.clientEarthShatters.put(ppos, earthShatterInstance);
            }
            prevPos = ppos;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326003_) {
        p_326003_.define(RADIUS, (Object)10);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.autoLoad(tag);
        this.entityData.set(RADIUS, (Object)this.endRadius);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        this.autoSave(tag);
    }

    public AABB getBoundingBoxForCulling() {
        int rad = (Integer)this.entityData.get(RADIUS) + 2;
        return new AABB((double)(-rad), (double)(-rad), (double)(-rad), (double)rad, (double)rad, (double)rad).move(this.position());
    }

    public boolean shouldRenderAtSqrDistance(double sqrDistance) {
        return sqrDistance <= 14400.0;
    }

    public static class EarthShatterInstance {
        private EarthShatterSettings settings;
        private BlockState blockState;
        private int tickCount;

        public EarthShatterInstance(EarthShatterSettings earthShatterSettings, BlockState blockState) {
            this.settings = earthShatterSettings;
            this.blockState = blockState;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        public void tick() {
            ++this.tickCount;
        }

        public boolean shouldBeRemoved() {
            return this.tickCount > this.settings.getLifetime();
        }

        public int getTickCount() {
            return this.tickCount;
        }

        public EarthShatterSettings getSettings() {
            return this.settings;
        }
    }
}

