/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.geburah_earthquake;

import com.finderfeed.fdbosses.content.entities.chesed_boss.earthshatter_entity.EarthShatterSettings;
import com.finderfeed.fdbosses.content.entities.geburah.geburah_earthquake.GeburahEarthquake;
import com.finderfeed.fdlib.util.math.ComplexEasingFunction;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;

public class GeburahEarthquakeRenderer
extends EntityRenderer<GeburahEarthquake> {
    public GeburahEarthquakeRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(GeburahEarthquake entity, float yaw, float pticks, PoseStack matrices, MultiBufferSource src, int light) {
        super.render((Entity)entity, yaw, pticks, matrices, src, light);
        HashMap<BlockPos, GeburahEarthquake.EarthShatterInstance> map = entity.clientEarthShatters;
        for (Map.Entry<BlockPos, GeburahEarthquake.EarthShatterInstance> inst : map.entrySet()) {
            this.renderEarthShatter(entity, yaw, pticks, matrices, src, light, inst.getValue(), inst.getKey());
        }
    }

    private void renderEarthShatter(GeburahEarthquake entity, float yaw, float pticks, PoseStack matrices, MultiBufferSource src, int light, GeburahEarthquake.EarthShatterInstance instance, BlockPos shatterPos) {
        BlockPos bpoffset = shatterPos.subtract((Vec3i)entity.getOnPos());
        Vec3 offset = new Vec3((double)bpoffset.getX(), -0.6, (double)bpoffset.getZ());
        BlockRenderDispatcher renderer = Minecraft.getInstance().getBlockRenderer();
        BlockState state = instance.getBlockState();
        EarthShatterSettings settings = instance.getSettings();
        if (instance.getTickCount() < settings.delay) {
            return;
        }
        matrices.pushPose();
        matrices.translate(offset.x, offset.y, offset.z);
        ComplexEasingFunction function = ComplexEasingFunction.builder().addArea((float)settings.upTime, FDEasings::easeOut).addArea((float)settings.stayTime, f -> Float.valueOf(1.0f)).addArea((float)settings.downTime, FDEasings::reversedEaseOut).build();
        float p = function.apply((float)instance.getTickCount() + pticks - (float)settings.delay);
        Vec3 dir = settings.direction;
        Vec3 init = new Vec3(0.0, 1.0, 0.0);
        dir = new Vec3((double)FDMathUtil.lerp((float)((float)init.x), (float)((float)dir.x), (float)p), (double)FDMathUtil.lerp((float)((float)init.y), (float)((float)dir.y), (float)p), (double)FDMathUtil.lerp((float)((float)init.z), (float)((float)dir.z), (float)p));
        matrices.translate(-0.5, (double)(p * settings.upDistance), -0.5);
        matrices.translate(0.5, 0.5, 0.5);
        matrices.scale(1.1f, 1.1f, 1.1f);
        FDRenderUtil.applyMovementMatrixRotations((PoseStack)matrices, (Vec3)dir);
        matrices.translate(-0.5, -0.5, -0.5);
        BlockPos pos = entity.getOnPos().above(2);
        light = LightTexture.pack((int)this.getBlockLightLevel(entity, pos), (int)this.getSkyLightLevel(entity, pos));
        renderer.renderSingleBlock(state, matrices, src, light, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
        matrices.popPose();
    }

    public boolean shouldRender(GeburahEarthquake p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        return true;
    }

    public ResourceLocation getTextureLocation(GeburahEarthquake p_114482_) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

