/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.geburah_weapons.instances;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.content.entities.geburah.GeburahEntity;
import com.finderfeed.fdbosses.content.entities.geburah.geburah_weapons.GeburahWeaponAttack;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossSounds;
import com.finderfeed.fdlib.data_structures.Pair;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class GeburahLasersAttack
extends GeburahWeaponAttack {
    public GeburahLasersAttack(GeburahEntity geburah) {
        super(geburah);
    }

    @Override
    public void onAttackStart() {
        this.geburah.level().playSound(null, this.geburah.getX(), this.geburah.getY(), this.geburah.getZ(), BossSounds.GEBURAH_RAY_SHOT.get(), SoundSource.HOSTILE, 4.0f, 1.0f);
        BossUtil.geburahWeaponsStartLaser((ServerLevel)this.geburah.level(), this.geburah.position(), 120.0, this.geburah);
    }

    @Override
    public void tickAttack() {
        this.geburah.setLaserVisualsState(true);
        if (this.getCurrentTick() % 2 == 0) {
            this.geburah.level().playSound(null, this.geburah.getX(), this.geburah.getY(), this.geburah.getZ(), BossSounds.GEBURAH_RAY_LOOP.get(), SoundSource.HOSTILE, 4.0f, 1.0f);
        }
        List<Pair<Vec3, Vec3>> rotationOld = this.geburah.getCannonsPositionAndDirection(0.0f);
        List<Pair<Vec3, Vec3>> rotationNew = this.geburah.getCannonsPositionAndDirection(1.0f);
        for (int i = 0; i < rotationOld.size(); ++i) {
            Pair<Vec3, Vec3> oldR = rotationOld.get(i);
            Pair<Vec3, Vec3> newR = rotationNew.get(i);
            Vec3 oldDirection = (Vec3)oldR.second;
            Vec3 newDirection = (Vec3)newR.second;
            Vec3 centeredDirection = oldDirection.add(newDirection).normalize();
            float angle = (float)FDMathUtil.angleBetweenVectors((Vec3)oldDirection, (Vec3)newDirection);
            if (Float.isNaN(angle) || angle == 0.0f) {
                angle = 0.05f;
            }
            List<LivingEntity> targets = BossTargetFinder.getEntitiesInArc(LivingEntity.class, this.geburah.level(), this.geburah.position().add(0.0, -0.1, 0.0), new Vec2((float)centeredDirection.x, (float)centeredDirection.z), angle * 2.0f, 2.0f, 32.0f, livingEntity -> !(livingEntity instanceof GeburahEntity));
            float damage = BossUtil.transformDamage(this.geburah.level(), BossConfigs.BOSS_CONFIG.get().geburahConfig.rotatingLaserAttackDamage);
            for (LivingEntity target : targets) {
                target.hurt(BossDamageSources.GEBURAH_LASER_STRIKE_SOURCE, damage);
            }
        }
    }

    @Override
    public boolean hasEnded() {
        return false;
    }

    @Override
    public void onAttackEnd() {
        this.geburah.setLaserVisualsState(false);
    }

    @Override
    public boolean canBeChanged() {
        return true;
    }
}

