/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.judgement_ball_projectile;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.content.entities.geburah.judgement_ball_projectile.JudgementBallExplosionParticleOptions;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDEntity;
import com.finderfeed.fdlib.systems.trails.FDTrailDataGenerator;
import com.finderfeed.fdlib.util.ProjectileMovementPath;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class JudgementBallProjectile
extends FDEntity
implements AutoSerializable {
    @SerializableField
    public ProjectileMovementPath projectileMovementPath;
    @SerializableField
    public float damage = 2.0f;
    private double distanceTraveled = 0.0;
    public FDTrailDataGenerator<JudgementBallProjectile> trail;

    public static JudgementBallProjectile summon(Level level, ProjectileMovementPath projectileMovementPath, float damage) {
        JudgementBallProjectile judgementBallProjectile = new JudgementBallProjectile(BossEntities.GEBURAH_JUDGEMENT_BALL.get(), level);
        judgementBallProjectile.setPos((Vec3)projectileMovementPath.getPositions().getFirst());
        judgementBallProjectile.damage = BossUtil.transformDamage(level, damage);
        judgementBallProjectile.projectileMovementPath = projectileMovementPath;
        projectileMovementPath.tick((Entity)judgementBallProjectile);
        level.addFreshEntity((Entity)judgementBallProjectile);
        return judgementBallProjectile;
    }

    public JudgementBallProjectile(EntityType<?> type, Level level) {
        super(type, level);
        if (level.isClientSide) {
            this.trail = new FDTrailDataGenerator((p, v) -> this.getPosition(v.floatValue()), 10, 0.01f);
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.tickMovementPath();
            this.detectTargetsAndExplode();
            this.setPos(this.position().add(this.getDeltaMovement()));
        } else {
            this.setPos(this.position().add(this.getDeltaMovement()));
            this.particles();
            this.trail.tick((Object)this);
        }
    }

    private void particles() {
        if (this.distanceTraveled > 0.5) {
            this.distanceTraveled = 0.0;
            Vec3 ppos = this.position().subtract(this.getDeltaMovement().scale(1.0));
            this.level().addParticle((ParticleOptions)new JudgementBallExplosionParticleOptions(this.getDeltaMovement(), -10, 0.9f), ppos.x, ppos.y + (double)(this.getBbHeight() / 2.0f), ppos.z, 0.0, 0.0, 0.0);
        } else {
            this.distanceTraveled += new Vec3(this.getX() - this.xo, this.getY() - this.yo, this.getZ() - this.zo).length();
        }
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        this.level().addParticle((ParticleOptions)new JudgementBallExplosionParticleOptions(this.getDeltaMovement(), 10, 2.0f), this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), 0.0, 0.0, 0.0);
    }

    private void tickMovementPath() {
        if (this.projectileMovementPath == null) {
            this.setRemoved(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (!this.projectileMovementPath.isFinished()) {
            this.projectileMovementPath.tick((Entity)this);
        } else {
            this.setRemoved(Entity.RemovalReason.DISCARDED);
        }
    }

    private void detectTargetsAndExplode() {
        AABB box = this.getBoundingBox();
        List targets = this.level().getEntitiesOfClass(LivingEntity.class, box);
        if (!targets.isEmpty()) {
            for (LivingEntity target : targets) {
                target.hurt(BossDamageSources.GEBURAH_JUDGEMENT_BALL_SOURCE, this.damage);
            }
            this.setRemoved(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326003_) {
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.autoSave(tag);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.autoLoad(tag);
    }
}

