/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.justice_hammer;

import com.finderfeed.fdbosses.BossTargetFinder;
import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.client.particles.square_preparation_particle.RectanglePreparationParticleOptions;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDEntity;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.systems.shake.PositionedScreenShakePacket;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.math.ComplexEasingFunction;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class JusticeHammerAttack
extends FDEntity {
    public static int ATTACK_WIDTH = 7;
    public static int ATTACK_LENGTH = 13;
    public static ComplexEasingFunction EASING;
    protected static ComplexEasingFunction EASING2;

    public static JusticeHammerAttack summon(Level level, Vec3 pos, Vec3 direction) {
        JusticeHammerAttack justiceHammerAttack = new JusticeHammerAttack(BossEntities.JUSTICE_HAMMER.get(), level);
        ATTACK_LENGTH = 12;
        ATTACK_WIDTH = 9;
        justiceHammerAttack.setPos(pos);
        justiceHammerAttack.lookAt(EntityAnchorArgument.Anchor.FEET, pos.add(direction.multiply(1.0, 0.0, 1.0).normalize().scale(200.0)));
        level.addFreshEntity((Entity)justiceHammerAttack);
        return justiceHammerAttack;
    }

    public JusticeHammerAttack(EntityType<?> type, Level level) {
        super(type, level);
        if (EASING == null || EASING2 != null) {
            // empty if block
        }
        int animTime = ((Animation)BossAnims.JUSTICE_HAMMER_SMACK.get()).getAnimTime();
        int fadeOut = 10;
        int fadeIn = 30;
        EASING = ComplexEasingFunction.builder().addArea((float)fadeIn, FDEasings::easeIn).addArea((float)(animTime - fadeIn), FDEasings::one).addArea((float)fadeOut, FDEasings::reversedLinear).build();
        EASING2 = ComplexEasingFunction.builder().addArea((float)(animTime - 5), f -> Float.valueOf(0.0f)).addArea(2.0f, FDEasings::easeOut).addArea((float)(fadeOut - 1), FDEasings::reversedEaseOut).build();
        this.getAnimationSystem().startAnimation("MAIN", AnimationTicker.builder(BossAnims.JUSTICE_HAMMER_SMACK).setLoopMode(Animation.LoopMode.HOLD_ON_LAST_FRAME).build());
    }

    public void tick() {
        super.tick();
        int animTime = ((Animation)BossAnims.JUSTICE_HAMMER_SMACK.get()).getAnimTime();
        int attackTime = animTime - 3;
        if (!this.level().isClientSide) {
            if (this.tickCount == attackTime - 3) {
                this.smack(ATTACK_LENGTH, ATTACK_WIDTH);
            } else if (this.tickCount == animTime + 10) {
                this.setRemoved(Entity.RemovalReason.DISCARDED);
            }
            if (this.tickCount == 1) {
                Vec3 direction = this.getLookAngle().multiply(1.0, 0.0, 1.0).normalize();
                Vec3 pos = this.position().subtract(direction.scale((double)((float)ATTACK_LENGTH / 2.0f))).add(0.0, -0.1, 0.0);
                RectanglePreparationParticleOptions options = new RectanglePreparationParticleOptions(direction, ATTACK_LENGTH, (float)ATTACK_WIDTH / 2.0f, ((Animation)BossAnims.JUSTICE_HAMMER_SMACK.get()).getAnimTime() - 10, 10, 10, 0.3f, 0.8f, 1.0f, 0.15f);
                FDLibCalls.sendParticles((ServerLevel)((ServerLevel)this.level()), (ParticleOptions)options, (Vec3)pos.add(0.0, (double)0.15f, 0.0), (double)120.0);
            }
        } else if (this.tickCount == attackTime - 1) {
            float r = 0.3f;
            float g = 0.7f;
            float b = 1.0f;
            for (int i = 0; i < 200; ++i) {
                BallParticleOptions ballParticleOptions = BallParticleOptions.builder().size(0.15f).scalingOptions(0, 0, 5 + this.random.nextInt(5)).friction(0.6f).brightness(2).color(r, g, b).build();
                float xOffset = this.random.nextFloat() * (float)ATTACK_WIDTH - (float)ATTACK_WIDTH / 2.0f;
                float zOffset = this.random.nextFloat() * (float)ATTACK_LENGTH - (float)ATTACK_LENGTH / 2.0f;
                Vec3 offs = new Vec3((double)xOffset, 0.0, (double)zOffset).yRot((float)Math.toRadians(-this.getYRot()));
                this.level().addParticle((ParticleOptions)ballParticleOptions, this.getX() + offs.x, this.getY(), this.getZ() + offs.z, 0.0, (double)this.random.nextFloat(), 0.0);
            }
        }
    }

    private void smack(float lsize, float wsize) {
        Vec3 direction = this.getLookAngle().multiply(1.0, 0.0, 1.0).normalize();
        Vec3 pos = this.position().subtract(direction.scale((double)(lsize / 2.0f))).add(0.0, -0.1, 0.0);
        List<LivingEntity> entities = BossTargetFinder.getEntitiesInHorizontalBox(LivingEntity.class, this.level(), pos, new Vec2((float)direction.x, (float)direction.z), lsize, wsize, 4.0f, living -> true);
        float damage = BossUtil.transformDamage(this.level(), BossConfigs.BOSS_CONFIG.get().geburahConfig.justiceHammerDamage);
        for (LivingEntity entity : entities) {
            entity.hurt(BossDamageSources.GEBURAH_JUSTICE_HAMMER_SOURCE, damage);
        }
        PositionedScreenShakePacket.send((ServerLevel)((ServerLevel)this.level()), (FDShakeData)FDShakeData.builder().outTime(7).stayTime(0).inTime(0).amplitude(0.5f).frequency(10.0f).build(), (Vec3)this.position(), (double)60.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326003_) {
    }
}

