/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.particles.geburah_ray;

import com.finderfeed.fdbosses.content.entities.geburah.particles.geburah_ray.GeburahRayOptions;
import com.finderfeed.fdlib.systems.particle.FDParticleRenderType;
import com.finderfeed.fdlib.util.math.ComplexEasingFunction;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.finderfeed.fdlib.util.rendering.FDRenderUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class GeburahRayParticle
extends Particle {
    public Vec3 rayEnd;
    private GeburahRayOptions options;
    private ComplexEasingFunction easingFunction;
    public static final ParticleRenderType ADDITIVE_TRANSLUCENT = new FDParticleRenderType(){

        @Nullable
        public BufferBuilder begin(Tesselator tesselator, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            RenderSystem.setShader(GameRenderer::getRendertypeLightningShader);
            RenderSystem.blendFunc((int)770, (int)1);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        }

        public void end() {
        }

        public String toString() {
            return "fdbosses:geburah_ray";
        }
    };

    public GeburahRayParticle(GeburahRayOptions rayOptions, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.options = rayOptions;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.rayEnd = rayOptions.rayEnd;
        this.setBoundingBox(new AABB(x, y, z, this.rayEnd.x, this.rayEnd.y, this.rayEnd.z));
        this.lifetime = this.options.rayOptions.inTime + this.options.rayOptions.stayTime + this.options.rayOptions.outTime;
        this.easingFunction = ComplexEasingFunction.builder().addArea((float)this.options.rayOptions.inTime, FDEasings::easeIn).addArea((float)this.options.rayOptions.stayTime, FDEasings::one).addArea((float)this.options.rayOptions.outTime, FDEasings::reversedEaseOut).build();
        this.options.particleProcessor.init((Particle)this);
    }

    public void tick() {
        this.options.particleProcessor.processParticle((Particle)this);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.x += this.xd;
            this.y += this.yd;
            this.z += this.zd;
        }
        this.setBoundingBox(new AABB(this.x, this.y, this.z, this.rayEnd.x, this.rayEnd.y, this.rayEnd.z));
    }

    public void render(VertexConsumer vertex, Camera camera, float pticks) {
        Vec3 pos = new Vec3(Mth.lerp((double)pticks, (double)this.xo, (double)this.x), Mth.lerp((double)pticks, (double)this.yo, (double)this.y), Mth.lerp((double)pticks, (double)this.zo, (double)this.z));
        Vec3 b = this.rayEnd.subtract(pos.x, pos.y, pos.z);
        pos = pos.subtract(camera.getPosition());
        double len = b.length();
        Matrix4f mat = new Matrix4f();
        mat.translate((float)pos.x, (float)pos.y, (float)pos.z);
        FDRenderUtil.applyMovementMatrixRotations((Matrix4f)mat, (Vec3)b);
        Vec3 n = FDMathUtil.getNormalVectorFromLineToPoint((Vec3)pos, (Vec3)b.add(pos), (Vec3)Vec3.ZERO);
        Matrix4f mt2 = new Matrix4f();
        FDRenderUtil.applyMovementMatrixRotations((Matrix4f)mt2, (Vec3)b);
        Vector4f up = new Vector4f(0.0f, 0.0f, 1.0f, 1.0f);
        mt2.transform(up);
        Vector4f left = new Vector4f(1.0f, 0.0f, 0.0f, 1.0f);
        mt2.transform(left);
        Vec3 vup = new Vec3((double)(up.x / up.w), (double)(up.y / up.w), (double)(up.z / up.w));
        Vec3 vleft = new Vec3((double)left.x, (double)left.y, (double)left.z);
        float angle = (float)FDMathUtil.angleBetweenVectors((Vec3)n, (Vec3)vup);
        if (vleft.dot(n) > 0.0) {
            mat.rotateY(angle);
        } else {
            mat.rotateY(-angle);
        }
        float p = this.easingFunction.apply((float)this.age + pticks);
        float alpha = p * this.options.color.a;
        float w = this.options.rayWidth * p;
        for (int zh = 0; zh < 2; ++zh) {
            vertex.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, alpha);
            vertex.addVertex(mat, w, 0.0f, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, 0.0f);
            vertex.addVertex(mat, w, (float)len, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, 0.0f);
            vertex.addVertex(mat, 0.0f, (float)len, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, alpha);
            vertex.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, alpha);
            vertex.addVertex(mat, -w, 0.0f, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, 0.0f);
            vertex.addVertex(mat, -w, (float)len, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, 0.0f);
            vertex.addVertex(mat, 0.0f, (float)len, 0.0f).setColor(this.options.color.r, this.options.color.g, this.options.color.b, alpha);
        }
        mat.translate(0.0f, 0.0f, 0.01f);
        vertex.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
        vertex.addVertex(mat, w * 0.15f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(mat, w * 0.15f, (float)len, 0.0f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(mat, 0.0f, (float)len, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
        vertex.addVertex(mat, 0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
        vertex.addVertex(mat, -w * 0.15f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(mat, -w * 0.15f, (float)len, 0.0f).setColor(1.0f, 1.0f, 1.0f, 0.0f);
        vertex.addVertex(mat, 0.0f, (float)len, 0.0f).setColor(1.0f, 1.0f, 1.0f, alpha);
        mat.translate(0.0f, 0.0f, 0.01f);
        this.renderInitialEffect(vertex, mat, 0, pticks, 4, (float)len, this.options.rayWidth * 0.15f);
        mat.translate(0.0f, 0.0f, 0.01f);
        this.renderInitialEffect(vertex, mat, 2, pticks, 4, (float)len, this.options.rayWidth * 0.3f);
    }

    private void renderInitialEffect(VertexConsumer vertex, Matrix4f mat, int ageDelay, float pticks, int effectLength, float rayLength, float effectWidth) {
        if (this.age < ageDelay) {
            return;
        }
        float effectP = Math.clamp((float)(this.age - ageDelay) + pticks, 0.0f, (float)effectLength) / (float)effectLength;
        effectP = FDEasings.easeIn((float)effectP);
        float maxXBorder = this.options.rayWidth;
        float currentXStartPos = Math.max(0.0f, (maxXBorder + effectWidth) * effectP - effectWidth);
        float currentXEndPos = Math.min(maxXBorder * effectP + effectWidth, maxXBorder);
        vertex.addVertex(mat, currentXStartPos, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vertex.addVertex(mat, currentXEndPos, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vertex.addVertex(mat, currentXEndPos, rayLength, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vertex.addVertex(mat, currentXStartPos, rayLength, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vertex.addVertex(mat, -currentXStartPos, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vertex.addVertex(mat, -currentXEndPos, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vertex.addVertex(mat, -currentXEndPos, rayLength, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        vertex.addVertex(mat, -currentXStartPos, rayLength, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public ParticleRenderType getRenderType() {
        return ADDITIVE_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<GeburahRayOptions> {
        @Nullable
        public Particle createParticle(GeburahRayOptions type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new GeburahRayParticle(type, level, x, y, z, xd, yd, zd);
        }
    }
}

