/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.sins;

import com.finderfeed.fdbosses.BossUtil;
import com.finderfeed.fdbosses.content.entities.geburah.sins.GeburahTriggerSinEffectPacket;
import com.finderfeed.fdbosses.content.entities.geburah.sins.attachment.ActivePlayerSinInstance;
import com.finderfeed.fdbosses.content.entities.geburah.sins.attachment.PlayerSin;
import com.finderfeed.fdbosses.content.entities.geburah.sins.attachment.PlayerSins;
import com.finderfeed.fdbosses.content.util.WorldBox;
import com.finderfeed.fdbosses.init.BossConfigs;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.GeburahSins;
import java.util.Iterator;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="fdbosses")
public class PlayerSinsHandler {
    @SubscribeEvent
    public static void tickPlayer(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide) {
            PlayerSinsHandler.tickPlayerSins(player);
        }
    }

    public static void tickPlayerSins(Player player) {
        PlayerSins playerSins = PlayerSins.getPlayerSins(player);
        Iterator<ActivePlayerSinInstance> instanceIterator = playerSins.getActiveSins().iterator();
        int currentCooldown = playerSins.getSinGainCooldown();
        playerSins.setSinGainCooldown(Mth.clamp((int)(currentCooldown - 1), (int)0, (int)Integer.MAX_VALUE));
        while (instanceIterator.hasNext()) {
            ActivePlayerSinInstance activeSin = instanceIterator.next();
            WorldBox worldBox = activeSin.getSinActiveBox();
            if (worldBox.isEntityInBox((Entity)player)) {
                PlayerSin sin = activeSin.getSin();
                sin.playerTick(player, activeSin);
                activeSin.setActiveSinTime(activeSin.getActiveSinTime() + 1);
                continue;
            }
            instanceIterator.remove();
        }
    }

    public static void setActiveSins(ServerPlayer player, List<ActivePlayerSinInstance> instances) {
        PlayerSins playerSins = PlayerSins.getPlayerSins((Player)player);
        playerSins.setActiveSins(instances);
        PlayerSins.setPlayerSins((Player)player, playerSins);
    }

    public static void sin(ServerPlayer player, int cooldown) {
        PlayerSinsHandler.sin(player, cooldown, 1.0f, 1);
    }

    public static void sin(ServerPlayer player, int cooldown, float soundPitch, int amount) {
        PlayerSins playerSins = PlayerSins.getPlayerSins((Player)player);
        if (!playerSins.isGainingSinsOnCooldown() && BossUtil.isPlayerInSurvival((Player)player) && player.isAlive()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new GeburahTriggerSinEffectPacket(soundPitch), (CustomPacketPayload[])new CustomPacketPayload[0]);
            int sinnedTimes = playerSins.getSinnedTimes();
            if (sinnedTimes + amount >= BossConfigs.BOSS_CONFIG.get().geburahConfig.maxPlayerSins) {
                player.hurt(BossDamageSources.GEBURAH_SINNED_TOO_MUCH_SOURCE, Float.MAX_VALUE);
            } else {
                playerSins.setSinnedTimes(sinnedTimes + amount);
                playerSins.setSinGainCooldown(cooldown);
                PlayerSins.setPlayerSins((Player)player, playerSins);
            }
        }
    }

    @SubscribeEvent
    public static void jump(LivingEvent.LivingJumpEvent event) {
        ServerPlayer player;
        PlayerSins playerSins;
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer && (playerSins = PlayerSins.getPlayerSins((Player)(player = (ServerPlayer)entity))).hasSinActive(GeburahSins.JUMPING_SIN.get())) {
            PlayerSinsHandler.sin(player, 40);
        }
    }
}

