/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.geburah.sins.attachment;

import com.finderfeed.fdbosses.content.entities.geburah.sins.attachment.ActivePlayerSinInstance;
import com.finderfeed.fdbosses.content.entities.geburah.sins.attachment.PlayerSin;
import com.finderfeed.fdbosses.init.BossDataAttachments;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class PlayerSins {
    public static final Codec<PlayerSins> CODEC = RecordCodecBuilder.create(p -> p.group((App)Codec.list(ActivePlayerSinInstance.CODEC).fieldOf("active_sins").forGetter(v -> v.activeSins), (App)Codec.INT.fieldOf("sinned_times").forGetter(v -> v.sinnedTimes), (App)Codec.INT.fieldOf("cooldown").forGetter(v -> v.sinGainCooldown)).apply((Applicative)p, PlayerSins::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayerSins> STREAM_CODEC = StreamCodec.composite((StreamCodec)ActivePlayerSinInstance.STREAM_CODEC.apply(ByteBufCodecs.list()), v -> v.activeSins, (StreamCodec)ByteBufCodecs.INT, v -> v.sinnedTimes, (StreamCodec)ByteBufCodecs.INT, v -> v.sinGainCooldown, PlayerSins::new);
    private List<ActivePlayerSinInstance> activeSins = new ArrayList<ActivePlayerSinInstance>();
    private int sinnedTimes = 0;
    private int sinGainCooldown = 0;

    public PlayerSins() {
    }

    protected PlayerSins(List<ActivePlayerSinInstance> activeSins, int sinnedTimes, int cooldown) {
        this(activeSins);
        this.sinnedTimes = sinnedTimes;
        this.sinGainCooldown = cooldown;
    }

    public PlayerSins(PlayerSins other) {
        this.activeSins = new ArrayList<ActivePlayerSinInstance>(other.activeSins);
        this.sinnedTimes = other.sinnedTimes;
        this.sinGainCooldown = other.sinGainCooldown;
    }

    public PlayerSins(List<ActivePlayerSinInstance> activeSins) {
        this.activeSins = new ArrayList<ActivePlayerSinInstance>(activeSins);
    }

    public static PlayerSins getPlayerSins(Player player) {
        return (PlayerSins)player.getData(BossDataAttachments.PLAYER_SINS);
    }

    public static void setPlayerSins(Player player, PlayerSins playerSins) {
        player.setData(BossDataAttachments.PLAYER_SINS, (Object)playerSins);
    }

    public boolean hasSinActive(PlayerSin playerSin) {
        return this.activeSins.stream().anyMatch(inst -> inst.getSin() == playerSin);
    }

    public boolean hasExactlyThisSins(Collection<PlayerSin> playerSins) {
        int count = 0;
        for (ActivePlayerSinInstance sin : this.getActiveSins()) {
            PlayerSin s = sin.getSin();
            if (!playerSins.contains(s)) continue;
            ++count;
        }
        return count == playerSins.size() && playerSins.size() == this.getActiveSins().size();
    }

    public void setActiveSins(List<ActivePlayerSinInstance> instances) {
        this.activeSins = new ArrayList<ActivePlayerSinInstance>(instances);
    }

    public ActivePlayerSinInstance getSin(PlayerSin playerSin) {
        ActivePlayerSinInstance instance = null;
        for (ActivePlayerSinInstance sin : this.activeSins) {
            if (sin.getSin() != playerSin) continue;
            instance = sin;
            break;
        }
        return instance;
    }

    public int getSinnedTimes() {
        return this.sinnedTimes;
    }

    public void setSinnedTimes(int sinnedTimes) {
        this.sinnedTimes = sinnedTimes;
    }

    public List<ActivePlayerSinInstance> getActiveSins() {
        return this.activeSins;
    }

    public int getSinGainCooldown() {
        return this.sinGainCooldown;
    }

    public void setSinGainCooldown(int sinGainCooldown) {
        this.sinGainCooldown = Mth.clamp((int)sinGainCooldown, (int)0, (int)Integer.MAX_VALUE);
    }

    public boolean isGainingSinsOnCooldown() {
        return this.sinGainCooldown > 0;
    }
}

