/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_boulder;

import com.finderfeed.fdbosses.client.BossParticles;
import com.finderfeed.fdbosses.client.particles.GravityParticleOptions;
import com.finderfeed.fdbosses.client.particles.stripe_particle.StripeParticleOptions;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthBossBuddy;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthDamageSource;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.init.BossDamageSources;
import com.finderfeed.fdbosses.init.BossEntities;
import com.finderfeed.fdbosses.init.BossEntityDataSerializers;
import com.finderfeed.fdbosses.packets.SlamParticlesPacket;
import com.finderfeed.fdlib.FDHelpers;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.util.FDColor;
import com.finderfeed.fdlib.util.FDProjectile;
import com.finderfeed.fdlib.util.ProjectileMovementPath;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector3f;

public class MalkuthBoulderEntity
extends FDProjectile
implements AutoSerializable {
    public static final EntityDataAccessor<MalkuthAttackType> MALKUTH_ATTACK_TYPE = SynchedEntityData.defineId(MalkuthBoulderEntity.class, (EntityDataSerializer)((EntityDataSerializer)BossEntityDataSerializers.MALKUTH_ATTACK_TYPE.get()));
    public static final EntityDataAccessor<Integer> PREPARE_TIME = SynchedEntityData.defineId(MalkuthBoulderEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> PREPARE_HEIGHT = SynchedEntityData.defineId(MalkuthBoulderEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    @SerializableField
    private ProjectileMovementPath movementPath;
    @SerializableField
    private boolean shouldMoveToTarget = false;
    @SerializableField
    private float damage = 0.0f;
    private boolean removeNextTick = false;

    public static MalkuthBoulderEntity summon(Level level, Vec3 pos, int prepareTime, float prepareHeight, ProjectileMovementPath movementPath, MalkuthAttackType malkuthAttackType, float damage) {
        MalkuthBoulderEntity malkuthBoulderEntity = new MalkuthBoulderEntity(BossEntities.MALKUTH_BOULDER.get(), level);
        malkuthBoulderEntity.setPos(pos);
        malkuthBoulderEntity.movementPath = movementPath;
        malkuthBoulderEntity.entityData.set(PREPARE_TIME, (Object)prepareTime);
        malkuthBoulderEntity.entityData.set(PREPARE_HEIGHT, (Object)Float.valueOf(prepareHeight));
        malkuthBoulderEntity.setMalkuthAttackType(malkuthAttackType);
        malkuthBoulderEntity.damage = damage;
        level.addFreshEntity((Entity)malkuthBoulderEntity);
        return malkuthBoulderEntity;
    }

    public MalkuthBoulderEntity(EntityType<? extends AbstractHurtingProjectile> type, Level level) {
        super(type, level);
        this.noPhysics = true;
        this.setNoGravity(true);
    }

    public void tick() {
        if (!this.level().isClientSide && this.removeNextTick) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        super.tick();
        if (this.level().isClientSide) {
            Vec3 between = this.position().subtract(new Vec3(this.xo, this.yo, this.zo));
            Vec3 nb = between.normalize();
            double dist = 0.0;
            double b = between.length();
            do {
                if (this.tickCount <= this.getPrepareTime() / 2) continue;
                int particleCount = this.getDeltaMovement().length() > 0.0 ? 20 : 5;
                for (int i = 0; i < particleCount; ++i) {
                    float rnd;
                    Object options = this.getMalkuthAttackType().isFire() ? ((double)(rnd = this.random.nextFloat()) > 0.5 ? new GravityParticleOptions(BossParticles.FLAME_WITH_STONE.get(), 20 + this.random.nextInt(4), 0.15f + this.random.nextFloat() * 0.2f, 1.5999999f, 2.0f, true) : ParticleTypes.LAVA) : new GravityParticleOptions(BossParticles.ICE_CHUNK.get(), 20 + this.random.nextInt(4), 0.5f + this.random.nextFloat() * 0.2f, 1.5999999f, 2.0f, true);
                    if (this.getDeltaMovement().length() > 0.0 && this.random.nextFloat() > 0.3f) {
                        if (this.getMalkuthAttackType().isIce()) {
                            rc = this.random.nextFloat() * 0.2f;
                            float gc = 0.7f + this.random.nextFloat() * 0.1f;
                            bc = 0.9f + this.random.nextFloat() * 0.1f;
                            options = BallParticleOptions.builder().color(rc, gc, bc).size(0.2f + this.random.nextFloat() * 0.2f).scalingOptions(0, 0, 20).friction(0.7f).build();
                        } else {
                            rc = 0.9f + this.random.nextFloat() * 0.1f;
                            float gc = 0.2f + this.random.nextFloat() * 0.2f;
                            bc = this.random.nextFloat() * 0.2f;
                            options = BallParticleOptions.builder().color(rc, gc, bc).size(0.2f + this.random.nextFloat() * 0.2f).scalingOptions(0, 0, 20).friction(0.8f).build();
                        }
                    }
                    Vec3 rnd2 = this.position().add((double)this.random.nextFloat() * 3.5 - 1.75, (double)this.random.nextFloat() * 3.5 - 1.75, (double)this.random.nextFloat() * 3.5 - 1.75).add(nb.reverse().multiply(dist, dist, dist));
                    Vec3 speed = this.getDeltaMovement().multiply((double)0.15f, (double)0.15f, (double)0.15f);
                    this.level().addParticle((ParticleOptions)options, rnd2.x, rnd2.y, rnd2.z, speed.x, speed.y, speed.z);
                }
            } while ((dist += 1.75) < b);
            if (this.tickCount == 1) {
                for (int i = 0; i < 10; ++i) {
                    this.stripeParticles(MalkuthAttackType.FIRE);
                    this.stripeParticles(MalkuthAttackType.ICE);
                }
            }
        } else {
            if (this.isAllowedToMoveToTarget()) {
                if (!this.movementPath.isFinished()) {
                    this.movementPath.tick((Entity)this);
                } else {
                    this.removeNextTick = true;
                }
                this.tickDamage();
            }
            if (this.tickCount == 1) {
                SlamParticlesPacket packet = new SlamParticlesPacket(new SlamParticlesPacket.SlamData(this.getOnPos(), this.position().add(0.0, 0.5, 0.0), new Vec3(1.0, 0.0, 0.0)).maxAngle((float)Math.PI * 2).maxSpeed(0.3f).collectRadius(2).maxParticleLifetime(30).count(20).maxVerticalSpeedEdges(0.15f).maxVerticalSpeedCenter(0.15f));
                PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private void tickDamage() {
        Vec3 movement = this.getDeltaMovement();
        if (movement.equals((Object)Vec3.ZERO)) {
            return;
        }
        float bbwidthinflate = this.getBbWidth() / 2.0f;
        float bbHeight = this.getBbHeight();
        Vec3 startPos = this.position().add(0.0, (double)(bbHeight / 2.0f), 0.0);
        Vec3 endPos = startPos.add(movement);
        List entities = FDHelpers.traceEntities((Level)this.level(), (Vec3)startPos, (Vec3)endPos, (double)bbwidthinflate, v -> !(v instanceof MalkuthBossBuddy));
        for (Entity target : entities) {
            if (!(target instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)target;
            target.hurt((DamageSource)new MalkuthDamageSource(BossDamageSources.MALKUTH_SIDE_ROCKS_SOURCE, this.getMalkuthAttackType(), 34), this.damage);
        }
    }

    private void stripeParticles(MalkuthAttackType type) {
        float rndRadius = 2.0f + FDEasings.easeOut((float)this.random.nextFloat()) * 2.0f;
        Vec3 rnd = new Vec3((double)rndRadius, 0.0, 0.0).yRot((float)Math.PI * 2 * this.random.nextFloat());
        Vec3 dir = rnd.normalize();
        float startOffsetRand = 0.1f + this.random.nextFloat() * 0.5f;
        Vec3 startOffset = dir.multiply((double)startOffsetRand, (double)startOffsetRand, (double)startOffsetRand);
        Vec3 stripePos = this.position().add(startOffset);
        Vector3f colFire = MalkuthEntity.getMalkuthAttackPreparationParticleColor(type);
        FDColor fireColorStart = new FDColor(colFire.x, colFire.y - this.random.nextFloat() * 0.1f - 0.3f, colFire.z, 0.5f);
        FDColor fireColor = new FDColor(colFire.x, colFire.y + this.random.nextFloat() * 0.1f, colFire.z, 1.0f);
        float firstPointOffset = 1.0f + this.random.nextFloat() * 1.0f;
        StripeParticleOptions stripeParticleOptions = StripeParticleOptions.builder().endColor(fireColor).startColor(fireColorStart).lifetime(5 + this.random.nextInt(5)).lod(50).scale(0.1f).stripePercentLength(0.75f).endOutPercent(0.25f).startInPercent(0.25f).offsets(new Vec3((double)0.01f, 0.0, 0.0), dir.multiply((double)firstPointOffset, 0.0, (double)firstPointOffset).add(0.0, 0.5, 0.0), rnd.add(0.0, (double)(1.5f + this.random.nextFloat() * 2.0f), 0.0)).build();
        this.level().addParticle((ParticleOptions)stripeParticleOptions, true, stripePos.x, stripePos.y, stripePos.z, 0.0, 0.0, 0.0);
    }

    public void setShouldMoveToTarget(boolean shouldMoveToTarget) {
        this.shouldMoveToTarget = shouldMoveToTarget;
    }

    public boolean isAllowedToMoveToTarget() {
        return this.shouldMoveToTarget;
    }

    public void setMalkuthAttackType(MalkuthAttackType malkuthAttackType) {
        this.entityData.set(MALKUTH_ATTACK_TYPE, (Object)malkuthAttackType);
    }

    public MalkuthAttackType getMalkuthAttackType() {
        return (MalkuthAttackType)((Object)this.entityData.get(MALKUTH_ATTACK_TYPE));
    }

    protected int getPrepareTime() {
        return (Integer)this.entityData.get(PREPARE_TIME);
    }

    protected void setPrepareTime(int time) {
        this.entityData.set(PREPARE_TIME, (Object)time);
    }

    public float getPrepareHeight() {
        return ((Float)this.entityData.get(PREPARE_HEIGHT)).floatValue();
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326181_) {
        super.defineSynchedData(p_326181_);
        p_326181_.define(MALKUTH_ATTACK_TYPE, (Object)MalkuthAttackType.FIRE);
        p_326181_.define(PREPARE_TIME, (Object)20);
        p_326181_.define(PREPARE_HEIGHT, (Object)Float.valueOf(3.0f));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.autoLoad(tag);
        if (tag.contains("mtype")) {
            this.setMalkuthAttackType(MalkuthAttackType.valueOf(tag.getString("mtype")));
        }
        this.entityData.set(PREPARE_TIME, (Object)tag.getInt("prepareTime"));
        this.entityData.set(PREPARE_HEIGHT, (Object)Float.valueOf(tag.getFloat("prepareHeight")));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.autoSave(tag);
        tag.putString("mtype", this.getMalkuthAttackType().name());
        tag.putInt("prepareTime", ((Integer)this.entityData.get(PREPARE_TIME)).intValue());
        tag.putFloat("prepareHeight", ((Float)this.entityData.get(PREPARE_HEIGHT)).floatValue());
    }
}

