/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_repair_crystal;

import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthAttackType;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.MalkuthEntity;
import com.finderfeed.fdbosses.content.entities.malkuth_boss.malkuth_repair_crystal.MalkuthRepairEntity;
import com.finderfeed.fdbosses.init.BossAnims;
import com.finderfeed.fdbosses.init.BossEntityDataSerializers;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.entity.FDEntity;
import com.finderfeed.fdlib.util.client.particles.ball_particle.BallParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public class MalkuthRepairCrystal
extends FDEntity
implements AutoSerializable {
    public static final EntityDataAccessor<MalkuthAttackType> CRYSTAL_TYPE = SynchedEntityData.defineId(MalkuthRepairCrystal.class, (EntityDataSerializer)((EntityDataSerializer)BossEntityDataSerializers.MALKUTH_ATTACK_TYPE.get()));
    public static final EntityDataAccessor<Boolean> HIDDEN = SynchedEntityData.defineId(MalkuthRepairCrystal.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public MalkuthRepairCrystal(EntityType<?> type, Level level) {
        super(type, level);
        this.getAnimationSystem().startAnimation("MAIN", AnimationTicker.builder(BossAnims.MALKUTH_REPAIR_CRYSTAL_SUMMON).setLoopMode(Animation.LoopMode.ONCE).build());
    }

    public void tick() {
        super.tick();
    }

    public void setHidden(boolean hidden) {
        this.entityData.set(HIDDEN, (Object)hidden);
        if (hidden) {
            this.getAnimationSystem().startAnimation("MAIN", AnimationTicker.builder(BossAnims.MALKUTH_REPAIR_CRYSTAL_SUMMON).setLoopMode(Animation.LoopMode.HOLD_ON_LAST_FRAME).setToNullTransitionTime(0).reversed().build());
        } else {
            this.getAnimationSystem().startAnimation("MAIN", AnimationTicker.builder(BossAnims.MALKUTH_REPAIR_CRYSTAL_SUMMON).setLoopMode(Animation.LoopMode.HOLD_ON_LAST_FRAME).setToNullTransitionTime(0).build());
        }
    }

    public boolean isHidden() {
        return (Boolean)this.entityData.get(HIDDEN);
    }

    public MalkuthAttackType getCrystalType() {
        return (MalkuthAttackType)((Object)this.entityData.get(CRYSTAL_TYPE));
    }

    public void setCrystalType(MalkuthAttackType crystalType) {
        this.entityData.set(CRYSTAL_TYPE, (Object)crystalType);
    }

    public void destroyAndSummonRepairMaterial() {
        if (this.isHidden()) {
            return;
        }
        MalkuthRepairEntity malkuthRepairEntity = MalkuthRepairEntity.summon(this.level(), this.position().add(0.0, 3.0, 0.0), (MalkuthAttackType)((Object)this.entityData.get(CRYSTAL_TYPE)));
        Vector3f color = MalkuthEntity.getMalkuthAttackPreparationParticleColor(this.getCrystalType());
        ((ServerLevel)this.level()).sendParticles((ParticleOptions)BallParticleOptions.builder().color(color.x, color.y, color.z).brightness(2).size(0.5f).scalingOptions(0, 0, 20).friction(0.6f).build(), this.getX(), this.getY() + 1.5, this.getZ(), 100, (double)0.2f, (double)0.2f, (double)0.2f, 0.5);
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    protected void defineSynchedData(SynchedEntityData.Builder data) {
        data.define(CRYSTAL_TYPE, (Object)MalkuthAttackType.FIRE);
        data.define(HIDDEN, (Object)false);
    }

    public boolean isPickable() {
        return true;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("crystalType", this.getCrystalType().name());
        tag.putBoolean("hidden", ((Boolean)this.entityData.get(HIDDEN)).booleanValue());
        this.autoSave(tag);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("crystalType")) {
            this.setCrystalType(MalkuthAttackType.valueOf(tag.getString("crystalType")));
        }
        this.entityData.set(HIDDEN, (Object)tag.getBoolean("hidden"));
        this.setHidden((Boolean)this.entityData.get(HIDDEN));
        this.autoLoad(tag);
    }
}

