/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.tile_entities;

import com.finderfeed.fdbosses.content.blocks.TrophyBlock;
import com.finderfeed.fdlib.systems.bedrock.animations.Animation;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.AnimationTicker;
import com.finderfeed.fdlib.systems.bedrock.animations.animation_system.tile.FDBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class TrophyBlockEntity
extends FDBlockEntity {
    public TrophyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TrophyBlock getBlock() {
        return (TrophyBlock)this.getBlockState().getBlock();
    }

    public void onClick(Player player) {
        TrophyBlock trophyBlock = this.getBlock();
        Supplier<Animation> clickAnim = trophyBlock.getClickAnimation();
        Supplier<Animation> idleAnim = trophyBlock.getIdleAnimation();
        if (clickAnim != null && idleAnim != null) {
            this.getAnimationSystem().startAnimation("IDLE", AnimationTicker.builder(clickAnim).setLoopMode(Animation.LoopMode.ONCE).nextAnimation(AnimationTicker.builder(idleAnim).setLoopMode(Animation.LoopMode.LOOP).build()).build());
        }
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            TrophyBlock trophyBlock = this.getBlock();
            if (this.getAnimationSystem().getTicker("IDLE") == null && trophyBlock.getIdleAnimation() != null) {
                this.getAnimationSystem().startAnimation("IDLE", AnimationTicker.builder(trophyBlock.getIdleAnimation()).setLoopMode(Animation.LoopMode.LOOP).build());
            }
        }
    }

    public int getAngleFromState() {
        BlockState state = this.getBlockState();
        Direction facing = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        int angle = 0;
        switch (facing) {
            case SOUTH: {
                angle = 180;
                break;
            }
            case WEST: {
                angle = 90;
                break;
            }
            case EAST: {
                angle = 270;
            }
        }
        return angle;
    }
}

