/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdbosses.content.util;

import com.finderfeed.fdbosses.content.util.BossByteBufCodecs;
import com.finderfeed.fdbosses.content.util.BossCodecs;
import com.finderfeed.fdlib.util.FDByteBufCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class WorldBox {
    public static StreamCodec<RegistryFriendlyByteBuf, WorldBox> STREAM_CODEC = StreamCodec.composite((StreamCodec)FDByteBufCodecs.RESOURCE_LOCATION, v -> v.dimension.location(), BossByteBufCodecs.AABB, v -> v.box, (location, aabb) -> new WorldBox((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)location), (AABB)aabb));
    public static Codec<WorldBox> CODEC = RecordCodecBuilder.create(p -> p.group((App)Codec.STRING.fieldOf("dimension").forGetter(v -> v.dimension.location().toString()), (App)BossCodecs.AABB.fieldOf("box").forGetter(v -> v.box)).apply((Applicative)p, (location, aabb) -> new WorldBox((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)location)), (AABB)aabb)));
    private final ResourceKey<Level> dimension;
    private final AABB box;

    public WorldBox(ResourceKey<Level> dimension, AABB box) {
        this.dimension = dimension;
        this.box = box;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public AABB getBox() {
        return this.box;
    }

    public boolean isEntityInBox(Entity entity) {
        return entity.level().dimension().equals(this.dimension) && this.box.contains(entity.position());
    }
}

