/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.items.armors.QuantumBoots;
import net.pedroksl.advanced_ae.common.items.armors.QuantumChestplate;
import net.pedroksl.advanced_ae.common.items.armors.QuantumHelmet;
import net.pedroksl.advanced_ae.common.items.armors.QuantumLeggings;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.network.packet.KeysPressedPacket;

public class AAEClientPlayerEvents {
    public static final AttributeModifier flight = new AttributeModifier(AdvancedAE.makeId("flight"), 1.0, AttributeModifier.Operation.ADD_VALUE);
    public static final String NO_KEY_DATA = "aae$nokey";
    public static final String UP_KEY_DATA = "aae$upkey";
    public static final String DOWN_KEY_DATA = "aae$downkey";

    @SubscribeEvent
    public static void playerRender(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            QuantumLeggings item;
            QuantumChestplate item2;
            ItemStack chestStack;
            Item item3;
            QuantumHelmet item4;
            PlayerRenderer renderer = event.getRenderer();
            PlayerModel model = (PlayerModel)renderer.getModel();
            ItemStack helmetStack = player.getItemBySlot(EquipmentSlot.HEAD);
            Item item5 = helmetStack.getItem();
            if (item5 instanceof QuantumHelmet && (item4 = (QuantumHelmet)item5).isVisible(helmetStack)) {
                model.hat.visible = false;
            }
            if ((item3 = (chestStack = player.getItemBySlot(EquipmentSlot.CHEST)).getItem()) instanceof QuantumChestplate && (item2 = (QuantumChestplate)item3).isVisible(chestStack)) {
                model.leftSleeve.visible = false;
                model.rightSleeve.visible = false;
                model.jacket.visible = false;
                model.leftArm.visible = false;
                model.rightArm.visible = false;
            }
            ItemStack leggingsStack = player.getItemBySlot(EquipmentSlot.LEGS);
            ItemStack bootsStack = player.getItemBySlot(EquipmentSlot.FEET);
            Item item6 = leggingsStack.getItem();
            if (item6 instanceof QuantumLeggings && (item = (QuantumLeggings)item6).isVisible(leggingsStack)) {
                QuantumBoots item22;
                model.leftPants.visible = false;
                model.rightPants.visible = false;
                Item item7 = bootsStack.getItem();
                if (item7 instanceof QuantumBoots && (item22 = (QuantumBoots)item7).isVisible(bootsStack)) {
                    model.leftLeg.visible = false;
                    model.rightLeg.visible = false;
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            ItemStack chestStack;
            Options options;
            QuantumBoots boots;
            ItemStack bootStack = player.getItemBySlot(EquipmentSlot.FEET);
            Item item = bootStack.getItem();
            if (item instanceof QuantumBoots && (boots = (QuantumBoots)item).isUpgradeEnabledAndPowered(bootStack, UpgradeType.FLIGHT_DRIFT)) {
                boolean noKey;
                options = Minecraft.getInstance().options;
                boolean bl = noKey = !options.keyUp.isDown() && !options.keyRight.isDown() && !options.keyDown.isDown() && !options.keyLeft.isDown();
                if (player.getPersistentData().getBoolean(NO_KEY_DATA) != noKey) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new KeysPressedPacket(NO_KEY_DATA, noKey), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    player.getPersistentData().putBoolean(NO_KEY_DATA, noKey);
                }
            }
            if ((chestStack = player.getItemBySlot(EquipmentSlot.CHEST)).getItem() instanceof QuantumChestplate) {
                options = Minecraft.getInstance().options;
                boolean downKey = options.keyShift.isDown();
                if (player.getPersistentData().getBoolean(DOWN_KEY_DATA) != downKey) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new KeysPressedPacket(DOWN_KEY_DATA, downKey), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    player.getPersistentData().putBoolean(DOWN_KEY_DATA, downKey);
                }
                boolean upKey = options.keyJump.isDown();
                if (player.getPersistentData().getBoolean(UP_KEY_DATA) != upKey) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new KeysPressedPacket(UP_KEY_DATA, upKey), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    player.getPersistentData().putBoolean(UP_KEY_DATA, upKey);
                }
            }
        }
    }
}

