/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.merequester.client;

import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.stacks.AEKey;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import com.almostreliable.merequester.Utils;
import com.almostreliable.merequester.client.abstraction.AbstractRequesterScreen;
import com.almostreliable.merequester.client.abstraction.RequesterReference;
import com.almostreliable.merequester.core.Config;
import com.almostreliable.merequester.requester.RequestManager;
import com.almostreliable.merequester.terminal.RequesterTerminalMenu;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.Nullable;

public class RequesterTerminalScreen<T extends RequesterTerminalMenu>
extends AbstractRequesterScreen<T> {
    private static final ResourceLocation TEXTURE = Utils.getRL(String.format("textures/gui/%s.png", "requester_terminal"));
    private static final Rect2i FOOTER_BBOX = new Rect2i(0, 133, 195, 101);
    private final HashMap<Long, RequesterReference> byId = new HashMap();
    private final HashMultimap<String, RequesterReference> byName = HashMultimap.create();
    private final List<String> requesterNames = new ArrayList<String>();
    private final Map<String, Set<Object>> searchCache = new WeakHashMap<String, Set<Object>>();
    private final AETextField searchField;

    public RequesterTerminalScreen(T menu, Inventory playerInventory, Component name, ScreenStyle style) {
        super(menu, playerInventory, name, style, TEXTURE);
        this.addToLeftToolbar((Button)new SettingToggleButton(Settings.TERMINAL_STYLE, (Enum)AEConfig.instance().getTerminalStyle(), this::toggleTerminalStyle));
        this.searchField = this.widgets.addTextField("search");
        this.searchField.setResponder(str -> this.refreshList());
        this.searchField.setPlaceholder((Component)GuiText.SearchPlaceholder.text());
    }

    public boolean mouseClicked(double mX, double mY, int button) {
        if (button == 1 && this.searchField.isMouseOver(mX, mY)) {
            this.searchField.setValue("");
        }
        return super.mouseClicked(mX, mY, button);
    }

    public boolean charTyped(char character, int key) {
        return character == ' ' && this.searchField.getValue().isEmpty() || super.charTyped(character, key);
    }

    @Override
    protected void init() {
        int availableHeight = this.height - 2 * this.config.getTerminalMargin();
        int possibleRows = (availableHeight - 20 - 99) / 19;
        this.rowAmount = Math.max(3, this.config.getTerminalStyle().getRows(possibleRows));
        super.init();
        this.setInitialFocus((GuiEventListener)this.searchField);
    }

    @Override
    protected void clear() {
        this.byId.clear();
    }

    @Override
    protected void refreshList() {
        Object requests;
        this.refreshList = false;
        this.searchCache.clear();
        this.byName.clear();
        String searchQuery = this.searchField.getValue().toLowerCase();
        Set<Object> cachedSearch = this.searchByQuery(searchQuery);
        boolean rebuild = cachedSearch.isEmpty();
        for (RequesterReference requester : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(requester)) continue;
            boolean found = searchQuery.isEmpty();
            if (!found) {
                requests = requester.getRequestManager();
                for (int i = 0; i < ((RequestManager)requests).size() && !(found = this.keyMatchesSearchQuery(((RequestManager)requests).getKey(i), searchQuery)); ++i) {
                }
            }
            if (found || requester.getSearchName().contains(searchQuery)) {
                this.byName.put((Object)requester.getDisplayName(), (Object)requester);
                cachedSearch.add(requester);
                continue;
            }
            cachedSearch.remove(requester);
        }
        this.requesterNames.clear();
        this.requesterNames.addAll(this.byName.keySet());
        Collections.sort(this.requesterNames);
        this.lines.clear();
        this.lines.ensureCapacity(this.requesterNames.size() + this.byId.size() * (Integer)Config.COMMON.requests.get());
        for (String name : this.requesterNames) {
            this.lines.add(name);
            ArrayList requesters = new ArrayList(this.byName.get((Object)name));
            Collections.sort(requesters);
            requests = new ArrayList();
            for (RequesterReference requester : requesters) {
                for (int i = 0; i < requester.getRequestManager().size(); ++i) {
                    requests.add(requester.getRequestManager().get(i));
                }
            }
            this.lines.addAll(requests);
        }
        this.resetScrollbar();
    }

    @Override
    protected Set<RequesterReference> getByName(String name) {
        return this.byName.get((Object)name);
    }

    @Override
    protected RequesterReference getById(long requesterId, String name, long sortBy) {
        RequesterReference requester = this.byId.get(requesterId);
        if (requester == null) {
            requester = new RequesterReference(requesterId, name, sortBy);
            this.byId.put(requesterId, requester);
            this.refreshList = true;
        }
        return requester;
    }

    @Override
    protected Rect2i getFooterBounds() {
        return FOOTER_BBOX;
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> button, boolean backwards) {
        TerminalStyle next = (TerminalStyle)button.getNextValue(backwards);
        AEConfig.instance().setTerminalStyle(next);
        button.set((Enum)next);
        this.reinitialize();
    }

    private void reinitialize() {
        this.children().removeAll(this.renderables);
        this.renderables.clear();
        this.init();
    }

    private boolean keyMatchesSearchQuery(@Nullable AEKey key, String searchTerm) {
        return key != null && key.getDisplayName().getString().toLowerCase().contains(searchTerm);
    }

    private Set<Object> searchByQuery(String searchQuery) {
        Set cache = this.searchCache.computeIfAbsent(searchQuery, $ -> new HashSet());
        if (cache.isEmpty() && searchQuery.length() > 1) {
            cache.addAll(this.searchByQuery(searchQuery.substring(0, searchQuery.length() - 1)));
        }
        return cache;
    }
}

