/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.itemstack;

import com.google.common.collect.Lists;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.network.IButtonHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.ItemCapability;

public class ItemStackHarness
implements IContainerAddonProvider,
IScreenAddonProvider,
IButtonHandler {
    private final ItemStack itemStack;
    private final IButtonHandler buttonHandler;
    private final ItemCapability<?, Void>[] capabilities;
    private final IScreenAddonProvider defaultProvider;

    public ItemStackHarness(ItemStack itemStack, IScreenAddonProvider defaultProvider, IButtonHandler buttonHandler, ItemCapability<?, Void> ... capabilities) {
        this.itemStack = itemStack;
        this.defaultProvider = defaultProvider;
        this.buttonHandler = buttonHandler;
        this.capabilities = capabilities;
    }

    @Override
    @Nonnull
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList screenAddons = Lists.newArrayList();
        if (this.defaultProvider != null) {
            screenAddons.addAll(this.defaultProvider.getScreenAddons());
        }
        for (ItemCapability<?, Void> capability : this.capabilities) {
            screenAddons.addAll(Optional.ofNullable(this.itemStack.getCapability(capability)).filter(cap -> cap instanceof IScreenAddonProvider).map(cap -> (IScreenAddonProvider)cap).map(IScreenAddonProvider::getScreenAddons).orElseGet(Lists::newArrayList));
        }
        return screenAddons;
    }

    @Override
    @Nonnull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        ArrayList containerAddons = Lists.newArrayList();
        for (ItemCapability<?, Void> capability : this.capabilities) {
            containerAddons.addAll(Optional.ofNullable(this.itemStack.getCapability(capability)).filter(cap -> cap instanceof IContainerAddonProvider).map(cap -> (IContainerAddonProvider)cap).map(IContainerAddonProvider::getContainerAddons).orElseGet(Lists::newArrayList));
        }
        return containerAddons;
    }

    @Override
    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        if (this.buttonHandler != null) {
            this.buttonHandler.handleButtonMessage(id, playerEntity, compound);
        }
    }
}

