/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.iface;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.iface.InterfaceData;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyTypes;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicatorListener;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicators;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.iface.TieredInterfaceBlockEntity;
import com.ultramega.cabletiers.common.registry.Menus;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TieredInterfaceContainerMenu
extends AbstractResourceContainerMenu
implements ExportingIndicatorListener {
    private static final int EXPORT_CONFIG_SLOT_X = 8;
    private static final int EXPORT_CONFIG_SLOT_Y = 20;
    private static final int EXPORT_OUTPUT_SLOT_Y = 84;
    private final ExportingIndicators indicators;
    private final Predicate<Player> stillValid;
    private final List<Slot> exportedResourceSlots = new ArrayList<Slot>();
    private final CableTiers tier;

    TieredInterfaceContainerMenu(int syncId, Player player, TieredInterfaceBlockEntity blockEntity, ResourceContainer exportConfig, ResourceContainer exportedResources, Container exportedResourcesAsContainer, UpgradeContainer upgradeContainer, ExportingIndicators indicators, CableTiers tier) {
        super(Menus.INSTANCE.getTieredInterfaces(tier), syncId, player);
        this.tier = tier;
        this.addSlots(player, exportConfig, exportedResources, exportedResourcesAsContainer, upgradeContainer);
        this.registerProperty((Property)new ServerProperty(PropertyTypes.FUZZY_MODE, blockEntity::isFuzzyMode, blockEntity::setFuzzyMode));
        this.registerProperty((Property)new ServerProperty(PropertyTypes.REDSTONE_MODE, () -> ((TieredInterfaceBlockEntity)blockEntity).getRedstoneMode(), arg_0 -> ((TieredInterfaceBlockEntity)blockEntity).setRedstoneMode(arg_0)));
        this.indicators = indicators;
        this.stillValid = p -> Container.stillValidBlockEntity((BlockEntity)blockEntity, (Player)p);
    }

    public TieredInterfaceContainerMenu(int syncId, Inventory playerInventory, InterfaceData interfaceData, CableTiers tier) {
        super(Menus.INSTANCE.getTieredInterfaces(tier), syncId);
        this.tier = tier;
        ResourceContainer filterContainer = TieredInterfaceBlockEntity.createFilterContainer(tier, interfaceData);
        ResourceContainer exportedResources = TieredInterfaceBlockEntity.createExportedResourcesContainer(tier, interfaceData, FilterWithFuzzyMode.create((ResourceContainer)filterContainer, null));
        this.addSlots(playerInventory.player, filterContainer, exportedResources, exportedResources.toItemContainer(), new UpgradeContainer((UpgradeDestination)UpgradeDestinations.INTERFACE, 1));
        this.registerProperty((Property)new ClientProperty(PropertyTypes.FUZZY_MODE, (Object)false));
        this.registerProperty((Property)new ClientProperty(PropertyTypes.REDSTONE_MODE, (Object)RedstoneMode.IGNORE));
        this.indicators = new ExportingIndicators(interfaceData.exportingIndicators());
        this.stillValid = p -> true;
    }

    private void addSlots(Player player, ResourceContainer exportConfig, ResourceContainer exportedResources, Container exportedResourcesAsContainer, UpgradeContainer upgradeContainer) {
        int i;
        for (i = 0; i < exportConfig.size(); ++i) {
            this.addSlot(this.createExportConfigSlot(exportConfig, i));
        }
        for (i = 0; i < exportedResources.size(); ++i) {
            this.exportedResourceSlots.add(this.addSlot(this.addExportedResourceSlot(exportedResources, exportedResourcesAsContainer, i)));
        }
        this.addSlot((Slot)new UpgradeSlot(upgradeContainer, 0, 187, 6));
        this.addPlayerInventory(player.getInventory(), 8, 136 + (this.tier != CableTiers.ELITE ? 18 : 0));
        this.transferManager.addBiTransfer(exportedResourcesAsContainer, (Container)player.getInventory());
        this.transferManager.addFilterTransfer((Container)player.getInventory());
    }

    private Slot createExportConfigSlot(ResourceContainer exportConfig, int index) {
        return new ResourceSlot(exportConfig, index, (Component)IdentifierUtil.createTranslation((String)"gui", (String)"interface.filter_help"), TieredInterfaceContainerMenu.getExportSlotX(index), 20 + TieredInterfaceContainerMenu.getExportSlotY(index), ResourceSlotType.FILTER_WITH_AMOUNT);
    }

    private Slot addExportedResourceSlot(ResourceContainer exportedResources, Container exportedResourcesAsContainer, int index) {
        return new ResourceSlot(this, exportedResources, exportedResourcesAsContainer, index, (Component)Component.empty(), TieredInterfaceContainerMenu.getExportSlotX(index), 84 + TieredInterfaceContainerMenu.getExportSlotY(index), ResourceSlotType.CONTAINER){

            public boolean shouldRenderAmount() {
                return true;
            }
        };
    }

    public List<Slot> getExportedResourceSlots() {
        return this.exportedResourceSlots;
    }

    ExportingIndicator getIndicator(int idx) {
        return this.indicators.get(idx);
    }

    int getIndicators() {
        return this.indicators.size();
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.indicators.detectChanges(serverPlayer);
        }
    }

    public boolean stillValid(Player player) {
        return this.stillValid.test(player);
    }

    public void indicatorChanged(int index, ExportingIndicator indicator) {
        this.indicators.set(index, indicator);
    }

    private static int getExportSlotX(int index) {
        return 8 + 18 * (index % 9);
    }

    private static int getExportSlotY(int index) {
        return 18 * (index / 9);
    }
}

