/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.particle;

import com.corosus.watut.particle.ParticleRotating;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class ParticleStaticPartial
extends ParticleRotating {
    public float customU1;
    public float customV1;

    public ParticleStaticPartial(ClientLevel pLevel, double pX, double pY, double pZ, TextureAtlasSprite sprite, float brightness, int subSizeX, int subSizeY) {
        super(pLevel, pX, pY, pZ);
        this.sprite = sprite;
        this.lifetime = Integer.MAX_VALUE;
        this.gravity = 0.0f;
        this.setSize(0.2f, 0.2f);
        this.quadSize = 0.5f;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        float subSizeXFloat = (float)subSizeX / (float)this.sprite.contents().width();
        float getU0 = this.getU0();
        float getU1 = this.getU1();
        this.customU1 = this.getU0() + (this.sprite.getU1() - this.getU0()) * subSizeXFloat;
        float subSizeYFloat = (float)subSizeY / (float)this.sprite.contents().height();
        this.customV1 = this.getV0() + (this.sprite.getV1() - this.getV0()) * subSizeYFloat;
        this.setColor(this.getColorRed() * brightness, this.getColorGreen() * brightness, this.getColorBlue() * brightness);
    }

    public void setSize(float pWidth, float pHeight) {
        super.setSize(pWidth, pHeight);
    }

    @Override
    public void tick() {
        super.tick();
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
        }
    }

    protected float getU0() {
        return this.sprite.getU0();
    }

    protected float getU1() {
        return this.customU1;
    }

    protected float getV0() {
        return this.sprite.getV0();
    }

    protected float getV1() {
        return this.customV1;
    }
}

