/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.data;

import com.davenonymous.pipegoggles.data.BlockList;
import com.davenonymous.pipegoggles.data.EnumBoxOptimizationStrategy;
import com.davenonymous.pipegoggles.data.ItemList;
import com.davenonymous.pipegoggles.data.cache.GoggleSupportCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;

public record GoggleSupport(String modId, EnumBoxOptimizationStrategy strategy, BlockList blocks, ItemList items, boolean useBlockItems) {
    public static final MapCodec<GoggleSupport> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("mod").forGetter(GoggleSupport::modId), (App)EnumBoxOptimizationStrategy.CODEC.optionalFieldOf("strategy", (Object)EnumBoxOptimizationStrategy.REMOVE_DUPLICATE_LINES).forGetter(GoggleSupport::strategy), (App)BlockList.CODEC.fieldOf("blocks").xmap(BlockList::new, BlockList::asList).forGetter(GoggleSupport::blocks), (App)ItemList.CODEC.optionalFieldOf("items", List.of()).xmap(ItemList::new, ItemList::asList).forGetter(GoggleSupport::items), (App)Codec.BOOL.optionalFieldOf("useBlockItems", (Object)true).forGetter(GoggleSupport::useBlockItems)).apply((Applicative)instance, GoggleSupport::new));

    public Set<Item> getAllItems(Registry<Item> itemRegistry) {
        return this.items.getAllItems(itemRegistry);
    }

    public String getModName() {
        IModFileInfo modFile = ModList.get().getModFileById(this.modId());
        if (modFile == null) {
            return "?";
        }
        if (modFile.getMods().isEmpty()) {
            return modFile.getFile().getFileName();
        }
        return ((IModInfo)modFile.getMods().getFirst()).getDisplayName();
    }

    public boolean supportsBlock(BlockState state) {
        return this.blocks().supports(state);
    }

    public boolean isTriggerItem(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            if (this.blocks().supports(block.defaultBlockState())) {
                return true;
            }
        }
        return GoggleSupportCache.ITEMS_BY_SUPPORT.get(this).contains(stack.getItem());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GoggleSupport)) {
            return false;
        }
        GoggleSupport support = (GoggleSupport)o;
        return this.useBlockItems() == support.useBlockItems() && Objects.equals(this.modId(), support.modId()) && Objects.equals(this.items(), support.items()) && Objects.equals(this.blocks(), support.blocks()) && this.strategy() == support.strategy();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.modId(), this.strategy(), this.blocks(), this.items(), this.useBlockItems()});
    }
}

