/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.datagen;

import com.davenonymous.pipegoggles.PipeGoggles;
import com.davenonymous.pipegoggles.data.BlockList;
import com.davenonymous.pipegoggles.data.EnumBoxOptimizationStrategy;
import com.davenonymous.pipegoggles.data.GoggleSupport;
import com.davenonymous.pipegoggles.data.ItemList;
import com.davenonymous.pipegoggles.setup.ModRegistries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class DGRegistries
extends RegistrySetBuilder {
    public Map<ResourceKey<?>, List<ICondition>> conditions = new HashMap();
    public Map<ResourceKey<?>, GoggleSupport> supportData = new HashMap();

    public DGRegistries() {
        this.simpleSupport("integrateddynamics", "integrateddynamics:cable");
        this.simpleSupport("enderio", "enderio:conduit");
        this.simpleSupport("fluxnetworks", "fluxnetworks:flux_point", "fluxnetworks:flux_plug");
        this.simpleSupport("modern_industrialization", "modern_industrialization:pipe");
        this.simpleSupport("pipez", "pipez:universal_pipe", "pipez:energy_pipe", "pipez:fluid_pipe", "pipez:item_pipe", "pipez:gas_pipe");
        this.simpleSupport("laserio", "laserio:laser_connector", "laserio:laser_connector_advanced", "laserio:laser_node");
        this.simpleSupport("replication", "replication:matter_network_pipe");
        this.simpleSupport("oritech", "oritech:transparent_item_pipe", "oritech:item_pipe", "oritech:framed_item_pipe", "oritech:item_pipe_duct_block", "oritech:fluid_pipe", "oritech:framed_fluid_pipe", "oritech:fluid_pipe_duct_block", "oritech:energy_pipe", "oritech:framed_energy_pipe", "oritech:energy_pipe_duct_block", "oritech:superconductor", "oritech:framed_superconductor", "oritech:superconductor_duct_block");
        this.simpleSupport("pneumaticcraft", "pneumaticcraft:reinforced_pressure_tube", "pneumaticcraft:advanced_pressure_tube", "pneumaticcraft:pressure_tube");
        this.support("xnet", BlockList.of("xnet:netcable", "xnet:connector"), ItemList.of("#xnet:cables", "#xnet:connectors"));
        this.support("refinedstorage", BlockList.of("refinedstorage:cable"), ItemList.of("#refinedstorage:cables"));
        this.support("ae2", BlockList.of("ae2:cable_bus"), ItemList.of("#ae2:glass_cable", "#ae2:covered_cable", "#ae2:covered_dense_cable", "#ae2:smart_cable", "#ae2:smart_dense_cable"));
        this.addMekanismSupport();
        this.addCreateSupport();
        this.addMinecraftRedstoneSupport();
        this.addMoreRedSupport();
        this.build();
    }

    public void addMoreRedSupport() {
        BlockList blockList = BlockList.ofDyes("morered:%s_network_cable");
        blockList.add("morered:red_alloy_wire");
        blockList.add("morered:bundled_network_cable");
        ItemList itemList = ItemList.of("#morered:red_alloy_wires", "#morered:network_cables");
        this.support("morered", blockList, itemList);
    }

    public void addMekanismSupport() {
        List<String> types = List.of("logistical_transporter", "universal_cable", "mechanical_pipe", "pressurized_tube", "thermodynamic_conductor");
        List<String> levels = List.of("basic", "advanced", "elite", "ultimate");
        BlockList blocks = new BlockList(new ArrayList());
        for (String level : levels) {
            for (String type : types) {
                blocks.add("mekanism:" + level + "_" + type);
            }
        }
        this.support("mekanism", blocks, ItemList.of(new String[0]));
    }

    public void addCreateSupport() {
        BlockList blockList = BlockList.of("create:shaft", "create:large_cogwheel", "create:cogwheel", "create:belt", "create:fluid_pipe", "create:mechanical_pump", "create:smart_fluid_pipe", "create:fluid_valve", "create:gearbox", "create:vertical_gearbox", "create:clutch", "create:gearshift", "create:rotation_speed_controller", "create:sequenced_gearshift", "create:stressometer", "create:speedometer");
        ItemList itemList = ItemList.of(new String[0]);
        GoggleSupport supportData = new GoggleSupport("create", EnumBoxOptimizationStrategy.REMOVE_DUPLICATE_LINES, blockList, itemList, true);
        this.addGoggleSupport("create", supportData);
    }

    public void addMinecraftRedstoneSupport() {
        BlockList blockList = BlockList.of("minecraft:redstone_block", "minecraft:redstone_wire", "minecraft:redstone_lamp", "minecraft:redstone_torch", "minecraft:repeater", "minecraft:comparator", "minecraft:lever", "minecraft:stone_button");
        ItemList itemList = ItemList.of("#c:dusts/redstone");
        GoggleSupport supportData = new GoggleSupport("minecraft", EnumBoxOptimizationStrategy.REMOVE_DUPLICATE_LINES, blockList, itemList, true);
        this.addGoggleSupport("minecraft_redstone", supportData);
    }

    public void simpleSupportForMod(String groupName, String modId, String ... blocks) {
        GoggleSupport simpleSupport = new GoggleSupport(modId, EnumBoxOptimizationStrategy.REMOVE_DUPLICATE_LINES, BlockList.of(blocks), ItemList.of(new String[0]), true);
        this.addGoggleSupport(groupName, simpleSupport);
    }

    public void support(String groupName, BlockList blocks, ItemList items) {
        GoggleSupport support = new GoggleSupport(groupName, EnumBoxOptimizationStrategy.REMOVE_DUPLICATE_LINES, blocks, items, true);
        this.addGoggleSupport(groupName, support);
    }

    public void support(String groupName, String modId, BlockList blocks, ItemList items) {
        GoggleSupport support = new GoggleSupport(modId, EnumBoxOptimizationStrategy.REMOVE_DUPLICATE_LINES, blocks, items, true);
        this.addGoggleSupport(groupName, support);
    }

    public void simpleSupport(String groupName, String ... blocks) {
        GoggleSupport simpleSupport = new GoggleSupport(groupName, EnumBoxOptimizationStrategy.REMOVE_DUPLICATE_LINES, BlockList.of(blocks), ItemList.of(new String[0]), true);
        this.addGoggleSupport(groupName, simpleSupport);
    }

    public void addGoggleSupport(String groupName, GoggleSupport data) {
        ResourceLocation location = PipeGoggles.resource(groupName);
        ResourceKey goggleSupportKey = ResourceKey.create(ModRegistries.GOGGLE_SUPPORT_REGISTRY_KEY, (ResourceLocation)location);
        this.conditions.put(goggleSupportKey, List.of(new ModLoadedCondition(data.modId())));
        this.supportData.put(goggleSupportKey, data);
    }

    public void build() {
        this.add(ModRegistries.GOGGLE_SUPPORT_REGISTRY_KEY, bootstrapContext -> {
            for (ResourceKey<?> resourceKey : this.supportData.keySet()) {
                bootstrapContext.register(resourceKey, (Object)this.supportData.get(resourceKey));
            }
        });
    }
}

