/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.lib.gui.tooltip;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class SpriteTooltipComponent
implements TooltipComponent,
ClientTooltipComponent {
    private final ResourceLocation sprite;
    private final int textureX;
    private final int textureY;
    private final int textureWidth;
    private final int textureHeight;
    private final int width;
    private final int height;

    public SpriteTooltipComponent(ResourceLocation sprite, int width, int height, int textureX, int textureY, int textureWidth, int textureHeight) {
        this.height = height;
        this.sprite = sprite;
        this.textureHeight = textureHeight;
        this.textureWidth = textureWidth;
        this.textureX = textureX;
        this.textureY = textureY;
        this.width = width;
    }

    public SpriteTooltipComponent(ResourceLocation sprite, int width, int height) {
        this(sprite, width, height, 0, 0, width, height);
    }

    public SpriteTooltipComponent(ResourceLocation sprite, int width, int height, int textureX, int textureY) {
        this(sprite, width, height, textureX, textureY, width, height);
    }

    public ResourceLocation getSprite() {
        return this.sprite;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth(Font font) {
        return this.width;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        int xOffset = x + (this.width - this.textureWidth) / 2;
        int yOffset = y + (this.height - this.textureHeight) / 2;
        guiGraphics.fillGradient(xOffset, yOffset, xOffset + this.textureWidth, yOffset + this.textureHeight, -256, -16711681);
        guiGraphics.blit(this.sprite, xOffset, yOffset, this.textureX, this.textureY, this.textureWidth, this.textureHeight);
    }
}

