/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.pipegoggles.lib.gui.widgets;

import com.davenonymous.pipegoggles.lib.gui.Icons;
import com.davenonymous.pipegoggles.lib.gui.event.MouseClickEvent;
import com.davenonymous.pipegoggles.lib.gui.event.MouseEnterEvent;
import com.davenonymous.pipegoggles.lib.gui.event.MouseExitEvent;
import com.davenonymous.pipegoggles.lib.gui.event.MouseReleasedEvent;
import com.davenonymous.pipegoggles.lib.gui.event.WidgetEventResult;
import com.davenonymous.pipegoggles.lib.gui.widgets.WidgetImage;
import net.minecraft.client.Minecraft;

public class WidgetPlayButton
extends WidgetImage {
    private long lastClickTime = 0L;
    private boolean isPlaying;

    public WidgetPlayButton(boolean isInitiallyPlaying, OnPlay onClick, OnStop onStop) {
        super(isInitiallyPlaying ? Icons.pauseButton : Icons.playButton);
        this.isPlaying = isInitiallyPlaying;
        this.setColor(this.isPlaying ? -1658112 : -12010692);
        this.setSize(11, 10);
        this.addListener(MouseClickEvent.class, (event, widget) -> {
            if (event.button != 0) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            if (this.isPlaying) {
                this.isPlaying = false;
                onStop.onStop();
                this.setImage(Icons.playButton);
                this.setColor(-12010692);
            } else {
                this.isPlaying = true;
                onClick.onPlay();
                this.setImage(Icons.pauseButton);
                this.setColor(-1658112);
            }
            this.lastClickTime = Minecraft.getInstance().level.getGameTime();
            return WidgetEventResult.HANDLED;
        });
        this.addListener(MouseReleasedEvent.class, (event, widget) -> {
            if (event.button != 0) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            if (!widget.isPosInside(event.x, event.y)) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            long currentTime = Minecraft.getInstance().level.getGameTime();
            long timeSinceLastClick = currentTime - this.lastClickTime;
            if (timeSinceLastClick < 5L) {
                return WidgetEventResult.CONTINUE_PROCESSING;
            }
            this.isPlaying = false;
            onStop.onStop();
            this.setImage(Icons.playButton);
            this.setColor(-12010692);
            return WidgetEventResult.HANDLED;
        });
        this.addListener(MouseEnterEvent.class, (event, widget) -> WidgetEventResult.HANDLED);
        this.addListener(MouseExitEvent.class, (event, widget) -> WidgetEventResult.HANDLED);
    }

    public static interface OnStop {
        public void onStop();
    }

    public static interface OnPlay {
        public void onPlay();
    }
}

