/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.block.block_entity.AdvancedItemCollectorBlockEntity;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.ItemCollectorBlockEntity;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b0\nH\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0016H\u0014J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J0\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J0\u0010\"\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0004H\u0014J:\u0010%\u001a\n\u0012\u0004\u0012\u0002H'\u0018\u00010&\"\n\b\u0000\u0010'*\u0004\u0018\u00010!2\u0006\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/ItemCollectorBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/EntityBlock;", "isAdvanced", "", "<init>", "(Z)V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/state/BlockState;", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "state", "level", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "canSurvive", "Lnet/minecraft/world/level/LevelReader;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "onRemove", "newState", "movedByPiston", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "blockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "Companion", "irregular-implements-1.21.1"})
public final class ItemCollectorBlock
extends Block
implements EntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isAdvanced;
    @NotNull
    private static final VoxelShape SHAPE_SOUTH;
    @NotNull
    private static final VoxelShape SHAPE_NORTH;
    @NotNull
    private static final VoxelShape SHAPE_EAST;
    @NotNull
    private static final VoxelShape SHAPE_WEST;
    @NotNull
    private static final VoxelShape SHAPE_DOWN;
    @NotNull
    private static final VoxelShape SHAPE_UP;
    @NotNull
    private static final DirectionProperty FACING;

    public ItemCollectorBlock(boolean isAdvanced) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.HOPPER)));
        this.isAdvanced = isAdvanced;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.DOWN));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{FACING};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = (Direction)state.getValue((Property)FACING);
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                voxelShape = SHAPE_NORTH;
                break;
            }
            case 2: {
                voxelShape = SHAPE_SOUTH;
                break;
            }
            case 3: {
                voxelShape = SHAPE_WEST;
                break;
            }
            case 4: {
                voxelShape = SHAPE_EAST;
                break;
            }
            case 5: {
                voxelShape = SHAPE_UP;
                break;
            }
            case 6: {
                voxelShape = SHAPE_DOWN;
                break;
            }
            default: {
                VoxelShape voxelShape2 = Shapes.block();
                voxelShape = voxelShape2;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"block(...)");
            }
        }
        return voxelShape;
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos onBlockPos = pos.relative(facing);
        Level level2 = level instanceof Level ? (Level)level : null;
        IItemHandler itemHandler = level2 != null ? (IItemHandler)level2.getCapability(Capabilities.ItemHandler.BLOCK, onBlockPos, (Object)facing.getOpposite()) : null;
        return itemHandler != null;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof MenuProvider) {
            player.openMenu((MenuProvider)blockEntity);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.isAdvanced ? (BlockEntity)new AdvancedItemCollectorBlockEntity(pos, state) : (BlockEntity)new ItemCollectorBlockEntity(pos, state);
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        BlockEntity be;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!state.is(newState.getBlock()) && (be = level.getBlockEntity(pos)) instanceof AdvancedItemCollectorBlockEntity) {
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)((Container)((AdvancedItemCollectorBlockEntity)be).getContainer()));
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        BlockEntityTicker blockEntityTicker;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(blockEntityType, (String)"blockEntityType");
        if (this.isAdvanced) {
            ItemCollectorBlockEntity.Companion companion = ItemCollectorBlockEntity.Companion;
            blockEntityTicker = BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.INSTANCE.getADVANCED_ITEM_COLLECTOR().get()), (BlockEntityTicker)new BlockEntityTicker(companion){
                final /* synthetic */ ItemCollectorBlockEntity.Companion $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void tick(Level p0, BlockPos p1, BlockState p2, ItemCollectorBlockEntity p3) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                    this.$tmp0.tick(p0, p1, p2, p3);
                }
            });
        } else {
            ItemCollectorBlockEntity.Companion companion = ItemCollectorBlockEntity.Companion;
            blockEntityTicker = BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.INSTANCE.getITEM_COLLECTOR().get()), (BlockEntityTicker)new BlockEntityTicker(companion){
                final /* synthetic */ ItemCollectorBlockEntity.Companion $tmp0;
                {
                    this.$tmp0 = $tmp0;
                }

                public final void tick(Level p0, BlockPos p1, BlockState p2, ItemCollectorBlockEntity p3) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    Intrinsics.checkNotNullParameter((Object)((Object)p3), (String)"p3");
                    this.$tmp0.tick(p0, p1, p2, p3);
                }
            });
        }
        return blockEntityTicker;
    }

    static {
        VoxelShape voxelShape = Block.box((double)6.0, (double)6.0, (double)11.0, (double)10.0, (double)10.0, (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SHAPE_SOUTH = voxelShape;
        VoxelShape voxelShape2 = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)5.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"box(...)");
        SHAPE_NORTH = voxelShape2;
        VoxelShape voxelShape3 = Block.box((double)11.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"box(...)");
        SHAPE_EAST = voxelShape3;
        VoxelShape voxelShape4 = Block.box((double)0.0, (double)6.0, (double)6.0, (double)5.0, (double)10.0, (double)10.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"box(...)");
        SHAPE_WEST = voxelShape4;
        VoxelShape voxelShape5 = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape5, (String)"box(...)");
        SHAPE_DOWN = voxelShape5;
        VoxelShape voxelShape6 = Block.box((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape6, (String)"box(...)");
        SHAPE_UP = voxelShape6;
        DirectionProperty directionProperty = BlockStateProperties.FACING;
        Intrinsics.checkNotNullExpressionValue((Object)directionProperty, (String)"FACING");
        FACING = directionProperty;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/ItemCollectorBlock$Companion;", "", "<init>", "()V", "SHAPE_SOUTH", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getSHAPE_SOUTH", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "SHAPE_NORTH", "getSHAPE_NORTH", "SHAPE_EAST", "getSHAPE_EAST", "SHAPE_WEST", "getSHAPE_WEST", "SHAPE_DOWN", "getSHAPE_DOWN", "SHAPE_UP", "getSHAPE_UP", "FACING", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getFACING", "()Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VoxelShape getSHAPE_SOUTH() {
            return SHAPE_SOUTH;
        }

        @NotNull
        public final VoxelShape getSHAPE_NORTH() {
            return SHAPE_NORTH;
        }

        @NotNull
        public final VoxelShape getSHAPE_EAST() {
            return SHAPE_EAST;
        }

        @NotNull
        public final VoxelShape getSHAPE_WEST() {
            return SHAPE_WEST;
        }

        @NotNull
        public final VoxelShape getSHAPE_DOWN() {
            return SHAPE_DOWN;
        }

        @NotNull
        public final VoxelShape getSHAPE_UP() {
            return SHAPE_UP;
        }

        @NotNull
        public final DirectionProperty getFACING() {
            return FACING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

