/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block;

import dev.aaronhowser.mods.irregular_implements.config.ServerConfig;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001&B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J@\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J*\u0010 \u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020!2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\"\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010$\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010%\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006'"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/PitcherPlantBlock;", "Lnet/minecraft/world/level/block/FlowerBlock;", "Lnet/minecraft/world/level/block/BucketPickup;", "Lnet/minecraft/world/level/block/BonemealableBlock;", "<init>", "()V", "isRandomlyTicking", "", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "randomTick", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "getPickupSound", "Ljava/util/Optional;", "Lnet/minecraft/sounds/SoundEvent;", "pickupBlock", "Lnet/minecraft/world/level/LevelAccessor;", "isValidBonemealTarget", "Lnet/minecraft/world/level/LevelReader;", "isBonemealSuccess", "performBonemeal", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nPitcherPlantBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PitcherPlantBlock.kt\ndev/aaronhowser/mods/irregular_implements/block/PitcherPlantBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1761#2,3:138\n*S KotlinDebug\n*F\n+ 1 PitcherPlantBlock.kt\ndev/aaronhowser/mods/irregular_implements/block/PitcherPlantBlock\n*L\n77#1:138,3\n*E\n"})
public final class PitcherPlantBlock
extends FlowerBlock
implements BucketPickup,
BonemealableBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IFluidHandler INFINITE_WATER_HANDLER = new IFluidHandler(){

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return new FluidStack((Fluid)Fluids.WATER, Integer.MAX_VALUE);
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return stack.is((Fluid)Fluids.WATER);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack fluidStack;
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            if (resource.is((Fluid)Fluids.WATER)) {
                Integer configMax = (Integer)ServerConfig.Companion.getCONFIG().getPitcherPlantPipeDrainRate().get();
                Fluid fluid = (Fluid)Fluids.WATER;
                int n = resource.getAmount();
                Intrinsics.checkNotNull((Object)configMax);
                fluidStack = new FluidStack(fluid, Math.min(n, configMax));
            } else {
                FluidStack fluidStack2 = FluidStack.EMPTY;
                Intrinsics.checkNotNull((Object)fluidStack2);
                fluidStack = fluidStack2;
            }
            return fluidStack;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Integer configMax = (Integer)ServerConfig.Companion.getCONFIG().getPitcherPlantPipeDrainRate().get();
            Fluid fluid = (Fluid)Fluids.WATER;
            Intrinsics.checkNotNull((Object)configMax);
            return new FluidStack(fluid, Math.min(maxDrain, configMax));
        }
    };

    public PitcherPlantBlock() {
        super(MobEffects.WATER_BREATHING, 5.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)Blocks.RED_TULIP)));
    }

    protected boolean isRandomlyTicking(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Level level2 = (Level)level;
        Object object = ServerConfig.Companion.getCONFIG().getPitcherPlantTickFillAmount().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Companion.fillAdjacentTanks(level2, pos, ((Number)object).intValue());
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (level.isClientSide) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack usedStack = player.getItemInHand(hand);
        IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)usedStack.getCapability(Capabilities.FluidHandler.ITEM);
        if (iFluidHandlerItem == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        IFluidHandlerItem fluidCap = iFluidHandlerItem;
        Fluid fluid = (Fluid)Fluids.WATER;
        Object object = ServerConfig.Companion.getCONFIG().getPitcherPlantUseFillAmount().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        int amountThatFits = fluidCap.fill(new FluidStack(fluid, ((Number)object).intValue()), IFluidHandler.FluidAction.SIMULATE);
        fluidCap.fill(new FluidStack((Fluid)Fluids.WATER, amountThatFits), IFluidHandler.FluidAction.EXECUTE);
        return ItemInteractionResult.SUCCESS;
    }

    @NotNull
    public Optional<SoundEvent> getPickupSound() {
        Optional optional = Fluids.WATER.getPickupSound();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getPickupSound(...)");
        return optional;
    }

    @NotNull
    public ItemStack pickupBlock(@Nullable Player player, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ItemStack itemStack = Fluids.WATER.getBucket().getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
        return itemStack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(level instanceof Level)) return false;
        Iterable $this$any$iv = (Iterable)EntriesMappings.entries$0;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            IFluidHandler fluidCap;
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Direction it = (Direction)element$iv;
            boolean bl2 = false;
            if ((IFluidHandler)((Level)level).getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(it), (Object)it.getOpposite()) == null) {
                bl = false;
                continue;
            }
            int amountThatFits = fluidCap.fill(new FluidStack((Fluid)Fluids.WATER, 1), IFluidHandler.FluidAction.SIMULATE);
            if (amountThatFits > 0) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Level level2 = (Level)level;
        Object object = ServerConfig.Companion.getCONFIG().getPitcherPlantBoneMealFillAmount().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Companion.fillAdjacentTanks(level2, pos, ((Number)object).intValue());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/PitcherPlantBlock$Companion;", "", "<init>", "()V", "fillAdjacentTanks", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "amount", "", "INFINITE_WATER_HANDLER", "Lnet/neoforged/neoforge/fluids/capability/IFluidHandler;", "getINFINITE_WATER_HANDLER", "()Lnet/neoforged/neoforge/fluids/capability/IFluidHandler;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void fillAdjacentTanks(@NotNull Level level, @NotNull BlockPos pos, int amount) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            for (Direction direction : EntriesMappings.entries$0) {
                IFluidHandler fluidCap;
                BlockPos offsetPos = pos.relative(direction);
                if ((IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, offsetPos, (Object)direction.getOpposite()) == null) continue;
                int amountThatFits = fluidCap.fill(new FluidStack((Fluid)Fluids.WATER, amount), IFluidHandler.FluidAction.SIMULATE);
                fluidCap.fill(new FluidStack((Fluid)Fluids.WATER, amountThatFits), IFluidHandler.FluidAction.EXECUTE);
            }
        }

        @NotNull
        public final IFluidHandler getINFINITE_WATER_HANDLER() {
            return INFINITE_WATER_HANDLER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<Direction> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }
}

