/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.block_entity;

import com.mojang.authlib.GameProfile;
import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.block.AutoPlacerBlock;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.base.ImprovedSimpleContainer;
import dev.aaronhowser.mods.irregular_implements.menu.auto_placer.AutoPlacerMenu;
import dev.aaronhowser.mods.irregular_implements.registry.ModBlockEntityTypes;
import java.lang.ref.WeakReference;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 02\u00020\u00012\u00020\u0002:\u0002/0B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001aH\u0002J\u0006\u0010\u001c\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020\u001eJ \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0014J\u0018\u0010.\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0017\u0010\u0018\u00a8\u00061"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/AutoPlacerBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pPos", "Lnet/minecraft/core/BlockPos;", "pBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "container", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/base/ImprovedSimpleContainer;", "getContainer", "()Ldev/aaronhowser/mods/irregular_implements/block/block_entity/base/ImprovedSimpleContainer;", "invWrapper", "Lnet/neoforged/neoforge/items/wrapper/InvWrapper;", "uuid", "Ljava/util/UUID;", "fakePlayer", "Ljava/lang/ref/WeakReference;", "Lnet/neoforged/neoforge/common/util/FakePlayer;", "value", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/AutoPlacerBlockEntity$Mode;", "mode", "setMode", "(Ldev/aaronhowser/mods/irregular_implements/block/block_entity/AutoPlacerBlockEntity$Mode;)V", "tick", "", "initFakePlayer", "placeBlock", "getItemHandler", "Lnet/neoforged/neoforge/items/IItemHandler;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "containerId", "", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "saveAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "Mode", "Companion", "irregular-implements-1.21.1"})
public final class AutoPlacerBlockEntity
extends BlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImprovedSimpleContainer container;
    @NotNull
    private final InvWrapper invWrapper;
    @Nullable
    private UUID uuid;
    @Nullable
    private WeakReference<FakePlayer> fakePlayer;
    @NotNull
    private Mode mode;
    public static final int CONTAINER_SIZE = 1;
    @NotNull
    public static final String MODE_NBT = "Mode";
    @NotNull
    private static final String FAKE_PLAYER_NAME = "IrregularImplementsAutoPlacer";

    public AutoPlacerBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pBlockState) {
        Intrinsics.checkNotNullParameter((Object)pPos, (String)"pPos");
        Intrinsics.checkNotNullParameter((Object)pBlockState, (String)"pBlockState");
        super((BlockEntityType)ModBlockEntityTypes.INSTANCE.getAUTO_PLACER().get(), pPos, pBlockState);
        this.container = new ImprovedSimpleContainer(this){

            public boolean canAddItem(ItemStack stack) {
                Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                return super.canAddItem(stack) && stack.getItem() instanceof BlockItem;
            }
        };
        this.invWrapper = new InvWrapper((Container)this.container);
        this.mode = Mode.WHILE_POWERED;
    }

    @NotNull
    public final ImprovedSimpleContainer getContainer() {
        return this.container;
    }

    private final void setMode(Mode value) {
        this.mode = value;
        this.setChanged();
    }

    public final void tick() {
        WeakReference<FakePlayer> weakReference = this.fakePlayer;
        if ((weakReference != null ? (FakePlayer)weakReference.get() : null) == null) {
            this.initFakePlayer();
        }
        if (this.mode == Mode.WHILE_POWERED) {
            Level level = this.level;
            if (AaronExtensions.INSTANCE.isTrue(level != null ? Boolean.valueOf(level.hasNeighborSignal(this.worldPosition)) : null)) {
                this.placeBlock();
            }
        }
    }

    private final void initFakePlayer() {
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel level2 = serverLevel;
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.setChanged();
        }
        GameProfile gameProfile = new GameProfile(this.uuid, FAKE_PLAYER_NAME);
        FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)level2, (GameProfile)gameProfile);
        fakePlayer.setSilent(true);
        fakePlayer.setOnGround(true);
        this.fakePlayer = new WeakReference<FakePlayer>(fakePlayer);
        this.setChanged();
    }

    public final void placeBlock() {
        ItemStack stackToPlace = this.container.getItem(0);
        if (stackToPlace.isEmpty()) {
            return;
        }
        Level level = this.level;
        if (level == null) {
            return;
        }
        Level level2 = level;
        Direction direction = (Direction)this.getBlockState().getValue((Property)AutoPlacerBlock.Companion.getFACING());
        BlockPos targetPos = this.worldPosition.relative(direction);
        BlockState blockThere = level2.getBlockState(targetPos);
        if (!blockThere.canBeReplaced()) {
            return;
        }
        FakePlayer fakePlayer = this.fakePlayer;
        if (fakePlayer == null || (fakePlayer = (FakePlayer)fakePlayer.get()) == null) {
            return;
        }
        FakePlayer fakePlayer2 = fakePlayer;
        fakePlayer2.setItemInHand(InteractionHand.MAIN_HAND, stackToPlace);
        if (!fakePlayer2.mayUseItemAt(targetPos, direction.getOpposite(), stackToPlace)) {
            return;
        }
        BlockHitResult blockHitResult = new BlockHitResult(targetPos.getCenter(), direction.getOpposite(), targetPos, true);
        BlockPlaceContext context = new BlockPlaceContext((Player)fakePlayer2, InteractionHand.MAIN_HAND, stackToPlace, blockHitResult);
        stackToPlace.useOn((UseOnContext)context);
    }

    @NotNull
    public final IItemHandler getItemHandler() {
        return (IItemHandler)this.invWrapper;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return (AbstractContainerMenu)new AutoPlacerMenu(containerId, playerInventory, (Container)this.container);
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = this.getBlockState().getBlock().getName();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
        return (Component)mutableComponent;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)this.container.getItems(), (HolderLookup.Provider)registries);
        tag.putInt(MODE_NBT, this.mode == Mode.ON_PULSE ? 0 : 1);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)this.container.getItems(), (HolderLookup.Provider)registries);
        if (tag.contains(MODE_NBT)) {
            int modeInt = tag.getInt(MODE_NBT);
            this.setMode(modeInt == 0 ? Mode.ON_PULSE : Mode.WHILE_POWERED);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/AutoPlacerBlockEntity$Companion;", "", "<init>", "()V", "CONTAINER_SIZE", "", "MODE_NBT", "", "FAKE_PLAYER_NAME", "getItemCapability", "Lnet/neoforged/neoforge/items/IItemHandler;", "autoPlacer", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/AutoPlacerBlockEntity;", "direction", "Lnet/minecraft/core/Direction;", "tick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "Lnet/minecraft/core/BlockPos;", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "blockEntity", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IItemHandler getItemCapability(@NotNull AutoPlacerBlockEntity autoPlacer, @Nullable Direction direction) {
            Intrinsics.checkNotNullParameter((Object)((Object)autoPlacer), (String)"autoPlacer");
            return autoPlacer.getItemHandler();
        }

        public final void tick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull AutoPlacerBlockEntity blockEntity) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
            Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
            if (level.isClientSide) {
                return;
            }
            blockEntity.tick();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/block_entity/AutoPlacerBlockEntity$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "ON_PULSE", "WHILE_POWERED", "irregular-implements-1.21.1"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode ON_PULSE = new Mode();
        public static final /* enum */ Mode WHILE_POWERED = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.ON_PULSE, Mode.WHILE_POWERED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

