/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.block.plate;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.block.plate.BasePlateBlock;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J(\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0014\u00a8\u0006\u001c"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/plate/RedirectorPlateBlock;", "Ldev/aaronhowser/mods/irregular_implements/block/plate/BasePlateBlock;", "<init>", "()V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "state", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "entityInside", "entity", "Lnet/minecraft/world/entity/Entity;", "Companion", "irregular-implements-1.21.1"})
public final class RedirectorPlateBlock
extends BasePlateBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DirectionProperty ACTIVE_ONE;
    @NotNull
    private static final DirectionProperty ACTIVE_TWO;

    public RedirectorPlateBlock() {
        super(null, 1, null);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ACTIVE_ONE, (Comparable)Direction.NORTH)).setValue((Property)ACTIVE_TWO, (Comparable)Direction.SOUTH));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{ACTIVE_ONE, ACTIVE_TWO};
        builder.add(propertyArray);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ACTIVE_ONE, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)ACTIVE_TWO, (Comparable)context.getHorizontalDirection());
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        Direction currentOne = (Direction)state.getValue((Property)ACTIVE_ONE);
        Direction currentTwo = (Direction)state.getValue((Property)ACTIVE_TWO);
        Vec3 centerPos = AaronExtensions.INSTANCE.toVec3((Vec3i)pos).add(0.5, 0.0, 0.5);
        Vec3 deltaVec = centerPos.vectorTo(hitResult.getLocation());
        Direction direction = Direction.getNearest((double)deltaVec.x, (double)deltaVec.y, (double)deltaVec.z);
        if (direction == currentOne || direction == currentTwo) {
            return InteractionResult.FAIL;
        }
        BlockState newState = (BlockState)state.setValue((Property)(player.isSecondaryUseActive() ? ACTIVE_TWO : ACTIVE_ONE), (Comparable)direction);
        level.setBlockAndUpdate(pos, newState);
        return InteractionResult.SUCCESS;
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        Direction direction;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Vec3 entityMotion = entity.getDeltaMovement();
        if (entityMotion.horizontalDistanceSqr() < 0.001) {
            return;
        }
        Direction movingInDirection = Direction.getNearest((double)entityMotion.x, (double)0.0, (double)entityMotion.z);
        Vec3 blockCenter = AaronExtensions.INSTANCE.toVec3((Vec3i)pos).add(0.5, 0.0, 0.5);
        Vec3 entityDisplacementVector = blockCenter.vectorTo(entity.position());
        Direction entityComingFromDirection = Direction.getNearest((double)entityDisplacementVector.x, (double)0.0, (double)entityDisplacementVector.z);
        Direction currentOne = (Direction)state.getValue((Property)ACTIVE_ONE);
        Direction currentTwo = (Direction)state.getValue((Property)ACTIVE_TWO);
        if (entityComingFromDirection == currentOne && movingInDirection == currentOne.getOpposite()) {
            direction = currentTwo;
        } else if (entityComingFromDirection == currentTwo && movingInDirection == currentTwo.getOpposite()) {
            direction = currentOne;
        } else {
            return;
        }
        Direction moveToDirection = direction;
        Vec3i vec3i = moveToDirection.getNormal();
        Intrinsics.checkNotNullExpressionValue((Object)vec3i, (String)"getNormal(...)");
        Vec3 moveToPos = AaronExtensions.INSTANCE.toVec3(vec3i).scale(0.4).add(blockCenter);
        float lookAngleDifference = entityComingFromDirection.getOpposite().toYRot() - moveToDirection.toYRot();
        Vec3 outputMotion = entityMotion.yRot((float)Math.PI / 180 * lookAngleDifference);
        entity.teleportTo(moveToPos.x, entity.getY(), moveToPos.z);
        entity.setDeltaMovement(outputMotion);
    }

    static {
        DirectionProperty directionProperty = DirectionProperty.create((String)"active_one", (Predicate)((Predicate)Direction.Plane.HORIZONTAL));
        Intrinsics.checkNotNullExpressionValue((Object)directionProperty, (String)"create(...)");
        ACTIVE_ONE = directionProperty;
        DirectionProperty directionProperty2 = DirectionProperty.create((String)"active_two", (Predicate)((Predicate)Direction.Plane.HORIZONTAL));
        Intrinsics.checkNotNullExpressionValue((Object)directionProperty2, (String)"create(...)");
        ACTIVE_TWO = directionProperty2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/aaronhowser/mods/irregular_implements/block/plate/RedirectorPlateBlock$Companion;", "", "<init>", "()V", "ACTIVE_ONE", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getACTIVE_ONE", "()Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "ACTIVE_TWO", "getACTIVE_TWO", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DirectionProperty getACTIVE_ONE() {
            return ACTIVE_ONE;
        }

        @NotNull
        public final DirectionProperty getACTIVE_TWO() {
            return ACTIVE_TWO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

