/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.datagen.recipe;

import dev.aaronhowser.mods.irregular_implements.recipe.machine.ImbuingRecipe;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00122\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0016J\u0012\u0010\u0017\u001a\u00020\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ldev/aaronhowser/mods/irregular_implements/datagen/recipe/ImbuingRecipeBuilder;", "Lnet/minecraft/data/recipes/RecipeBuilder;", "outerIngredients", "", "Lnet/minecraft/world/item/crafting/Ingredient;", "centerIngredient", "outputStack", "Lnet/minecraft/world/item/ItemStack;", "<init>", "(Ljava/util/List;Lnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/world/item/ItemStack;)V", "getOuterIngredients", "()Ljava/util/List;", "getCenterIngredient", "()Lnet/minecraft/world/item/crafting/Ingredient;", "getOutputStack", "()Lnet/minecraft/world/item/ItemStack;", "criteria", "", "", "Lnet/minecraft/advancements/Criterion;", "unlockedBy", "name", "criterion", "group", "p0", "getResult", "Lnet/minecraft/world/item/Item;", "save", "", "recipeOutput", "Lnet/minecraft/data/recipes/RecipeOutput;", "defaultId", "Lnet/minecraft/resources/ResourceLocation;", "irregular-implements-1.21.1"})
public final class ImbuingRecipeBuilder
implements RecipeBuilder {
    @NotNull
    private final List<Ingredient> outerIngredients;
    @NotNull
    private final Ingredient centerIngredient;
    @NotNull
    private final ItemStack outputStack;
    @NotNull
    private final Map<String, Criterion<?>> criteria;

    public ImbuingRecipeBuilder(@NotNull List<Ingredient> outerIngredients, @NotNull Ingredient centerIngredient, @NotNull ItemStack outputStack) {
        Intrinsics.checkNotNullParameter(outerIngredients, (String)"outerIngredients");
        Intrinsics.checkNotNullParameter((Object)centerIngredient, (String)"centerIngredient");
        Intrinsics.checkNotNullParameter((Object)outputStack, (String)"outputStack");
        this.outerIngredients = outerIngredients;
        this.centerIngredient = centerIngredient;
        this.outputStack = outputStack;
        this.criteria = new LinkedHashMap();
    }

    @NotNull
    public final List<Ingredient> getOuterIngredients() {
        return this.outerIngredients;
    }

    @NotNull
    public final Ingredient getCenterIngredient() {
        return this.centerIngredient;
    }

    @NotNull
    public final ItemStack getOutputStack() {
        return this.outputStack;
    }

    @NotNull
    public RecipeBuilder unlockedBy(@NotNull String name, @NotNull Criterion<?> criterion) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(criterion, (String)"criterion");
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String p0) {
        throw new IllegalStateException("Unsupported".toString());
    }

    @NotNull
    public Item getResult() {
        Item item = this.outputStack.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
        return item;
    }

    public void save(@NotNull RecipeOutput recipeOutput, @NotNull ResourceLocation defaultId) {
        Intrinsics.checkNotNullParameter((Object)recipeOutput, (String)"recipeOutput");
        Intrinsics.checkNotNullParameter((Object)defaultId, (String)"defaultId");
        StringBuilder idString = new StringBuilder();
        idString.append("imbuing/").append(defaultId.getPath());
        String string = idString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        ResourceLocation id = OtherUtil.modResource(string);
        Advancement.Builder advancement = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        for (Map.Entry<String, Criterion<?>> criterion : this.criteria.entrySet()) {
            advancement.addCriterion(criterion.getKey(), criterion.getValue());
        }
        ImbuingRecipe recipe = new ImbuingRecipe(this.outerIngredients, this.centerIngredient, this.outputStack);
        recipeOutput.accept(id, (Recipe)recipe, advancement.build(id.withPrefix("recipes/")));
    }
}

