/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.entity;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModEntityTypes;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.GlobalPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0001H\u0016\u00a8\u0006\u0013"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/PortkeyItemEntity;", "Lnet/minecraft/world/entity/item/ItemEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "itemEntity", "(Lnet/minecraft/world/entity/item/ItemEntity;)V", "tick", "", "shouldTeleport", "", "playerTouch", "entity", "Lnet/minecraft/world/entity/player/Player;", "copy", "Companion", "irregular-implements-1.21.1"})
public final class PortkeyItemEntity
extends ItemEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int PORTKEY_PICKUP_DELAY = 100;

    public PortkeyItemEntity(@NotNull EntityType<PortkeyItemEntity> entityType, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(entityType, level);
        this.lifespan = Integer.MAX_VALUE;
        this.setPickUpDelay(40);
    }

    public PortkeyItemEntity(@NotNull ItemEntity itemEntity) {
        Intrinsics.checkNotNullParameter((Object)itemEntity, (String)"itemEntity");
        Object object = ModEntityTypes.INSTANCE.getPORTKEY_ITEM().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        EntityType entityType = (EntityType)object;
        Level level = itemEntity.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        this((EntityType<PortkeyItemEntity>)entityType, level);
        this.setItem(itemEntity.getItem());
        this.setPos(itemEntity.position());
        this.setDeltaMovement(itemEntity.getDeltaMovement());
    }

    public void tick() {
        super.tick();
        if (!AaronExtensions.INSTANCE.isClientSide((Entity)this) && this.age == 100) {
            this.level().playSound(null, this.blockPosition(), SoundEvents.BELL_BLOCK, this.getSoundSource(), 1.0f, 0.25f);
        }
    }

    private final boolean shouldTeleport() {
        if (this.age <= 100) {
            return false;
        }
        ItemStack stack = super.getItem();
        return stack.has((Supplier)ModDataComponents.INSTANCE.getGLOBAL_POS());
    }

    public void playerTouch(@NotNull Player entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!this.shouldTeleport()) {
            super.playerTouch(entity);
            return;
        }
        ItemStack stack = super.getItem();
        GlobalPos globalPos = (GlobalPos)stack.get((Supplier)ModDataComponents.INSTANCE.getGLOBAL_POS());
        if (globalPos == null) {
            return;
        }
        GlobalPos locationComponent = globalPos;
        Level level = entity.level();
        if (!Intrinsics.areEqual((Object)level.dimension(), (Object)locationComponent.dimension())) {
            return;
        }
        Vec3 teleportLocation = locationComponent.pos().getBottomCenter();
        level.playSound(null, entity.blockPosition(), SoundEvents.PLAYER_TELEPORT, entity.getSoundSource());
        entity.teleportTo(teleportLocation.x, teleportLocation.y, teleportLocation.z);
        level.playSound(null, entity.blockPosition(), SoundEvents.PLAYER_TELEPORT, entity.getSoundSource());
        this.discard();
    }

    @NotNull
    public ItemEntity copy() {
        return new PortkeyItemEntity(this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldev/aaronhowser/mods/irregular_implements/entity/PortkeyItemEntity$Companion;", "", "<init>", "()V", "PORTKEY_PICKUP_DELAY", "", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

