/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.handler.ender_letter;

import dev.aaronhowser.mods.irregular_implements.handler.ender_letter.EnderMailboxInventory;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0006R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/ender_letter/EnderLetterHandler;", "Lnet/minecraft/world/level/saveddata/SavedData;", "<init>", "()V", "inventories", "", "Ljava/util/UUID;", "Ldev/aaronhowser/mods/irregular_implements/handler/ender_letter/EnderMailboxInventory;", "getInventories", "()Ljava/util/Map;", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "getOrCreateInventory", "owner", "Lnet/minecraft/world/entity/Entity;", "uuid", "getInventory", "Companion", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nEnderLetterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnderLetterHandler.kt\ndev/aaronhowser/mods/irregular_implements/handler/ender_letter/EnderLetterHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,83:1\n382#2,7:84\n*S KotlinDebug\n*F\n+ 1 EnderLetterHandler.kt\ndev/aaronhowser/mods/irregular_implements/handler/ender_letter/EnderLetterHandler\n*L\n36#1:84,7\n*E\n"})
public final class EnderLetterHandler
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<UUID, EnderMailboxInventory> inventories = new LinkedHashMap();
    @NotNull
    public static final String LIST_NBT = "EnderLetterInventories";
    @NotNull
    public static final String OWNER_UUID_NBT = "OwnerUUID";
    @NotNull
    public static final String INVENTORY_NBT = "Inventory";
    @NotNull
    public static final String SAVED_DATA_NAME = "ii_ender_letter_inventories";
    @NotNull
    public static final String OLD_SAVED_DATA_NAME = "ender_letter_inventories";

    @NotNull
    public final Map<UUID, EnderMailboxInventory> getInventories() {
        return this.inventories;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ListTag listTag = tag.getList(LIST_NBT, 10);
        for (Map.Entry<UUID, EnderMailboxInventory> entry2 : this.inventories.entrySet()) {
            UUID uuid = entry2.getKey();
            EnderMailboxInventory inventory = entry2.getValue();
            if (!inventory.hasItems()) continue;
            CompoundTag invTag = new CompoundTag();
            invTag.putUUID(OWNER_UUID_NBT, uuid);
            invTag.put(INVENTORY_NBT, (Tag)inventory.saveAsTag(registries));
            listTag.add((Object)invTag);
        }
        tag.put(LIST_NBT, (Tag)listTag);
        return tag;
    }

    @NotNull
    public final EnderMailboxInventory getOrCreateInventory(@NotNull Entity owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        UUID uUID = owner.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return this.getOrCreateInventory(uUID);
    }

    @NotNull
    public final EnderMailboxInventory getOrCreateInventory(@NotNull UUID uuid) {
        EnderMailboxInventory enderMailboxInventory;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Map<UUID, EnderMailboxInventory> $this$getOrPut$iv = this.inventories;
        boolean $i$f$getOrPut = false;
        EnderMailboxInventory value$iv = $this$getOrPut$iv.get(uuid);
        if (value$iv == null) {
            boolean bl = false;
            EnderMailboxInventory answer$iv = new EnderMailboxInventory(this);
            $this$getOrPut$iv.put(uuid, answer$iv);
            enderMailboxInventory = answer$iv;
        } else {
            enderMailboxInventory = value$iv;
        }
        return enderMailboxInventory;
    }

    @Nullable
    public final EnderMailboxInventory getInventory(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.inventories.get(uuid);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/ender_letter/EnderLetterHandler$Companion;", "", "<init>", "()V", "LIST_NBT", "", "OWNER_UUID_NBT", "INVENTORY_NBT", "SAVED_DATA_NAME", "OLD_SAVED_DATA_NAME", "load", "Ldev/aaronhowser/mods/irregular_implements/handler/ender_letter/EnderLetterHandler;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "get", "level", "Lnet/minecraft/server/level/ServerLevel;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        private final EnderLetterHandler load(CompoundTag tag, HolderLookup.Provider provider) {
            EnderLetterHandler handler = new EnderLetterHandler();
            ListTag listTag = tag.getList(EnderLetterHandler.LIST_NBT, 10);
            int n = ((Collection)listTag).size();
            for (int i = 0; i < n; ++i) {
                CompoundTag tag2 = listTag.getCompound(i);
                UUID uuid = tag2.getUUID(EnderLetterHandler.OWNER_UUID_NBT);
                CompoundTag inventoryTag = tag2.getCompound(EnderLetterHandler.INVENTORY_NBT);
                Intrinsics.checkNotNull((Object)inventoryTag);
                EnderMailboxInventory inventory = EnderMailboxInventory.Companion.loadFromTag(handler, inventoryTag, provider);
                if (!inventory.hasItems()) continue;
                handler.getInventories().put(uuid, inventory);
            }
            return handler;
        }

        @NotNull
        public final EnderLetterHandler get(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            if (!Intrinsics.areEqual((Object)level, (Object)level.getServer().overworld())) {
                ServerLevel serverLevel = level.getServer().overworld();
                Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"overworld(...)");
                return this.get(serverLevel);
            }
            DimensionDataStorage storage = level.getDataStorage();
            SavedData.Factory factory = new SavedData.Factory(EnderLetterHandler::new, this::load);
            Intrinsics.checkNotNull((Object)storage);
            Object t = OtherUtil.INSTANCE.updateSavedDataLocation(storage, factory, EnderLetterHandler.SAVED_DATA_NAME, EnderLetterHandler.OLD_SAVED_DATA_NAME);
            Intrinsics.checkNotNullExpressionValue(t, (String)"updateSavedDataLocation(...)");
            return (EnderLetterHandler)((Object)t);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

