/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.handler.floo;

import dev.aaronhowser.mods.aaron.AaronExtensions;
import dev.aaronhowser.mods.irregular_implements.block.block_entity.FlooBrickBlockEntity;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.handler.floo.FlooNetworkSavedData;
import dev.aaronhowser.mods.irregular_implements.packet.server_to_client.BurningFlooFireplacePacket;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/floo/FlooFireplace;", "", "masterUuid", "Ljava/util/UUID;", "name", "", "masterBlockPos", "Lnet/minecraft/core/BlockPos;", "<init>", "(Ljava/util/UUID;Ljava/lang/String;Lnet/minecraft/core/BlockPos;)V", "getMasterUuid", "()Ljava/util/UUID;", "getName", "()Ljava/lang/String;", "getMasterBlockPos", "()Lnet/minecraft/core/BlockPos;", "toTag", "Lnet/minecraft/nbt/CompoundTag;", "getBlockEntity", "Ldev/aaronhowser/mods/irregular_implements/block/block_entity/FlooBrickBlockEntity;", "level", "Lnet/minecraft/world/level/Level;", "teleportFromThis", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "target", "teleportToThis", "Companion", "irregular-implements-1.21.1"})
public final class FlooFireplace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID masterUuid;
    @Nullable
    private final String name;
    @NotNull
    private final BlockPos masterBlockPos;
    @NotNull
    public static final String NBT_MASTER_UUID = "MasterUUID";
    @NotNull
    public static final String NBT_NAME = "Name";
    @NotNull
    public static final String NBT_BLOCK_POS = "MasterBlockPos";

    public FlooFireplace(@NotNull UUID masterUuid, @Nullable String name, @NotNull BlockPos masterBlockPos) {
        Intrinsics.checkNotNullParameter((Object)masterUuid, (String)"masterUuid");
        Intrinsics.checkNotNullParameter((Object)masterBlockPos, (String)"masterBlockPos");
        this.masterUuid = masterUuid;
        this.name = name;
        this.masterBlockPos = masterBlockPos;
    }

    @NotNull
    public final UUID getMasterUuid() {
        return this.masterUuid;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final BlockPos getMasterBlockPos() {
        return this.masterBlockPos;
    }

    @NotNull
    public final CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.putUUID(NBT_MASTER_UUID, this.masterUuid);
        if (this.name != null) {
            tag.putString(NBT_NAME, this.name);
        }
        tag.putLong(NBT_BLOCK_POS, this.masterBlockPos.asLong());
        return tag;
    }

    @Nullable
    public final FlooBrickBlockEntity getBlockEntity(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        BlockEntity blockEntity = level.getBlockEntity(this.masterBlockPos);
        return blockEntity instanceof FlooBrickBlockEntity ? (FlooBrickBlockEntity)blockEntity : null;
    }

    public final boolean teleportFromThis(@NotNull ServerPlayer player, @NotNull String target) {
        FlooBrickBlockEntity myBe;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ServerLevel level = player.serverLevel();
        Intrinsics.checkNotNull((Object)level);
        FlooNetworkSavedData data = FlooNetworkSavedData.Companion.get(level);
        FlooFireplace fireplace = data.findFireplace(target);
        if (fireplace == null) {
            Object[] objectArray = new Object[]{target};
            AaronExtensions.INSTANCE.status((Player)player, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.floo_brick.not_found", objectArray));
            return false;
        }
        if (Intrinsics.areEqual((Object)fireplace, (Object)this)) {
            String string = this.name;
            if (string == null) {
                string = target;
            }
            String name = string;
            Object[] objectArray = new Object[]{name};
            AaronExtensions.INSTANCE.status((Player)player, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.floo_brick.already_at", objectArray));
            return false;
        }
        boolean success = fireplace.teleportToThis(player);
        if (success && (myBe = this.getBlockEntity((Level)level)) != null) {
            List bricks = CollectionsKt.plus((Collection)myBe.getChildren(), (Object)myBe.getBlockPos());
            BurningFlooFireplacePacket packet = new BurningFlooFireplacePacket(bricks);
            Vec3 vec3 = this.masterBlockPos.getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            packet.messageNearbyPlayers(level, vec3, 64.0);
        }
        return success;
    }

    public final boolean teleportToThis(@NotNull ServerPlayer player) {
        FlooBrickBlockEntity be;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ServerLevel level = player.serverLevel();
        Object[] objectArray = level.getBlockEntity(this.masterBlockPos);
        FlooBrickBlockEntity flooBrickBlockEntity = be = objectArray instanceof FlooBrickBlockEntity ? (FlooBrickBlockEntity)objectArray : null;
        if (be == null) {
            objectArray = new Object[]{this.masterBlockPos.getX(), this.masterBlockPos.getY(), this.masterBlockPos.getZ()};
            AaronExtensions.INSTANCE.status((Player)player, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.floo_brick.no_longer_valid", objectArray));
            Intrinsics.checkNotNull((Object)level);
            FlooNetworkSavedData network = FlooNetworkSavedData.Companion.get(level);
            network.removeFireplace(this.masterUuid);
            return false;
        }
        Vec3 destination = this.masterBlockPos.above().getBottomCenter();
        player.teleportTo(level, destination.x, destination.y, destination.z, be.getFacing().toYRot(), player.getXRot());
        if (this.name != null) {
            Object[] objectArray2 = new Object[]{this.name};
            AaronExtensions.INSTANCE.status((Player)player, (Component)ModLanguageProvider.Companion.toComponent("message.irregular_implements.floo_brick.teleported", objectArray2));
        }
        List bricks = CollectionsKt.plus((Collection)be.getChildren(), (Object)be.getBlockPos());
        BurningFlooFireplacePacket packet = new BurningFlooFireplacePacket(bricks);
        Intrinsics.checkNotNull((Object)level);
        Vec3 vec3 = this.masterBlockPos.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
        packet.messageNearbyPlayers(level, vec3, 64.0);
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/floo/FlooFireplace$Companion;", "", "<init>", "()V", "NBT_MASTER_UUID", "", "NBT_NAME", "NBT_BLOCK_POS", "fromTag", "Ldev/aaronhowser/mods/irregular_implements/handler/floo/FlooFireplace;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "irregular-implements-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nFlooFireplace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlooFireplace.kt\ndev/aaronhowser/mods/irregular_implements/handler/floo/FlooFireplace$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FlooFireplace fromTag(@NotNull CompoundTag tag) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            UUID uuid = tag.getUUID(FlooFireplace.NBT_MASTER_UUID);
            CharSequence charSequence2 = tag.getString(FlooFireplace.NBT_NAME);
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            String name = (String)charSequence;
            BlockPos blockPos = BlockPos.of((long)tag.getLong(FlooFireplace.NBT_BLOCK_POS));
            Intrinsics.checkNotNull((Object)uuid);
            Intrinsics.checkNotNull((Object)blockPos);
            return new FlooFireplace(uuid, name, blockPos);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

