/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.handler.redstone_signal;

import dev.aaronhowser.mods.irregular_implements.handler.redstone_signal.SavedSignal;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/redstone_signal/RedstoneHandlerSavedData;", "Lnet/minecraft/world/level/saveddata/SavedData;", "<init>", "()V", "signals", "", "Ldev/aaronhowser/mods/irregular_implements/handler/redstone_signal/SavedSignal;", "addSignal", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "blockPos", "Lnet/minecraft/core/BlockPos;", "duration", "", "strength", "tick", "server", "Lnet/minecraft/server/MinecraftServer;", "updatePosition", "", "getStrongPower", "facing", "Lnet/minecraft/core/Direction;", "save", "Lnet/minecraft/nbt/CompoundTag;", "tag", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "Companion", "irregular-implements-1.21.1"})
public final class RedstoneHandlerSavedData
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<SavedSignal> signals = new LinkedHashSet();
    @NotNull
    private static final String TAG_SAVED_SIGNALS = "saved_signals";
    @NotNull
    public static final String SAVED_DATA_NAME = "ii_redstone_handler";
    @NotNull
    public static final String OLD_SAVED_DATA_NAME = "redstone_handler";

    public final void addSignal(@NotNull ServerLevel level, @NotNull BlockPos blockPos, int duration, int strength) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        this.signals.removeIf(arg_0 -> RedstoneHandlerSavedData.addSignal$lambda$1(arg_0 -> RedstoneHandlerSavedData.addSignal$lambda$0(blockPos, level, arg_0), arg_0));
        long l = blockPos.asLong();
        ResourceKey resourceKey = level.dimension();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        SavedSignal signal = new SavedSignal(l, (ResourceKey<Level>)resourceKey, duration, strength, level.getGameTime());
        this.signals.add(signal);
        this.updatePosition(level, blockPos);
        this.setDirty();
    }

    public final void tick(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Iterator<SavedSignal> iterator = this.signals.iterator();
        while (iterator.hasNext()) {
            SavedSignal signal = iterator.next();
            ServerLevel level = server.getLevel(signal.getDimension());
            if (level == null) {
                iterator.remove();
                continue;
            }
            this.updatePosition(level, signal.getBlockPos());
            if (!signal.isExpired(level.getGameTime())) continue;
            iterator.remove();
            this.setDirty();
        }
    }

    private final void updatePosition(ServerLevel level, BlockPos blockPos) {
        BlockState targetState = level.getBlockState(blockPos);
        targetState.handleNeighborChanged((Level)level, blockPos, Blocks.AIR, blockPos, false);
        level.updateNeighborsAt(blockPos, targetState.getBlock());
    }

    private final void updatePosition(ServerLevel level, long blockPos) {
        BlockPos blockPos2 = BlockPos.of((long)blockPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"of(...)");
        this.updatePosition(level, blockPos2);
    }

    public final int getStrongPower(@NotNull ServerLevel level, @NotNull BlockPos blockPos, @NotNull Direction facing) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        BlockPos pos = blockPos.relative(facing.getOpposite());
        ResourceKey dimension = level.dimension();
        for (SavedSignal signal : this.signals) {
            if (signal.isExpired(level.getGameTime()) || signal.getBlockPos() != pos.asLong() || !Intrinsics.areEqual(signal.getDimension(), (Object)dimension)) continue;
            return signal.getStrength();
        }
        return 0;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ListTag signalsTag = tag.getList(TAG_SAVED_SIGNALS, 10);
        for (SavedSignal signal : this.signals) {
            signalsTag.add((Object)signal.toTag());
        }
        tag.put(TAG_SAVED_SIGNALS, (Tag)signalsTag);
        return tag;
    }

    private static final boolean addSignal$lambda$0(BlockPos $blockPos, ServerLevel $level, SavedSignal it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getBlockPos() == $blockPos.asLong() && Intrinsics.areEqual(it.getDimension(), (Object)$level.dimension());
    }

    private static final boolean addSignal$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final RedstoneHandlerSavedData get(@NotNull ServerLevel level) {
        return Companion.get(level);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0013J&\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ldev/aaronhowser/mods/irregular_implements/handler/redstone_signal/RedstoneHandlerSavedData$Companion;", "", "<init>", "()V", "TAG_SAVED_SIGNALS", "", "SAVED_DATA_NAME", "OLD_SAVED_DATA_NAME", "load", "Ldev/aaronhowser/mods/irregular_implements/handler/redstone_signal/RedstoneHandlerSavedData;", "pTag", "Lnet/minecraft/nbt/CompoundTag;", "provider", "Lnet/minecraft/core/HolderLookup$Provider;", "get", "level", "Lnet/minecraft/server/level/ServerLevel;", "tick", "", "Lnet/minecraft/world/level/Level;", "addSignal", "blockPos", "Lnet/minecraft/core/BlockPos;", "duration", "", "strength", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        private final RedstoneHandlerSavedData load(CompoundTag pTag, HolderLookup.Provider provider) {
            RedstoneHandlerSavedData redstoneHandlerSavedData = new RedstoneHandlerSavedData();
            ListTag savedSignals = pTag.getList(RedstoneHandlerSavedData.TAG_SAVED_SIGNALS, 10);
            int n = ((Collection)savedSignals).size();
            for (int i = 0; i < n; ++i) {
                CompoundTag signalTag = savedSignals.getCompound(i);
                Intrinsics.checkNotNull((Object)signalTag);
                SavedSignal signal = SavedSignal.Companion.fromTag(signalTag);
                redstoneHandlerSavedData.signals.add(signal);
            }
            return redstoneHandlerSavedData;
        }

        @JvmStatic
        @NotNull
        public final RedstoneHandlerSavedData get(@NotNull ServerLevel level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            if (!Intrinsics.areEqual((Object)level, (Object)level.getServer().overworld())) {
                ServerLevel serverLevel = level.getServer().overworld();
                Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"overworld(...)");
                return this.get(serverLevel);
            }
            DimensionDataStorage storage = level.getDataStorage();
            SavedData.Factory factory = new SavedData.Factory(RedstoneHandlerSavedData::new, this::load);
            Intrinsics.checkNotNull((Object)storage);
            Object t = OtherUtil.INSTANCE.updateSavedDataLocation(storage, factory, RedstoneHandlerSavedData.SAVED_DATA_NAME, RedstoneHandlerSavedData.OLD_SAVED_DATA_NAME);
            Intrinsics.checkNotNullExpressionValue(t, (String)"updateSavedDataLocation(...)");
            return (RedstoneHandlerSavedData)((Object)t);
        }

        public final void tick(@NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            if (!(level instanceof ServerLevel)) {
                return;
            }
            RedstoneHandlerSavedData redstoneHandlerSavedData = this.get((ServerLevel)level);
            MinecraftServer minecraftServer = ((ServerLevel)level).getServer();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            redstoneHandlerSavedData.tick(minecraftServer);
        }

        public final void addSignal(@NotNull ServerLevel level, @NotNull BlockPos blockPos, int duration, int strength) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
            this.get(level).addSignal(level, blockPos, duration, strength);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

