/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModBiomeTagsProvider;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import dev.aaronhowser.mods.irregular_implements.registry.ModItems;
import dev.aaronhowser.mods.irregular_implements.util.OtherUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J.\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BiomeCrystalItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "irregular-implements-1.21.1"})
public final class BiomeCrystalItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;

    public BiomeCrystalItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        Holder holder = (Holder)stack.get((Supplier)ModDataComponents.INSTANCE.getBIOME());
        if (holder == null) {
            return;
        }
        Holder biomeHolder = holder;
        Component component = OtherUtil.INSTANCE.getBiomeComponent((Holder<Biome>)biomeHolder);
        tooltipComponents.add(component);
    }

    static {
        Item.Properties properties = new Item.Properties().rarity(Rarity.UNCOMMON);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"rarity(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BiomeCrystalItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "getAllCrystals", "", "Lnet/minecraft/world/item/ItemStack;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "getCrystal", "biomeHolder", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/level/biome/Biome;", "getItemColor", "", "stack", "tintIndex", "irregular-implements-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nBiomeCrystalItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BiomeCrystalItem.kt\ndev/aaronhowser/mods/irregular_implements/item/BiomeCrystalItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1617#2,9:59\n1869#2:68\n1870#2:70\n1626#2:71\n1#3:69\n*S KotlinDebug\n*F\n+ 1 BiomeCrystalItem.kt\ndev/aaronhowser/mods/irregular_implements/item/BiomeCrystalItem$Companion\n*L\n42#1:59,9\n42#1:68\n42#1:70\n42#1:71\n42#1:69\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ItemStack> getAllCrystals(@NotNull HolderLookup.Provider registries) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            List list = registries.lookupOrThrow(Registries.BIOME).listElements().toList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ItemStack itemStack;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Holder.Reference it = (Holder.Reference)element$iv$iv;
                boolean bl2 = false;
                if (it.is(ModBiomeTagsProvider.Companion.getBIOME_CRYSTAL_BLACKLIST())) {
                    itemStack = null;
                } else {
                    Intrinsics.checkNotNull((Object)it);
                    itemStack = Companion.getCrystal((Holder<Biome>)((Holder)it));
                }
                if (itemStack == null) continue;
                ItemStack it$iv$iv = itemStack;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final ItemStack getCrystal(@NotNull Holder<Biome> biomeHolder) {
            Intrinsics.checkNotNullParameter(biomeHolder, (String)"biomeHolder");
            ItemStack stack = ModItems.INSTANCE.getBIOME_CRYSTAL().toStack();
            stack.set((Supplier)ModDataComponents.INSTANCE.getBIOME(), biomeHolder);
            Intrinsics.checkNotNull((Object)stack);
            return stack;
        }

        public final int getItemColor(@NotNull ItemStack stack, int tintIndex) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Holder holder = (Holder)stack.get((Supplier)ModDataComponents.INSTANCE.getBIOME());
            int foliageColor = holder != null && (holder = (Biome)holder.value()) != null ? holder.getFoliageColor() : GrassColor.getDefaultColor();
            return foliageColor | 0xFF000000;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

