/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item;

import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModBlockTagsProvider;
import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModEntityTypeTagsProvider;
import dev.aaronhowser.mods.irregular_implements.item.component.BlockDataComponent;
import dev.aaronhowser.mods.irregular_implements.registry.ModDataComponents;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J.\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BlockMoverItem;", "Lnet/minecraft/world/item/Item;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "onItemUseFirst", "Lnet/minecraft/world/InteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "appendHoverText", "", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "Companion", "irregular-implements-1.21.1"})
public final class BlockMoverItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Item.Properties DEFAULT_PROPERTIES;
    private static boolean blockMoverPreventingContainerDrops;

    public BlockMoverItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, @NotNull UseOnContext context) {
        InteractionResult result;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.getPlayer();
        if (stack.isEmpty() || player == null || player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        BlockDataComponent blockDataComponent = (BlockDataComponent)stack.get((Supplier)ModDataComponents.INSTANCE.getBLOCK_DATA());
        InteractionResult interactionResult = result = blockDataComponent == null ? Companion.tryPickUpBlock(player, stack, context) : Companion.tryPlaceBlock(player, stack, context);
        if (blockDataComponent != null && result.indicateItemUse() && !player.hasInfiniteMaterials()) {
            stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
        }
        return result;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        MutableComponent mutableComponent;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        BlockDataComponent blockDataComponent = (BlockDataComponent)stack.get((Supplier)ModDataComponents.INSTANCE.getBLOCK_DATA());
        if (blockDataComponent == null) {
            return;
        }
        BlockDataComponent blockDataComponent2 = blockDataComponent;
        MutableComponent blockName = blockDataComponent2.getBlockState().getBlock().getName();
        if (blockName.getStyle().isEmpty()) {
            blockName = blockName.withStyle(ChatFormatting.GRAY);
        }
        if (blockDataComponent2.getBlockEntityNbt() == null) {
            mutableComponent = blockName;
        } else {
            Object[] objectArray = new Object[]{blockName};
            mutableComponent = ModLanguageProvider.Companion.toGrayComponent("tooltip.irregular_implements.with_block_entity", objectArray);
        }
        MutableComponent component = mutableComponent;
        Intrinsics.checkNotNull((Object)component);
        tooltipComponents.add((Component)component);
    }

    static {
        Item.Properties properties = new Item.Properties().durability(99);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"durability(...)");
        DEFAULT_PROPERTIES = properties;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/BlockMoverItem$Companion;", "", "<init>", "()V", "DEFAULT_PROPERTIES", "Lnet/minecraft/world/item/Item$Properties;", "getDEFAULT_PROPERTIES", "()Lnet/minecraft/world/item/Item$Properties;", "blockMoverPreventingContainerDrops", "", "handleEntityJoinLevel", "", "event", "Lnet/neoforged/neoforge/event/entity/EntityJoinLevelEvent;", "tryPickUpBlock", "Lnet/minecraft/world/InteractionResult;", "player", "Lnet/minecraft/world/entity/player/Player;", "stack", "Lnet/minecraft/world/item/ItemStack;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "tryPlaceBlock", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Item.Properties getDEFAULT_PROPERTIES() {
            return DEFAULT_PROPERTIES;
        }

        public final void handleEntityJoinLevel(@NotNull EntityJoinLevelEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Entity entity = event.getEntity();
            if (blockMoverPreventingContainerDrops && entity.getType().is(ModEntityTypeTagsProvider.Companion.getNOT_DROPPED_WHEN_MOVING_BLOCKS())) {
                entity.discard();
                event.setCanceled(true);
            }
        }

        @NotNull
        public final InteractionResult tryPickUpBlock(@NotNull Player player, @NotNull ItemStack stack, @NotNull UseOnContext context) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Level level = context.getLevel();
            BlockPos clickedPos = context.getClickedPos();
            BlockState clickedState = level.getBlockState(clickedPos);
            if (clickedState.isAir() || clickedState.getDestroySpeed((BlockGetter)level, clickedPos) == -1.0f || clickedState.is(ModBlockTagsProvider.Companion.getBLOCK_MOVER_BLACKLIST()) || !level.mayInteract(player, clickedPos) || !player.mayUseItemAt(clickedPos, context.getClickedFace(), stack) || ((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, clickedPos, clickedState, player))).isCanceled()) {
                return InteractionResult.FAIL;
            }
            BlockEntity blockEntity = level.getBlockEntity(clickedPos);
            if (level.isClientSide) {
                return InteractionResult.PASS;
            }
            RegistryAccess registryAccess = level.registryAccess();
            Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
            HolderLookup.Provider provider = (HolderLookup.Provider)registryAccess;
            Intrinsics.checkNotNull((Object)clickedState);
            BlockDataComponent blockDataComponent = new BlockDataComponent(provider, clickedState, blockEntity);
            stack.set((Supplier)ModDataComponents.INSTANCE.getBLOCK_DATA(), (Object)blockDataComponent);
            blockMoverPreventingContainerDrops = true;
            level.setBlockAndUpdate(clickedPos, Blocks.AIR.defaultBlockState());
            blockMoverPreventingContainerDrops = false;
            SoundType soundType = clickedState.getSoundType((LevelReader)level, clickedPos, (Entity)player);
            level.playSound(null, clickedPos, soundType.getBreakSound(), SoundSource.BLOCKS, (soundType.volume + 1.0f) / 2.0f, soundType.pitch * 0.8f);
            return InteractionResult.SUCCESS;
        }

        @NotNull
        public final InteractionResult tryPlaceBlock(@NotNull Player player, @NotNull ItemStack stack, @NotNull UseOnContext context) {
            block6: {
                block5: {
                    BlockPos posToPlaceBlock;
                    Intrinsics.checkNotNullParameter((Object)player, (String)"player");
                    Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Level level = context.getLevel();
                    ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
                    if (serverLevel == null) {
                        return InteractionResult.FAIL;
                    }
                    ServerLevel level2 = serverLevel;
                    BlockPos clickedPos = context.getClickedPos();
                    BlockState clickedState = level2.getBlockState(clickedPos);
                    BlockDataComponent blockDataComponent = (BlockDataComponent)stack.get((Supplier)ModDataComponents.INSTANCE.getBLOCK_DATA());
                    if (blockDataComponent == null) {
                        return InteractionResult.FAIL;
                    }
                    BlockDataComponent blockDataComponent2 = blockDataComponent;
                    BlockPos blockPos = posToPlaceBlock = clickedState.canBeReplaced() ? clickedPos : clickedPos.relative(context.getClickedFace());
                    if (!level2.mayInteract(player, clickedPos) || !player.mayUseItemAt(clickedPos, context.getClickedFace(), stack)) break block5;
                    Level level3 = (Level)level2;
                    Intrinsics.checkNotNull((Object)posToPlaceBlock);
                    if (blockDataComponent2.tryPlace(level3, posToPlaceBlock, player)) break block6;
                }
                return InteractionResult.FAIL;
            }
            stack.remove((Supplier)ModDataComponents.INSTANCE.getBLOCK_DATA());
            return InteractionResult.SUCCESS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

