/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.item.component;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001eB\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0013H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/component/ItemInventoryItemHandler;", "T", "Ldev/aaronhowser/mods/irregular_implements/item/component/ItemInventoryItemHandler$InventoryDataComponent;", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "stack", "Lnet/minecraft/world/item/ItemStack;", "dataComponentType", "Lnet/minecraft/core/component/DataComponentType;", "<init>", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/component/DataComponentType;)V", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "getDataComponentType", "()Lnet/minecraft/core/component/DataComponentType;", "copiedStacks", "Lnet/minecraft/core/NonNullList;", "getCopiedStacks", "()Lnet/minecraft/core/NonNullList;", "getSlots", "", "getStackInSlot", "slot", "setStackInSlot", "", "insertItem", "simulate", "", "extractItem", "amount", "onContentsChanged", "InventoryDataComponent", "irregular-implements-1.21.1"})
public class ItemInventoryItemHandler<T extends InventoryDataComponent>
extends ItemStackHandler {
    @NotNull
    private final ItemStack stack;
    @NotNull
    private final DataComponentType<T> dataComponentType;
    @NotNull
    private final NonNullList<ItemStack> copiedStacks;

    public ItemInventoryItemHandler(@NotNull ItemStack stack, @NotNull DataComponentType<T> dataComponentType) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(dataComponentType, (String)"dataComponentType");
        NonNullList nonNullList = (NonNullList)stack.get(dataComponentType);
        if (nonNullList == null || (nonNullList = nonNullList.getInventory()) == null) {
            nonNullList = NonNullList.create();
        }
        super(nonNullList);
        this.stack = stack;
        this.dataComponentType = dataComponentType;
        NonNullList nonNullList2 = NonNullList.withSize((int)this.stacks.size(), (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList2, (String)"withSize(...)");
        this.copiedStacks = nonNullList2;
        int n = ((Collection)this.stacks).size();
        for (int i = 0; i < n; ++i) {
            this.copiedStacks.set(i, (Object)((ItemStack)this.stacks.get(i)).copy());
        }
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    @NotNull
    public final DataComponentType<T> getDataComponentType() {
        return this.dataComponentType;
    }

    @NotNull
    public final NonNullList<ItemStack> getCopiedStacks() {
        return this.copiedStacks;
    }

    public int getSlots() {
        return this.copiedStacks.size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        Object object = this.copiedStacks.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (ItemStack)object;
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.validateSlotIndex(slot);
        this.copiedStacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack itemStack;
        boolean reachedLimit;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.isEmpty()) {
            ItemStack itemStack2 = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
            return itemStack2;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.isEmpty()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                this.copiedStacks.set(slot, (Object)(reachedLimit ? stack.copyWithCount(limit) : stack));
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
            this.onContentsChanged(slot);
        }
        if (reachedLimit) {
            ItemStack itemStack3 = stack.copyWithCount(stack.getCount() - limit);
            itemStack = itemStack3;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"copyWithCount(...)");
        } else {
            ItemStack itemStack4 = ItemStack.EMPTY;
            itemStack = itemStack4;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"EMPTY");
        }
        return itemStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.isEmpty()) {
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                ItemStack itemStack = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                this.setStackInSlot(slot, itemStack);
                this.onContentsChanged(slot);
                return existing;
            }
            ItemStack itemStack = existing.copy();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
            return itemStack;
        }
        if (!simulate) {
            this.copiedStacks.set(slot, (Object)existing.copyWithCount(existing.getCount() - toExtract));
            this.onContentsChanged(slot);
        }
        ItemStack itemStack = existing.copyWithCount(toExtract);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copyWithCount(...)");
        return itemStack;
    }

    protected void onContentsChanged(int slot) {
        block0: {
            super.onContentsChanged(slot);
            InventoryDataComponent inventoryDataComponent = (InventoryDataComponent)this.stack.get(this.dataComponentType);
            if (inventoryDataComponent == null) break block0;
            NonNullList nonNullList = NonNullList.copyOf((Collection)((Collection)this.copiedStacks));
            Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"copyOf(...)");
            inventoryDataComponent.setInventory(this.stack, (NonNullList<ItemStack>)nonNullList);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&\u00a8\u0006\t"}, d2={"Ldev/aaronhowser/mods/irregular_implements/item/component/ItemInventoryItemHandler$InventoryDataComponent;", "", "getInventory", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "setInventory", "", "stack", "inventory", "irregular-implements-1.21.1"})
    public static interface InventoryDataComponent {
        @NotNull
        public NonNullList<ItemStack> getInventory();

        public void setInventory(@NotNull ItemStack var1, @NotNull NonNullList<ItemStack> var2);
    }
}

