/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.menu.item_filter;

import dev.aaronhowser.mods.aaron.menu.BaseScreen;
import dev.aaronhowser.mods.aaron.menu.components.MultiStageSpriteButton;
import dev.aaronhowser.mods.aaron.menu.textures.ScreenBackground;
import dev.aaronhowser.mods.aaron.packet.c2s.ClientClickedMenuButton;
import dev.aaronhowser.mods.irregular_implements.datagen.ModLanguageProvider;
import dev.aaronhowser.mods.irregular_implements.menu.ScreenTextures;
import dev.aaronhowser.mods.irregular_implements.menu.item_filter.ChangingColorButton;
import dev.aaronhowser.mods.irregular_implements.menu.item_filter.ItemFilterMenu;
import dev.aaronhowser.mods.irregular_implements.util.FilterEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010!\u001a\u00020\u0014H\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/aaronhowser/mods/irregular_implements/menu/item_filter/ItemFilterScreen;", "Ldev/aaronhowser/mods/aaron/menu/BaseScreen;", "Ldev/aaronhowser/mods/irregular_implements/menu/item_filter/ItemFilterMenu;", "menu", "playerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "title", "Lnet/minecraft/network/chat/Component;", "<init>", "(Ldev/aaronhowser/mods/irregular_implements/menu/item_filter/ItemFilterMenu;Lnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/network/chat/Component;)V", "background", "Ldev/aaronhowser/mods/aaron/menu/textures/ScreenBackground;", "getBackground", "()Ldev/aaronhowser/mods/aaron/menu/textures/ScreenBackground;", "leftButtons", "", "Lnet/minecraft/client/gui/components/Button;", "rightButtons", "invertBlacklistButton", "baseInit", "", "setButtons", "addToggleBlacklistButton", "addLeftButton", "index", "", "leftMessageGetter", "", "Lnet/minecraft/network/chat/MutableComponent;", "leftColorGetter", "addRightButtons", "rightMessageGetter", "rightColorGetter", "containerTick", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nItemFilterScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemFilterScreen.kt\ndev/aaronhowser/mods/irregular_implements/menu/item_filter/ItemFilterScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n1563#2:243\n1634#2,3:244\n*S KotlinDebug\n*F\n+ 1 ItemFilterScreen.kt\ndev/aaronhowser/mods/irregular_implements/menu/item_filter/ItemFilterScreen\n*L\n181#1:243\n181#1:244,3\n*E\n"})
public final class ItemFilterScreen
extends BaseScreen<ItemFilterMenu> {
    @NotNull
    private final ScreenBackground background;
    @NotNull
    private final Set<Button> leftButtons;
    @NotNull
    private final Set<Button> rightButtons;
    private Button invertBlacklistButton;

    public ItemFilterScreen(@NotNull ItemFilterMenu menu, @NotNull Inventory playerInventory, @NotNull Component title) {
        Intrinsics.checkNotNullParameter((Object)((Object)menu), (String)"menu");
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.background = ScreenTextures.Backgrounds.INSTANCE.getITEM_FILTER();
        this.leftButtons = new LinkedHashSet();
        this.rightButtons = new LinkedHashSet();
    }

    @NotNull
    protected ScreenBackground getBackground() {
        return this.background;
    }

    public void baseInit() {
        this.inventoryLabelY = this.imageHeight - 94;
        this.setButtons();
    }

    private final void setButtons() {
        this.leftButtons.clear();
        this.rightButtons.clear();
        this.addToggleBlacklistButton();
        for (int index = 0; index < 9; ++index) {
            this.addLeftButton(index);
            this.addRightButtons(index);
        }
    }

    private final void addToggleBlacklistButton() {
        int x = this.leftPos + this.imageWidth - 24;
        int y = this.topPos + 5;
        Function0 onPress = ItemFilterScreen::addToggleBlacklistButton$lambda$0;
        Font font = this.font;
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font");
        this.invertBlacklistButton = (Button)new MultiStageSpriteButton.Builder(font).location(x, y).size(16).addStage((Component)ModLanguageProvider.Companion.toComponent("tooltip.irregular_implements.whitelist", new Object[0]), ScreenTextures.Sprites.ItemFilter.INSTANCE.getWHITELIST()).addStage((Component)ModLanguageProvider.Companion.toComponent("tooltip.irregular_implements.blacklist", new Object[0]), ScreenTextures.Sprites.ItemFilter.INSTANCE.getBLACKLIST()).currentStageGetter(() -> ItemFilterScreen.addToggleBlacklistButton$lambda$1(this)).onPress(onPress).build();
        Button button = this.invertBlacklistButton;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"invertBlacklistButton");
            button = null;
        }
        this.addRenderableWidget((GuiEventListener)button);
    }

    private final void addLeftButton(int index) {
        int x = this.leftPos + 8 + index * 18;
        int y = this.topPos + 15;
        int width = 8;
        int height = 8;
        int buttonId = ItemFilterMenu.Companion.getLeftButtonId(index);
        Supplier<List> supplier = () -> ItemFilterScreen.addLeftButton$lambda$2(this, index);
        Supplier<Integer> supplier2 = () -> ItemFilterScreen.addLeftButton$lambda$3(this, index);
        Font font = this.font;
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font");
        ChangingColorButton button = new ChangingColorButton(x, y, width, height, supplier, supplier2, font, arg_0 -> ItemFilterScreen.addLeftButton$lambda$4(buttonId, arg_0), null, 256, null);
        NonNullList<FilterEntry> nonNullList = ((ItemFilterMenu)this.menu).getFilter();
        button.visible = !FilterEntry.Companion.isNullOrEmpty(nonNullList != null ? (FilterEntry)CollectionsKt.getOrNull((List)((List)nonNullList), (int)index) : null);
        this.leftButtons.add(button);
        this.addRenderableWidget((GuiEventListener)button);
    }

    private final List<MutableComponent> leftMessageGetter(int index) {
        NonNullList<FilterEntry> nonNullList = ((ItemFilterMenu)this.menu).getFilter();
        FilterEntry filterAtIndex = nonNullList != null ? (FilterEntry)CollectionsKt.getOrNull((List)((List)nonNullList), (int)index) : null;
        Object[] objectArray = new MutableComponent[]{ModLanguageProvider.Companion.toComponent("tooltip.irregular_implements.item_filter_item", new Object[0]).withStyle(filterAtIndex instanceof FilterEntry.Item ? ChatFormatting.GRAY : ChatFormatting.DARK_GRAY), ModLanguageProvider.Companion.toComponent("tooltip.irregular_implements.item_filter_tag", new Object[0]).withStyle(filterAtIndex instanceof FilterEntry.Item ? ChatFormatting.DARK_GRAY : ChatFormatting.GRAY)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final int leftColorGetter(int index) {
        NonNullList<FilterEntry> nonNullList = ((ItemFilterMenu)this.menu).getFilter();
        FilterEntry filterAtIndex = nonNullList != null ? (FilterEntry)CollectionsKt.getOrNull((List)((List)nonNullList), (int)index) : null;
        return filterAtIndex instanceof FilterEntry.Item ? -10917377 : -16730206;
    }

    private final void addRightButtons(int index) {
        int x = this.leftPos + 8 + index * 18 + 9;
        int y = this.topPos + 15;
        int width = 8;
        int height = 8;
        int buttonId = ItemFilterMenu.Companion.getRightButtonId(index);
        Supplier<List> supplier = () -> ItemFilterScreen.addRightButtons$lambda$5(this, index);
        Supplier<Integer> supplier2 = () -> ItemFilterScreen.addRightButtons$lambda$6(this, index);
        Font font = this.font;
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"font");
        ChangingColorButton button = new ChangingColorButton(x, y, width, height, supplier, supplier2, font, arg_0 -> ItemFilterScreen.addRightButtons$lambda$7(buttonId, arg_0), null, 256, null);
        NonNullList<FilterEntry> nonNullList = ((ItemFilterMenu)this.menu).getFilter();
        button.visible = !FilterEntry.Companion.isNullOrEmpty(nonNullList != null ? (FilterEntry)CollectionsKt.getOrNull((List)((List)nonNullList), (int)index) : null);
        this.rightButtons.add(button);
        this.addRenderableWidget((GuiEventListener)button);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MutableComponent> rightMessageGetter(int index) {
        List list;
        NonNullList<FilterEntry> nonNullList = ((ItemFilterMenu)this.menu).getFilter();
        FilterEntry filterAtIndex = nonNullList != null ? (FilterEntry)CollectionsKt.getOrNull((List)((List)nonNullList), (int)index) : null;
        if (filterAtIndex instanceof FilterEntry.Item) {
            Object[] objectArray = new MutableComponent[]{ModLanguageProvider.Companion.toComponent("tooltip.irregular_implements.item_filter_ignore_components", new Object[0]).withStyle(((FilterEntry.Item)filterAtIndex).getRequireSameComponents() ? ChatFormatting.DARK_GRAY : ChatFormatting.GRAY), ModLanguageProvider.Companion.toComponent("tooltip.irregular_implements.item_filter_require_components", new Object[0]).withStyle(((FilterEntry.Item)filterAtIndex).getRequireSameComponents() ? ChatFormatting.GRAY : ChatFormatting.DARK_GRAY)};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (filterAtIndex instanceof FilterEntry.Tag) {
            void $this$mapTo$iv$iv;
            List itemTags = ((FilterEntry.Tag)filterAtIndex).getBackupStack().getTags().toList();
            Intrinsics.checkNotNull(itemTags);
            Iterable $this$map$iv = itemTags;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TagKey tagKey = (TagKey)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Component.literal((String)it.location().toString()).withStyle(Intrinsics.areEqual((Object)it, ((FilterEntry.Tag)filterAtIndex).getTagKey()) ? ChatFormatting.GRAY : ChatFormatting.DARK_GRAY));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.listOf((Object)Component.empty());
        }
        return list;
    }

    private final int rightColorGetter(int index) {
        int n;
        NonNullList<FilterEntry> nonNullList = ((ItemFilterMenu)this.menu).getFilter();
        FilterEntry filterAtIndex = nonNullList != null ? (FilterEntry)CollectionsKt.getOrNull((List)((List)nonNullList), (int)index) : null;
        if (filterAtIndex instanceof FilterEntry.Item) {
            n = ((FilterEntry.Item)filterAtIndex).getRequireSameComponents() ? -13121988 : -43485;
        } else if (filterAtIndex instanceof FilterEntry.Tag) {
            int rgb;
            List itemTags = ((FilterEntry.Tag)filterAtIndex).getBackupStack().getTags().toList();
            int currentTagIndex = itemTags.indexOf(((FilterEntry.Tag)filterAtIndex).getTagKey());
            n = rgb = Mth.hsvToArgb((float)((float)currentTagIndex / (float)itemTags.size()), (float)1.0f, (float)1.0f, (int)255);
        } else {
            n = 0;
        }
        return n;
    }

    protected void containerTick() {
        int buttonIndex;
        super.containerTick();
        int n = ((Collection)this.leftButtons).size();
        for (buttonIndex = 0; buttonIndex < n; ++buttonIndex) {
            if ((Button)CollectionsKt.elementAtOrNull((Iterable)this.leftButtons, (int)buttonIndex) == null) continue;
            NonNullList<FilterEntry> nonNullList = ((ItemFilterMenu)this.menu).getFilter();
            button.visible = !FilterEntry.Companion.isNullOrEmpty(nonNullList != null ? (FilterEntry)CollectionsKt.getOrNull((List)((List)nonNullList), (int)buttonIndex) : null);
        }
        n = ((Collection)this.rightButtons).size();
        for (buttonIndex = 0; buttonIndex < n; ++buttonIndex) {
            if ((Button)CollectionsKt.elementAtOrNull((Iterable)this.rightButtons, (int)buttonIndex) == null) continue;
            NonNullList<FilterEntry> nonNullList = ((ItemFilterMenu)this.menu).getFilter();
            button.visible = !FilterEntry.Companion.isNullOrEmpty(nonNullList != null ? (FilterEntry)CollectionsKt.getOrNull((List)((List)nonNullList), (int)buttonIndex) : null);
        }
    }

    private static final Unit addToggleBlacklistButton$lambda$0() {
        ClientClickedMenuButton packet = new ClientClickedMenuButton(0);
        packet.messageServer();
        return Unit.INSTANCE;
    }

    private static final Integer addToggleBlacklistButton$lambda$1(ItemFilterScreen this$0) {
        return ((ItemFilterMenu)this$0.menu).getIsBlacklist() ? Integer.valueOf(1) : Integer.valueOf(0);
    }

    private static final List addLeftButton$lambda$2(ItemFilterScreen this$0, int $index) {
        return this$0.leftMessageGetter($index);
    }

    private static final Integer addLeftButton$lambda$3(ItemFilterScreen this$0, int $index) {
        return this$0.leftColorGetter($index);
    }

    private static final void addLeftButton$lambda$4(int $buttonId, Button it) {
        ClientClickedMenuButton packet = new ClientClickedMenuButton($buttonId);
        packet.messageServer();
    }

    private static final List addRightButtons$lambda$5(ItemFilterScreen this$0, int $index) {
        return this$0.rightMessageGetter($index);
    }

    private static final Integer addRightButtons$lambda$6(ItemFilterScreen this$0, int $index) {
        return this$0.rightColorGetter($index);
    }

    private static final void addRightButtons$lambda$7(int $buttonId, Button it) {
        ClientClickedMenuButton packet = new ClientClickedMenuButton($buttonId);
        packet.messageServer();
    }
}

