/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.recipe.machine;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.aaronhowser.mods.irregular_implements.recipe.machine.ImbuingInput;
import dev.aaronhowser.mods.irregular_implements.recipe.machine.ImbuingRecipe;
import dev.aaronhowser.mods.irregular_implements.registry.ModRecipeSerializers;
import dev.aaronhowser.mods.irregular_implements.registry.ModRecipeTypes;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002$%B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016J\f\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006&"}, d2={"Ldev/aaronhowser/mods/irregular_implements/recipe/machine/ImbuingRecipe;", "Lnet/minecraft/world/item/crafting/Recipe;", "Ldev/aaronhowser/mods/irregular_implements/recipe/machine/ImbuingInput;", "outerIngredients", "", "Lnet/minecraft/world/item/crafting/Ingredient;", "centerIngredient", "output", "Lnet/minecraft/world/item/ItemStack;", "<init>", "(Ljava/util/List;Lnet/minecraft/world/item/crafting/Ingredient;Lnet/minecraft/world/item/ItemStack;)V", "getOuterIngredients", "()Ljava/util/List;", "getCenterIngredient", "()Lnet/minecraft/world/item/crafting/Ingredient;", "getOutput", "()Lnet/minecraft/world/item/ItemStack;", "getIngredients", "Lnet/minecraft/core/NonNullList;", "matches", "", "input", "level", "Lnet/minecraft/world/level/Level;", "assemble", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "canCraftInDimensions", "width", "", "height", "getResultItem", "getSerializer", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "getType", "Lnet/minecraft/world/item/crafting/RecipeType;", "Serializer", "Companion", "irregular-implements-1.21.1"})
public final class ImbuingRecipe
implements Recipe<ImbuingInput> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Ingredient> outerIngredients;
    @NotNull
    private final Ingredient centerIngredient;
    @NotNull
    private final ItemStack output;

    public ImbuingRecipe(@NotNull List<Ingredient> outerIngredients, @NotNull Ingredient centerIngredient, @NotNull ItemStack output) {
        Intrinsics.checkNotNullParameter(outerIngredients, (String)"outerIngredients");
        Intrinsics.checkNotNullParameter((Object)centerIngredient, (String)"centerIngredient");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.outerIngredients = outerIngredients;
        this.centerIngredient = centerIngredient;
        this.output = output;
    }

    @NotNull
    public final List<Ingredient> getOuterIngredients() {
        return this.outerIngredients;
    }

    @NotNull
    public final Ingredient getCenterIngredient() {
        return this.centerIngredient;
    }

    @NotNull
    public final ItemStack getOutput() {
        return this.output;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.addAll((Collection)this.outerIngredients);
        list.add((Object)this.centerIngredient);
        Intrinsics.checkNotNull((Object)list);
        return list;
    }

    public boolean matches(@NotNull ImbuingInput input, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        List<ItemStack> outerItems = input.getOuterItems();
        ItemStack innerItem = input.getCenterItem();
        if (outerItems.size() != this.outerIngredients.size()) {
            return false;
        }
        if (!this.centerIngredient.test(innerItem)) {
            return false;
        }
        List missingOuterItems = CollectionsKt.toMutableList((Collection)outerItems);
        for (Ingredient outerIngredient : this.outerIngredients) {
            Iterator iterator = missingOuterItems.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                ItemStack outerItem = (ItemStack)iterator.next();
                if (!outerIngredient.test(outerItem)) continue;
                iterator.remove();
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return missingOuterItems.isEmpty();
    }

    @NotNull
    public ItemStack assemble(@NotNull ImbuingInput input, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ItemStack itemStack = this.output.copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        return itemStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        ItemStack itemStack = this.output.copy();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"copy(...)");
        return itemStack;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        Object object = ModRecipeSerializers.INSTANCE.getIMBUING().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeSerializer)object;
    }

    @NotNull
    public RecipeType<?> getType() {
        Object object = ModRecipeTypes.INSTANCE.getIMBUING().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (RecipeType)object;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Ldev/aaronhowser/mods/irregular_implements/recipe/machine/ImbuingRecipe$Companion;", "", "<init>", "()V", "getRecipe", "Ldev/aaronhowser/mods/irregular_implements/recipe/machine/ImbuingRecipe;", "level", "Lnet/minecraft/world/level/Level;", "input", "Ldev/aaronhowser/mods/irregular_implements/recipe/machine/ImbuingInput;", "hasRecipe", "", "getAllRecipes", "", "Lnet/minecraft/world/item/crafting/RecipeHolder;", "recipeManager", "Lnet/minecraft/world/item/crafting/RecipeManager;", "irregular-implements-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ImbuingRecipe getRecipe(@NotNull Level level, @NotNull ImbuingInput input) {
            Object v1;
            block1: {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                List list = level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.INSTANCE.getIMBUING().get());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllRecipesFor(...)");
                Iterable iterable = list;
                for (Object t : iterable) {
                    RecipeHolder recipeHolder = (RecipeHolder)t;
                    boolean bl = false;
                    if (!((ImbuingRecipe)recipeHolder.value()).matches(input, level)) continue;
                    v1 = t;
                    break block1;
                }
                v1 = null;
            }
            RecipeHolder recipeHolder = v1;
            return recipeHolder != null ? (ImbuingRecipe)recipeHolder.value() : null;
        }

        public final boolean hasRecipe(@NotNull Level level, @NotNull ImbuingInput input) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return this.getRecipe(level, input) != null;
        }

        @NotNull
        public final List<RecipeHolder<ImbuingRecipe>> getAllRecipes(@NotNull RecipeManager recipeManager) {
            Intrinsics.checkNotNullParameter((Object)recipeManager, (String)"recipeManager");
            List list = recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.INSTANCE.getIMBUING().get());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllRecipesFor(...)");
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Ldev/aaronhowser/mods/irregular_implements/recipe/machine/ImbuingRecipe$Serializer;", "Lnet/minecraft/world/item/crafting/RecipeSerializer;", "Ldev/aaronhowser/mods/irregular_implements/recipe/machine/ImbuingRecipe;", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "streamCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "Companion", "irregular-implements-1.21.1"})
    public static final class Serializer
    implements RecipeSerializer<ImbuingRecipe> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final MapCodec<ImbuingRecipe> CODEC;
        @NotNull
        private static final StreamCodec<RegistryFriendlyByteBuf, ImbuingRecipe> STREAM_CODEC;

        @NotNull
        public MapCodec<ImbuingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ImbuingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static final List CODEC$lambda$3$lambda$0(KProperty1 $tmp0, ImbuingRecipe p0) {
            return (List)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Ingredient CODEC$lambda$3$lambda$1(KProperty1 $tmp0, ImbuingRecipe p0) {
            return (Ingredient)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final ItemStack CODEC$lambda$3$lambda$2(KProperty1 $tmp0, ImbuingRecipe p0) {
            return (ItemStack)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final App CODEC$lambda$3(RecordCodecBuilder.Instance instance) {
            return instance.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("outer_ingredients").forGetter(arg_0 -> Serializer.CODEC$lambda$3$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Ingredient.CODEC_NONEMPTY.fieldOf("center_ingredient").forGetter(arg_0 -> Serializer.CODEC$lambda$3$lambda$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)ItemStack.CODEC.fieldOf("output").forGetter(arg_0 -> Serializer.CODEC$lambda$3$lambda$2((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0))).apply((Applicative)instance, ImbuingRecipe::new);
        }

        private static final List STREAM_CODEC$lambda$4(KProperty1 $tmp0, ImbuingRecipe p0) {
            return (List)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final Ingredient STREAM_CODEC$lambda$5(KProperty1 $tmp0, ImbuingRecipe p0) {
            return (Ingredient)((Function1)$tmp0).invoke((Object)p0);
        }

        private static final ItemStack STREAM_CODEC$lambda$6(KProperty1 $tmp0, ImbuingRecipe p0) {
            return (ItemStack)((Function1)$tmp0).invoke((Object)p0);
        }

        static {
            MapCodec mapCodec = RecordCodecBuilder.mapCodec(Serializer::CODEC$lambda$3);
            Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
            CODEC = mapCodec;
            StreamCodec streamCodec = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), arg_0 -> Serializer.STREAM_CODEC$lambda$4((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, arg_0 -> Serializer.STREAM_CODEC$lambda$5((KProperty1)Companion.STREAM_CODEC.2.INSTANCE, arg_0), (StreamCodec)ItemStack.STREAM_CODEC, arg_0 -> Serializer.STREAM_CODEC$lambda$6((KProperty1)Companion.STREAM_CODEC.3.INSTANCE, arg_0), ImbuingRecipe::new);
            Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
            STREAM_CODEC = streamCodec;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/aaronhowser/mods/irregular_implements/recipe/machine/ImbuingRecipe$Serializer$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/aaronhowser/mods/irregular_implements/recipe/machine/ImbuingRecipe;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "irregular-implements-1.21.1"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MapCodec<ImbuingRecipe> getCODEC() {
                return CODEC;
            }

            @NotNull
            public final StreamCodec<RegistryFriendlyByteBuf, ImbuingRecipe> getSTREAM_CODEC() {
                return STREAM_CODEC;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

