/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.irregular_implements.util;

import dev.aaronhowser.mods.irregular_implements.datagen.tag.ModBlockTagsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000bJ\u0014\u0010\u0019\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001bJ\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001dJ\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#J \u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020 J(\u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010&\u001a\u00020 J\u001e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020*J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u000201H\u0007J;\u00102\u001a\u0002H3\"\b\b\u0000\u00103*\u0002042\u0006\u00105\u001a\u0002062\f\u00107\u001a\b\u0012\u0004\u0012\u0002H3082\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u0007\u00a2\u0006\u0002\u0010;\u00a8\u0006<"}, d2={"Ldev/aaronhowser/mods/irregular_implements/util/OtherUtil;", "", "<init>", "()V", "modResource", "Lnet/minecraft/resources/ResourceLocation;", "path", "", "getPotionStack", "Lnet/minecraft/world/item/ItemStack;", "potion", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/item/alchemy/Potion;", "getPovResult", "Lnet/minecraft/world/phys/BlockHitResult;", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "range", "", "getBiomeComponent", "Lnet/minecraft/network/chat/Component;", "biomeHolder", "Lnet/minecraft/world/level/biome/Biome;", "getDimensionComponent", "dimensionResourceKey", "Lnet/minecraft/resources/ResourceKey;", "flattenStacks", "", "input", "giveOrDropStack", "", "itemStack", "player", "Lnet/minecraft/world/entity/player/Player;", "dropStackAt", "Lnet/minecraft/world/entity/Entity;", "instantPickup", "pos", "Lnet/minecraft/world/phys/Vec3;", "lerpColor", "", "progress", "", "start", "end", "shouldSpiderNotClimb", "spider", "Lnet/minecraft/world/entity/monster/Spider;", "updateSavedDataLocation", "T", "Lnet/minecraft/world/level/saveddata/SavedData;", "storage", "Lnet/minecraft/world/level/storage/DimensionDataStorage;", "factory", "Lnet/minecraft/world/level/saveddata/SavedData$Factory;", "newFileName", "oldFileName", "(Lnet/minecraft/world/level/storage/DimensionDataStorage;Lnet/minecraft/world/level/saveddata/SavedData$Factory;Ljava/lang/String;Ljava/lang/String;)Lnet/minecraft/world/level/saveddata/SavedData;", "irregular-implements-1.21.1"})
@SourceDebugExtension(value={"SMAP\nOtherUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OtherUtil.kt\ndev/aaronhowser/mods/irregular_implements/util/OtherUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n774#2:176\n865#2,2:177\n1563#2:179\n1634#2,3:180\n295#2,2:183\n*S KotlinDebug\n*F\n+ 1 OtherUtil.kt\ndev/aaronhowser/mods/irregular_implements/util/OtherUtil\n*L\n81#1:176\n81#1:177,2\n81#1:179\n81#1:180,3\n82#1:183,2\n*E\n"})
public final class OtherUtil {
    @NotNull
    public static final OtherUtil INSTANCE = new OtherUtil();

    private OtherUtil() {
    }

    @JvmStatic
    @NotNull
    public static final ResourceLocation modResource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"irregular_implements", (String)path);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        return resourceLocation;
    }

    @NotNull
    public final ItemStack getPotionStack(@NotNull Holder<Potion> potion) {
        Intrinsics.checkNotNullParameter(potion, (String)"potion");
        ItemStack itemStack = PotionContents.createItemStack((Item)Items.POTION, potion);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"createItemStack(...)");
        return itemStack;
    }

    @NotNull
    public final BlockHitResult getPovResult(@NotNull Level level, @NotNull LivingEntity entity, @NotNull Number range) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        BlockHitResult blockHitResult = level.clip(new ClipContext(entity.getEyePosition(), entity.getEyePosition().add(entity.getLookAngle().scale(range.doubleValue())), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
        Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"clip(...)");
        return blockHitResult;
    }

    @NotNull
    public final Component getBiomeComponent(@NotNull Holder<Biome> biomeHolder) {
        Intrinsics.checkNotNullParameter(biomeHolder, (String)"biomeHolder");
        ResourceKey resourceKey = biomeHolder.getKey();
        Intrinsics.checkNotNull((Object)resourceKey);
        ResourceKey biomeKey = resourceKey;
        String probableTranslationKey = "biome." + biomeKey.location().getNamespace() + "." + biomeKey.location().getPath();
        boolean hasTranslation = I18n.exists((String)probableTranslationKey);
        MutableComponent mutableComponent = (hasTranslation ? Component.translatable((String)probableTranslationKey) : Component.literal((String)biomeKey.location().toString())).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public final Component getDimensionComponent(@NotNull ResourceKey<Level> dimensionResourceKey) {
        Intrinsics.checkNotNullParameter(dimensionResourceKey, (String)"dimensionResourceKey");
        ResourceLocation location = dimensionResourceKey.location();
        String probableTranslationKey = "dimension." + location.getNamespace() + "." + location.getPath();
        boolean hasTranslation = I18n.exists((String)probableTranslationKey);
        MutableComponent mutableComponent = (hasTranslation ? Component.translatable((String)probableTranslationKey) : Component.literal((String)location.toString())).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        return (Component)mutableComponent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemStack> flattenStacks(@NotNull List<ItemStack> input) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ItemStack it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        List output = new ArrayList();
        Iterable $this$filter$iv = input;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ItemStack)element$iv$iv;
            boolean bl = false;
            if (!(!it.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ItemStack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.copy());
        }
        for (ItemStack stack : (List)destination$iv$iv) {
            int amountToAdd;
            Object v0;
            block5: {
                Iterable $this$firstOrNull$iv = output;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ItemStack it2 = (ItemStack)element$iv;
                    boolean bl = false;
                    if (!ItemStack.isSameItemSameComponents((ItemStack)it2, (ItemStack)stack)) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            ItemStack matchingStack = v0;
            if (matchingStack != null && (amountToAdd = Math.min(stack.getCount(), matchingStack.getMaxStackSize() - matchingStack.getCount())) > 0) {
                matchingStack.grow(amountToAdd);
                stack.shrink(amountToAdd);
            }
            if (stack.isEmpty()) continue;
            Intrinsics.checkNotNull((Object)stack);
            output.add(stack);
        }
        return output;
    }

    public final boolean giveOrDropStack(@NotNull ItemStack itemStack, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return player.getInventory().add(itemStack) || this.dropStackAt(itemStack, (Entity)player, true);
    }

    public final boolean dropStackAt(@NotNull ItemStack itemStack, @NotNull Entity entity, boolean instantPickup) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Level level = entity.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        Vec3 vec3 = entity.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        return this.dropStackAt(itemStack, level, vec3, instantPickup);
    }

    public static /* synthetic */ boolean dropStackAt$default(OtherUtil otherUtil, ItemStack itemStack, Entity entity, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return otherUtil.dropStackAt(itemStack, entity, bl);
    }

    public final boolean dropStackAt(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Vec3 pos, boolean instantPickup) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        ItemEntity itemEntity = new ItemEntity(level, pos.x, pos.y, pos.z, itemStack);
        if (instantPickup) {
            itemEntity.setNoPickUpDelay();
        }
        return level.addFreshEntity((Entity)itemEntity);
    }

    public static /* synthetic */ boolean dropStackAt$default(OtherUtil otherUtil, ItemStack itemStack, Level level, Vec3 vec3, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return otherUtil.dropStackAt(itemStack, level, vec3, bl);
    }

    public final int lerpColor(float progress, int start, int end) {
        int startR = start >> 16 & 0xFF;
        int startG = start >> 8 & 0xFF;
        int startB = start & 0xFF;
        int endR = end >> 16 & 0xFF;
        int endG = end >> 8 & 0xFF;
        int endB = end & 0xFF;
        int r = (int)Mth.lerp((float)progress, (float)startR, (float)endR);
        int g = (int)Mth.lerp((float)progress, (float)startG, (float)endG);
        int b = (int)Mth.lerp((float)progress, (float)startB, (float)endB);
        return r << 16 | g << 8 | b;
    }

    @JvmStatic
    public static final boolean shouldSpiderNotClimb(@NotNull Spider spider) {
        Intrinsics.checkNotNullParameter((Object)spider, (String)"spider");
        if (!spider.horizontalCollision) {
            return false;
        }
        Iterable adjacentPositions = BlockPos.betweenClosed((BlockPos)spider.blockPosition().offset(-1, 0, -1), (BlockPos)spider.blockPosition().offset(1, 0, 1));
        Level level = spider.level();
        for (BlockPos pos : adjacentPositions) {
            if (!level.getBlockState(pos).is(ModBlockTagsProvider.SUPER_LUBRICATED)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final <T extends SavedData> T updateSavedDataLocation(@NotNull DimensionDataStorage storage, @NotNull SavedData.Factory<T> factory, @NotNull String newFileName, @NotNull String oldFileName) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)newFileName, (String)"newFileName");
        Intrinsics.checkNotNullParameter((Object)oldFileName, (String)"oldFileName");
        SavedData newData = storage.get(factory, newFileName);
        SavedData oldData = storage.get(factory, oldFileName);
        if (newData != null) {
            return (T)newData;
        }
        if (oldData != null) {
            storage.set(newFileName, oldData);
            oldData.setDirty(true);
            return (T)oldData;
        }
        SavedData savedData = storage.computeIfAbsent(factory, newFileName);
        Intrinsics.checkNotNullExpressionValue((Object)savedData, (String)"computeIfAbsent(...)");
        return (T)savedData;
    }
}

