/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BookCommandModel {
    protected BookModel book;
    protected ResourceLocation id;
    protected String command;
    protected int permissionLevel = 0;
    protected int maxUses = 1;
    @Nullable
    protected String failureMessage;
    @Nullable
    protected String successMessage;
    protected Set<ResourceLocation> allowedEntries = new HashSet<ResourceLocation>();

    protected BookCommandModel(ResourceLocation id, String command) {
        this.id = id;
        this.command = command;
    }

    public static BookCommandModel create(ResourceLocation id, String command) {
        return new BookCommandModel(id, command);
    }

    public BookModel getBook() {
        return this.book;
    }

    public JsonObject toJson(HolderLookup.Provider provider) {
        JsonObject json = new JsonObject();
        json.addProperty("command", this.command);
        json.addProperty("permission_level", (Number)this.permissionLevel);
        json.addProperty("max_uses", (Number)this.maxUses);
        if (this.failureMessage != null) {
            json.addProperty("failure_message", this.failureMessage);
        }
        if (this.successMessage != null) {
            json.addProperty("success_message", this.successMessage);
        }
        if (this.allowedEntries != null && !this.allowedEntries.isEmpty()) {
            JsonArray arr = new JsonArray();
            for (ResourceLocation entry : this.allowedEntries) {
                arr.add(entry.toString());
            }
            json.add("allowed_entries", (JsonElement)arr);
        }
        return json;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getCommand() {
        return this.command;
    }

    public int getPermissionLevel() {
        return this.permissionLevel;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    @Nullable
    public String getFailureMessage() {
        return this.failureMessage;
    }

    @Nullable
    public String getSuccessMessage() {
        return this.successMessage;
    }

    public BookCommandModel withPermissionLevel(int permissionLevel) {
        this.permissionLevel = permissionLevel;
        return this;
    }

    public BookCommandModel withMaxUses(int maxUses) {
        this.maxUses = maxUses;
        return this;
    }

    public BookCommandModel withFailureMessage(@Nullable String failureMessage) {
        this.failureMessage = failureMessage;
        return this;
    }

    public BookCommandModel withSuccessMessage(@Nullable String successMessage) {
        this.successMessage = successMessage;
        return this;
    }

    public BookCommandModel withAllowedEntries(Set<ResourceLocation> allowedEntries) {
        this.allowedEntries = allowedEntries == null ? new HashSet<ResourceLocation>() : new HashSet<ResourceLocation>(allowedEntries);
        return this;
    }

    public BookCommandModel withAllowedEntry(ResourceLocation entry) {
        this.allowedEntries.add(entry);
        return this;
    }

    public BookCommandModel withAllowedEntry(String entry) {
        this.allowedEntries.add(ResourceLocation.parse((String)entry));
        return this;
    }
}

