/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.bookstate;

import com.klikli_dev.modonomicon.bookstate.BookUnlockStates;
import com.klikli_dev.modonomicon.bookstate.BookVisualStates;
import com.klikli_dev.modonomicon.util.Codecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class BookStatesSaveData
extends SavedData {
    public static final Codec<BookStatesSaveData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(Codecs.UUID, BookUnlockStates.CODEC).fieldOf("unlockStates").forGetter(state -> state.unlockStates), (App)Codec.unboundedMap(Codecs.UUID, BookVisualStates.CODEC).fieldOf("visualStates").forGetter(state -> state.visualStates)).apply((Applicative)instance, BookStatesSaveData::new));
    public static final String ID = "modonomicon_book_states";
    public Map<UUID, BookUnlockStates> unlockStates;
    public Map<UUID, BookVisualStates> visualStates;

    public BookStatesSaveData() {
        this((Map<UUID, BookUnlockStates>)Object2ObjectMaps.emptyMap(), (Map<UUID, BookVisualStates>)Object2ObjectMaps.emptyMap());
    }

    public BookStatesSaveData(Map<UUID, BookUnlockStates> unlockStates, Map<UUID, BookVisualStates> visualStates) {
        this.unlockStates = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap(unlockStates));
        this.visualStates = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap(visualStates));
        this.setDirty();
    }

    public static BookStatesSaveData load(CompoundTag pCompoundTag, HolderLookup.Provider pHolderProvider) {
        return CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pCompoundTag.get("bookStates")).result().orElse(new BookStatesSaveData());
    }

    public BookUnlockStates getUnlockStates(UUID playerUUID) {
        return this.unlockStates.computeIfAbsent(playerUUID, uuid -> {
            this.setDirty();
            return new BookUnlockStates();
        });
    }

    public BookVisualStates getVisualStates(UUID playerUUID) {
        return this.visualStates.computeIfAbsent(playerUUID, uuid -> {
            this.setDirty();
            return new BookVisualStates();
        });
    }

    @NotNull
    public CompoundTag save(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pHolderProvider) {
        compoundTag.put("bookStates", (Tag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).result().orElseThrow());
        return compoundTag;
    }
}

