/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.bookstate;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.bookstate.BookStatesSaveData;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStates;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.networking.RequestSyncBookStatesMessage;
import com.klikli_dev.modonomicon.networking.SyncBookUnlockStatesMessage;
import com.klikli_dev.modonomicon.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class BookUnlockStateManager {
    private static final BookUnlockStateManager instance = new BookUnlockStateManager();
    private final Set<UUID> syncRequestedPlayers = new ObjectLinkedOpenHashSet();
    private final Set<UUID> advancementUpdateRequestedPlayers = new ObjectLinkedOpenHashSet();
    private final Object2LongArrayMap<UUID> lastAdvancementUpdateRequests = new Object2LongArrayMap();
    public BookStatesSaveData saveData;
    private boolean wasLoaded = false;

    public static BookUnlockStateManager get() {
        return instance;
    }

    private BookUnlockStates getStateFor(Player player) {
        this.getSaveDataIfNecessary(player);
        return this.saveData.getUnlockStates(player.getUUID());
    }

    public String getUnlockCodeFor(Player player, Book book) {
        return this.getStateFor(player).getUnlockCode(book);
    }

    public Book applyUnlockCodeFor(ServerPlayer player, String unlockCode) {
        Book book = this.getStateFor((Player)player).applyUnlockCode(unlockCode);
        if (book != null) {
            this.saveData.setDirty();
            this.syncFor(player);
        }
        return book;
    }

    public void syncFor(ServerPlayer player) {
        Services.NETWORK.sendTo(player, new SyncBookUnlockStatesMessage(this.getStateFor((Player)player)));
    }

    public void updateAndSyncFor(ServerPlayer player) {
        if (BookDataManager.get().areBooksBuilt()) {
            this.getStateFor((Player)player).update(player);
            this.saveData.setDirty();
            this.syncFor(player);
        } else {
            this.syncRequestedPlayers.add(player.getUUID());
            this.wasLoaded = false;
        }
    }

    public List<ResourceLocation> getBooksFor(Player player) {
        return this.getStateFor(player).getBooks();
    }

    public void resetFor(ServerPlayer player, Book book) {
        this.getStateFor((Player)player).reset(book);
        this.saveData.setDirty();
        this.syncFor(player);
    }

    public boolean isUnlockedFor(Player player, BookCategory category) {
        return this.getStateFor(player).isUnlocked(category);
    }

    public boolean isUnlockedFor(Player player, BookEntry entry) {
        return this.getStateFor(player).isUnlocked(entry);
    }

    public boolean isUnlockedFor(Player player, BookPage page) {
        return this.getStateFor(player).isUnlocked(page);
    }

    public List<BookPage> getUnlockedPagesFor(Player player, BookEntry entry) {
        return this.getStateFor(player).getUnlockedPagesIn(entry);
    }

    public boolean isReadFor(Player player, BookEntry entry) {
        return this.getStateFor(player).isRead(entry);
    }

    public boolean canRunFor(Player player, BookCommand command) {
        return this.getStateFor(player).canRun(command);
    }

    public void setRunFor(Player player, BookCommand command) {
        this.getStateFor(player).setRun(command);
    }

    public boolean readFor(ServerPlayer player, BookEntry entry) {
        return this.getStateFor((Player)player).read(entry, player);
    }

    public void onAdvancement(ServerPlayer player) {
        long lastAdvancementUpdateRequest = this.lastAdvancementUpdateRequests.getOrDefault((Object)player.getUUID(), 0L);
        this.lastAdvancementUpdateRequests.put((Object)player.getUUID(), player.level().getGameTime());
        if (player.level().getGameTime() - lastAdvancementUpdateRequest > 100L) {
            this.updateAndSyncFor(player);
        } else {
            this.advancementUpdateRequestedPlayers.add(player.getUUID());
        }
    }

    private void getSaveDataIfNecessary(Player player) {
        if (this.saveData == null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.saveData = (BookStatesSaveData)serverPlayer.getServer().overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(BookStatesSaveData::new, BookStatesSaveData::load, DataFixTypes.PLAYER), "modonomicon_book_states");
            } else {
                this.saveData = new BookStatesSaveData();
                Services.NETWORK.sendToServer(RequestSyncBookStatesMessage.INSTANCE);
                Modonomicon.LOG.error("Tried to get Modonomicon save data for player on client side, but was not set. This should not happen. Requesting a sync from the server. Please re-open the book in a few seconds to see your progress.");
            }
        }
    }

    public void onServerTickEnd(MinecraftServer server) {
        this.handleSyncRequestedPlayers(server);
        this.handleAdvancementUpdateRequestedPlayers(server);
    }

    public void handleAdvancementUpdateRequestedPlayers(MinecraftServer server) {
        if (server.getTickCount() % 100 != 0) {
            return;
        }
        if (!this.advancementUpdateRequestedPlayers.isEmpty()) {
            PlayerList list = server.getPlayerList();
            for (UUID id : this.advancementUpdateRequestedPlayers) {
                ServerPlayer player = list.getPlayer(id);
                if (player == null) continue;
                this.updateAndSyncFor(player);
            }
            this.advancementUpdateRequestedPlayers.clear();
        }
    }

    public void handleSyncRequestedPlayers(MinecraftServer server) {
        if (server.getTickCount() % 100 != 0) {
            return;
        }
        boolean newState = BookDataManager.get().areBooksBuilt();
        if (newState != this.wasLoaded) {
            if (!this.wasLoaded && !this.syncRequestedPlayers.isEmpty()) {
                PlayerList list = server.getPlayerList();
                for (UUID id : this.syncRequestedPlayers) {
                    ServerPlayer player = list.getPlayer(id);
                    if (player == null) continue;
                    this.updateAndSyncFor(player);
                }
                this.syncRequestedPlayers.clear();
            }
            this.wasLoaded = newState;
        }
    }
}

