/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.client.nonliving;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.liopyu.entityjs.builders.nonliving.vanilla.EyeOfEnderEntityBuilder;
import net.liopyu.entityjs.util.ContextUtils;
import net.liopyu.entityjs.util.EntityJSHelperClass;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KubeJSEnderEyeRenderer<T extends Entity>
extends EntityRenderer<T> {
    private final EyeOfEnderEntityBuilder<T> builder;

    public KubeJSEnderEyeRenderer(EntityRendererProvider.Context renderManager, EyeOfEnderEntityBuilder<T> builder) {
        super(renderManager);
        this.builder = builder;
    }

    public RenderType getRenderType(T entity) {
        if (this.builder.renderTypeFunction != null) {
            try {
                return (RenderType)this.builder.renderTypeFunction.apply(entity);
            }
            catch (RuntimeException e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("[EntityJS]: Error in renderTypeFunction. Defaulting to RenderType.entityCutoutNoCull()", e);
            }
        }
        return RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(entity));
    }

    public void render(T pEntity, float pEntityYaw, float pPartialTick, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        if (this.builder.render != null) {
            ContextUtils.NLRenderContext<T> context = new ContextUtils.NLRenderContext<T>(pEntity, pEntityYaw, pPartialTick, pMatrixStack, pBuffer, pPackedLight);
            EntityJSHelperClass.consumerCallback(this.builder.render, context, "[EntityJS]: Error in " + String.valueOf(pEntity.getType()) + "builder for field: render.");
        }
        pMatrixStack.pushPose();
        if (this.builder.renderScale((Float)this.builder.pX, (Float)this.builder.pY, (Float)this.builder.pZ).pX != null && this.builder.renderScale((Float)this.builder.pX, (Float)this.builder.pY, (Float)this.builder.pZ).pY != null && this.builder.renderScale((Float)this.builder.pX, (Float)this.builder.pY, (Float)this.builder.pZ).pZ != null) {
            float pX = this.builder.renderScale((Float)this.builder.pX, (Float)this.builder.pY, (Float)this.builder.pZ).pX.floatValue();
            float pY = this.builder.renderScale((Float)this.builder.pX, (Float)this.builder.pY, (Float)this.builder.pZ).pY.floatValue();
            float pZ = this.builder.renderScale((Float)this.builder.pX, (Float)this.builder.pY, (Float)this.builder.pZ).pZ.floatValue();
            pMatrixStack.scale(pX, pY, pZ);
        } else {
            pMatrixStack.scale(2.0f, 2.0f, 2.0f);
        }
        pMatrixStack.pushPose();
        pMatrixStack.scale(2.0f, 2.0f, 2.0f);
        pMatrixStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose posestack$pose = pMatrixStack.last();
        VertexConsumer vertexconsumer = pBuffer.getBuffer(this.getRenderType(pEntity));
        this.vertex(vertexconsumer, posestack$pose, pPackedLight, 0.0f, 0, 0, 1);
        this.vertex(vertexconsumer, posestack$pose, pPackedLight, 1.0f, 0, 1, 1);
        this.vertex(vertexconsumer, posestack$pose, pPackedLight, 1.0f, 1, 1, 0);
        this.vertex(vertexconsumer, posestack$pose, pPackedLight, 0.0f, 1, 0, 0);
        pMatrixStack.popPose();
        pMatrixStack.popPose();
        super.render(pEntity, pEntityYaw, pPartialTick, pMatrixStack, pBuffer, pPackedLight);
    }

    public void vertex(VertexConsumer p_254095_, PoseStack.Pose p_324420_, int p_253829_, float p_253995_, int p_254031_, int p_253641_, int p_254243_) {
        if (this.builder.renderOffset((Float)this.builder.vX, (Float)this.builder.vY, (Float)this.builder.vZ).vX != null && this.builder.renderOffset((Float)this.builder.vX, (Float)this.builder.vY, (Float)this.builder.vZ).vY != null && this.builder.renderOffset((Float)this.builder.vX, (Float)this.builder.vY, (Float)this.builder.vZ).vZ != null) {
            float vX = this.builder.renderOffset((Float)this.builder.vX, (Float)this.builder.vY, (Float)this.builder.vZ).vX.floatValue();
            float vY = this.builder.renderOffset((Float)this.builder.vX, (Float)this.builder.vY, (Float)this.builder.vZ).vY.floatValue();
            float vZ = this.builder.renderOffset((Float)this.builder.vX, (Float)this.builder.vY, (Float)this.builder.vZ).vZ.floatValue();
            p_254095_.addVertex(p_324420_, p_253995_ + vX, (float)p_254031_ + vY, 0.0f + vZ).setColor(-1).setUv((float)p_253641_, (float)p_254243_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_253829_).setNormal(p_324420_, 0.0f, 1.0f, 0.0f);
        } else {
            p_254095_.addVertex(p_324420_, p_253995_ - 0.5f, (float)p_254031_ - 0.25f, 0.0f).setColor(255, 255, 255, 255).setUv((float)p_253641_, (float)p_254243_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_253829_).setNormal(p_324420_, 0.0f, 1.0f, 0.0f);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (this.builder != null && this.builder.textureLocation != null) {
            try {
                Object obj = EntityJSHelperClass.convertObjectToDesired(this.builder.textureLocation.apply(entity), "resourcelocation");
                if (obj != null) {
                    return (ResourceLocation)obj;
                }
                EntityJSHelperClass.logErrorMessageOnce("[EntityJS]: Invalid return value for textureLocation: " + String.valueOf(obj) + ". Must be a ResourceLocation. Defaulting to super method: " + String.valueOf(this.getDynamicTextureLocation()));
            }
            catch (Exception e) {
                EntityJSHelperClass.logErrorMessageOnceCatchable("", e);
            }
        }
        return this.getDynamicTextureLocation();
    }

    private ResourceLocation getDynamicTextureLocation() {
        return ResourceLocation.parse((String)(this.builder.id.getNamespace() + ":textures/entity/projectiles/" + this.builder.id.getPath() + ".png"));
    }
}

