/*
 * Decompiled with CFR 0.152.
 */
package net.liopyu.entityjs.util.data;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.liopyu.entityjs.util.EntitySerializerType;
import net.liopyu.entityjs.util.data.ClientCache;
import net.liopyu.entityjs.util.data.ServerCache;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="entityjs", bus=EventBusSubscriber.Bus.MOD)
public final class Net {
    private static final String PROTO = "1";
    private static volatile boolean REGISTERED = false;
    private static final StreamCodec<ByteBuf, Map<String, Tag>> TAG_MAP = ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.TAG);
    private static final StreamCodec<ByteBuf, Map<String, Integer>> INT_MAP = ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.VAR_INT);

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent e) {
        if (REGISTERED) {
            return;
        }
        REGISTERED = true;
        PayloadRegistrar r = e.registrar(PROTO);
        r.playToClient(SetTypedValueS2C.TYPE, SetTypedValueS2C.STREAM_CODEC, (msg, ctx) -> ctx.enqueueWork(() -> {
            ClientCache.setType(msg.entityId(), msg.name(), msg.ord());
            ClientCache.set(msg.entityId(), msg.name(), msg.value());
        }));
        r.playToClient(SyncAllS2C.TYPE, SyncAllS2C.STREAM_CODEC, (msg, ctx) -> ctx.enqueueWork(() -> ClientCache.setAll(msg.entityId(), msg.values(), msg.types())));
        r.playToClient(SetTypeS2C.TYPE, SetTypeS2C.STREAM_CODEC, (msg, ctx) -> ctx.enqueueWork(() -> ClientCache.setType(msg.entityId(), msg.name(), msg.ord())));
        r.playToClient(SetValueS2C.TYPE, SetValueS2C.STREAM_CODEC, (msg, ctx) -> ctx.enqueueWork(() -> ClientCache.set(msg.entityId(), msg.name(), msg.value())));
        r.playToServer(SetValueC2S.TYPE, SetValueC2S.STREAM_CODEC, (msg, ctx) -> {
            Player p = ctx.player();
            if (p == null) {
                return;
            }
            Entity ent = ((ServerLevel)p.level()).getEntity(msg.entityId());
            if (ent instanceof Entity) {
                Entity le = ent;
                ServerCache.set(le, msg.name(), msg.value());
            }
        });
        r.playToServer(EnsureValueC2S.TYPE, EnsureValueC2S.STREAM_CODEC, (msg, ctx) -> {
            Player p = ctx.player();
            if (p == null) {
                return;
            }
            Entity ent = ((ServerLevel)p.level()).getEntity(msg.entityId());
            if (ent instanceof Entity) {
                Entity le = ent;
                ServerCache.ensure(le, msg.name(), msg.value(), msg.serType());
            }
        });
    }

    public static void sendTypedValueTracking(Entity e, UUID id, String name, int ord, Tag value) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)e, (CustomPacketPayload)new SetTypedValueS2C(id, name, ord, value), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendAllTo(ServerPlayer p, UUID id, Map<String, Tag> values, Map<String, Integer> types) {
        PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new SyncAllS2C(id, values, types), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendAllTracking(Entity e, UUID id, Map<String, Tag> values, Map<String, Integer> types) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)e, (CustomPacketPayload)new SyncAllS2C(id, values, types), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendValueTracking(Entity e, UUID id, String name, Tag value) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)e, (CustomPacketPayload)new SetValueS2C(id, name, value), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendTypeTracking(Entity e, UUID id, String name, int ord) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)e, (CustomPacketPayload)new SetTypeS2C(id, name, ord), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendDeleteTracking(Entity e, UUID id, String name) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)e, (CustomPacketPayload)new DeleteValueS2C(id, name), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendSetToServer(UUID id, String name, Tag value) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SetValueC2S(id, name, value), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendEnsureToServer(UUID id, String name, EntitySerializerType serType, Tag value) {
        PacketDistributor.sendToServer((CustomPacketPayload)new EnsureValueC2S(id, name, serType, value), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public record SetTypedValueS2C(UUID entityId, String name, int ord, Tag value) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SetTypedValueS2C> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"entityjs", (String)"set_typed_value_s2c"));
        public static final StreamCodec<ByteBuf, SetTypedValueS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, SetTypedValueS2C::entityId, (StreamCodec)ByteBufCodecs.STRING_UTF8, SetTypedValueS2C::name, (StreamCodec)ByteBufCodecs.VAR_INT, SetTypedValueS2C::ord, (StreamCodec)ByteBufCodecs.TAG, SetTypedValueS2C::value, SetTypedValueS2C::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SyncAllS2C(UUID entityId, Map<String, Tag> values, Map<String, Integer> types) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SyncAllS2C> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"entityjs", (String)"sync_all_s2c"));
        public static final StreamCodec<ByteBuf, SyncAllS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, SyncAllS2C::entityId, TAG_MAP, SyncAllS2C::values, INT_MAP, SyncAllS2C::types, SyncAllS2C::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SetTypeS2C(UUID entityId, String name, int ord) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SetTypeS2C> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"entityjs", (String)"set_type_s2c"));
        public static final StreamCodec<ByteBuf, SetTypeS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, SetTypeS2C::entityId, (StreamCodec)ByteBufCodecs.STRING_UTF8, SetTypeS2C::name, (StreamCodec)ByteBufCodecs.VAR_INT, SetTypeS2C::ord, SetTypeS2C::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SetValueS2C(UUID entityId, String name, Tag value) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SetValueS2C> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"entityjs", (String)"set_value_s2c"));
        public static final StreamCodec<ByteBuf, SetValueS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, SetValueS2C::entityId, (StreamCodec)ByteBufCodecs.STRING_UTF8, SetValueS2C::name, (StreamCodec)ByteBufCodecs.TAG, SetValueS2C::value, SetValueS2C::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SetValueC2S(UUID entityId, String name, Tag value) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SetValueC2S> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"entityjs", (String)"set_value_c2s"));
        public static final StreamCodec<ByteBuf, SetValueC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, SetValueC2S::entityId, (StreamCodec)ByteBufCodecs.STRING_UTF8, SetValueC2S::name, (StreamCodec)ByteBufCodecs.TAG, SetValueC2S::value, SetValueC2S::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record EnsureValueC2S(UUID entityId, String name, EntitySerializerType serType, Tag value) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<EnsureValueC2S> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"entityjs", (String)"ensure_value_c2s"));
        public static final StreamCodec<ByteBuf, EnsureValueC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, EnsureValueC2S::entityId, (StreamCodec)ByteBufCodecs.STRING_UTF8, EnsureValueC2S::name, (StreamCodec)ByteBufCodecs.VAR_INT, e -> e.serType().ordinal(), (StreamCodec)ByteBufCodecs.TAG, EnsureValueC2S::value, (id, n, ord, v) -> new EnsureValueC2S((UUID)id, (String)n, EntitySerializerType.values()[ord], (Tag)v));

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record DeleteValueS2C(UUID entityId, String name) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<DeleteValueS2C> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"entityjs", (String)"delete_value_s2c"));
        public static final StreamCodec<ByteBuf, DeleteValueS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, DeleteValueS2C::entityId, (StreamCodec)ByteBufCodecs.STRING_UTF8, DeleteValueS2C::name, DeleteValueS2C::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

